/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.config.SyslogdConfigFactory;
import org.opennms.netmgt.syslogd.CustomSyslogParser;
import org.opennms.netmgt.syslogd.JuniperSyslogParser;
import org.opennms.netmgt.syslogd.Rfc5424SyslogParser;
import org.opennms.netmgt.syslogd.SyslogFacility;
import org.opennms.netmgt.syslogd.SyslogMessage;
import org.opennms.netmgt.syslogd.SyslogNGParser;
import org.opennms.netmgt.syslogd.SyslogParser;
import org.opennms.netmgt.syslogd.SyslogSeverity;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.mock.MockLogAppender;

public class SyslogMessageTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyslogMessageTest() throws Exception {
        InputStream stream = null;
        try {
            stream = ConfigurationTestUtils.getInputStreamForResource((Object)this, (String)"/etc/syslogd-configuration.xml");
            SyslogdConfigFactory factory = new SyslogdConfigFactory(stream);
            SyslogdConfigFactory.setInstance((SyslogdConfig)factory);
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    @Before
    public void setUp() {
        MockLogAppender.setupLogging((boolean)true, (String)"TRACE");
    }

    @Test
    public void testCustomParserWithProcess() throws Exception {
        SyslogParser parser = CustomSyslogParser.getParser((String)"<6>test: 2007-01-01 127.0.0.1 OpenNMS[1234]: A SyslogNG style message");
        Assert.assertTrue((boolean)parser.find());
        SyslogMessage message = parser.parse();
        Assert.assertEquals((Object)SyslogFacility.KERNEL, (Object)message.getFacility());
        Assert.assertEquals((Object)SyslogSeverity.INFORMATIONAL, (Object)message.getSeverity());
        Assert.assertEquals((Object)"test", (Object)message.getMessageID());
        Assert.assertEquals((Object)"127.0.0.1", (Object)message.getHostName());
        Assert.assertEquals((Object)"OpenNMS", (Object)message.getProcessName());
        Assert.assertEquals((long)1234L, (long)message.getProcessId().intValue());
        Assert.assertEquals((Object)"A SyslogNG style message", (Object)message.getMessage());
    }

    @Test
    public void testCustomParserWithSimpleForwardingRegexAndSyslog21Message() throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream("<syslogd-configuration><configuration syslog-port=\"10514\" new-suspect-on-message=\"false\" forwarding-regexp=\"^((.+?) (.*))\\r?\\n?$\" matching-group-host=\"2\" matching-group-message=\"3\" discard-uei=\"DISCARD-MATCHING-MESSAGES\" /></syslogd-configuration>".getBytes());
        SyslogdConfigFactory factory = new SyslogdConfigFactory((InputStream)stream);
        SyslogdConfigFactory.setInstance((SyslogdConfig)factory);
        SyslogParser parser = CustomSyslogParser.getParser((String)"<173>Dec  7 12:02:06 10.13.110.116 mgmtd[8326]: [mgmtd.NOTICE]: Configuration saved to database initial");
        Assert.assertTrue((boolean)parser.find());
        SyslogMessage message = parser.parse();
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.set(2, 11);
        calendar.set(5, 7);
        calendar.set(11, 12);
        calendar.set(12, 2);
        calendar.set(13, 6);
        calendar.set(14, 0);
        Date date = calendar.getTime();
        LogUtils.debugf((Object)this, (String)"got message: %s", (Object[])new Object[]{message});
        Assert.assertEquals((Object)SyslogFacility.LOCAL5, (Object)message.getFacility());
        Assert.assertEquals((Object)SyslogSeverity.NOTICE, (Object)message.getSeverity());
        Assert.assertEquals(null, (Object)message.getMessageID());
        Assert.assertEquals((Object)date, (Object)message.getDate());
        Assert.assertEquals((Object)"10.13.110.116", (Object)message.getHostName());
        Assert.assertEquals((Object)"mgmtd", (Object)message.getProcessName());
        Assert.assertEquals((long)8326L, (long)message.getProcessId().intValue());
        Assert.assertEquals((Object)"[mgmtd.NOTICE]: Configuration saved to database initial", (Object)message.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomParserNms5242() throws Exception {
        Locale startLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.FRANCE);
            ByteArrayInputStream stream = new ByteArrayInputStream("<?xml version=\"1.0\"?>\n<syslogd-configuration>\n    <configuration\n            syslog-port=\"10514\"\n            new-suspect-on-message=\"false\"\n            parser=\"org.opennms.netmgt.syslogd.CustomSyslogParser\"\n            forwarding-regexp=\"^((.+?) (.*))\\n?$\"\n            matching-group-host=\"2\"\n            matching-group-message=\"3\"\n            discard-uei=\"DISCARD-MATCHING-MESSAGES\"\n            />\n\n    <hideMessage>\n        <hideMatch>\n            <match type=\"substr\" expression=\"TEST\"/>\n        </hideMatch>\n    </hideMessage>\n</syslogd-configuration>\n".getBytes());
            SyslogdConfigFactory factory = new SyslogdConfigFactory((InputStream)stream);
            SyslogdConfigFactory.setInstance((SyslogdConfig)factory);
            SyslogParser parser = CustomSyslogParser.getParser((String)"<0>Mar 14 17:10:25 petrus sudo:  cyrille : user NOT in sudoers ; TTY=pts/2 ; PWD=/home/cyrille ; USER=root ; COMMAND=/usr/bin/vi /etc/aliases");
            Assert.assertTrue((boolean)parser.find());
            SyslogMessage message = parser.parse();
            LogUtils.debugf((Object)this, (String)"message = %s", (Object[])new Object[]{message});
            Calendar cal = Calendar.getInstance();
            cal.setTimeZone(TimeZone.getTimeZone("UTC"));
            cal.set(2, 2);
            cal.set(5, 14);
            cal.set(11, 17);
            cal.set(12, 10);
            cal.set(13, 25);
            cal.set(14, 0);
            Assert.assertEquals((Object)SyslogFacility.KERNEL, (Object)message.getFacility());
            Assert.assertEquals((Object)SyslogSeverity.EMERGENCY, (Object)message.getSeverity());
            Assert.assertNull((Object)message.getMessageID());
            Assert.assertEquals((Object)cal.getTime(), (Object)message.getDate());
            Assert.assertEquals((Object)"petrus", (Object)message.getHostName());
            Assert.assertEquals((Object)"sudo", (Object)message.getProcessName());
            Assert.assertEquals((long)0L, (long)message.getProcessId().intValue());
            Assert.assertEquals((Object)"cyrille : user NOT in sudoers ; TTY=pts/2 ; PWD=/home/cyrille ; USER=root ; COMMAND=/usr/bin/vi /etc/aliases", (Object)message.getMessage());
        }
        finally {
            Locale.setDefault(startLocale);
        }
    }

    @Test
    public void testSyslogNGParserWithProcess() throws Exception {
        SyslogParser parser = SyslogNGParser.getParser((String)"<6>test: 2007-01-01 127.0.0.1 OpenNMS[1234]: A SyslogNG style message");
        Assert.assertTrue((boolean)parser.find());
        SyslogMessage message = parser.parse();
        Date date = new Date(1167609600000L);
        Assert.assertEquals((Object)SyslogFacility.KERNEL, (Object)message.getFacility());
        Assert.assertEquals((Object)SyslogSeverity.INFORMATIONAL, (Object)message.getSeverity());
        Assert.assertEquals((Object)"test", (Object)message.getMessageID());
        Assert.assertEquals((Object)date, (Object)message.getDate());
        Assert.assertEquals((Object)"127.0.0.1", (Object)message.getHostName());
        Assert.assertEquals((Object)"OpenNMS", (Object)message.getProcessName());
        Assert.assertEquals((long)1234L, (long)message.getProcessId().intValue());
        Assert.assertEquals((Object)"A SyslogNG style message", (Object)message.getMessage());
    }

    @Test
    public void testSyslogNGParserWithoutProcess() throws Exception {
        SyslogParser parser = SyslogNGParser.getParser((String)"<6>test: 2007-01-01 127.0.0.1 A SyslogNG style message");
        Assert.assertTrue((boolean)parser.find());
        SyslogMessage message = parser.parse();
        Date date = new Date(1167609600000L);
        Assert.assertEquals((Object)SyslogFacility.KERNEL, (Object)message.getFacility());
        Assert.assertEquals((Object)SyslogSeverity.INFORMATIONAL, (Object)message.getSeverity());
        Assert.assertEquals((Object)"test", (Object)message.getMessageID());
        Assert.assertEquals((Object)date, (Object)message.getDate());
        Assert.assertEquals((Object)"127.0.0.1", (Object)message.getHostName());
        Assert.assertEquals(null, (Object)message.getProcessName());
        Assert.assertEquals(null, (Object)message.getProcessId());
        Assert.assertEquals((Object)"A SyslogNG style message", (Object)message.getMessage());
    }

    @Test
    public void testSyslogNGParserWithSyslog21Message() throws Exception {
        SyslogParser parser = SyslogNGParser.getParser((String)"<173>Dec  7 12:02:06 10.13.110.116 mgmtd[8326]: [mgmtd.NOTICE]: Configuration saved to database initial");
        Assert.assertTrue((boolean)parser.find());
        SyslogMessage message = parser.parse();
        Date timestampIn2011 = new Date(1323259326000L);
        Calendar cal = Calendar.getInstance();
        int currentYear = cal.get(1);
        cal.setTime(timestampIn2011);
        cal.set(1, currentYear);
        Date timestampThisYear = cal.getTime();
        Assert.assertEquals((Object)SyslogFacility.LOCAL5, (Object)message.getFacility());
        Assert.assertEquals((Object)SyslogSeverity.NOTICE, (Object)message.getSeverity());
        Assert.assertEquals(null, (Object)message.getMessageID());
        Assert.assertEquals((Object)timestampThisYear, (Object)message.getDate());
        Assert.assertEquals((Object)"10.13.110.116", (Object)message.getHostName());
        Assert.assertEquals((Object)"mgmtd", (Object)message.getProcessName());
        Assert.assertEquals((long)8326L, (long)message.getProcessId().intValue());
        Assert.assertEquals((Object)"[mgmtd.NOTICE]: Configuration saved to database initial", (Object)message.getMessage());
    }

    @Test
    public void testRfc5424ParserExample1() throws Exception {
        SyslogParser parser = Rfc5424SyslogParser.getParser((String)"<34>1 2003-10-11T22:14:15.000Z mymachine.example.com su - ID47 - BOM'su root' failed for lonvick on /dev/pts/8");
        Assert.assertTrue((boolean)parser.find());
        SyslogMessage message = parser.parse();
        Date date = new Date(1065910455000L);
        Assert.assertEquals((long)1L, (long)message.getVersion().intValue());
        Assert.assertEquals((Object)SyslogFacility.AUTH, (Object)message.getFacility());
        Assert.assertEquals((Object)SyslogSeverity.CRITICAL, (Object)message.getSeverity());
        Assert.assertEquals((Object)date, (Object)message.getDate());
        Assert.assertEquals((Object)"mymachine.example.com", (Object)message.getHostName());
        Assert.assertEquals((Object)"su", (Object)message.getProcessName());
        Assert.assertEquals((Object)"ID47", (Object)message.getMessageID());
        Assert.assertEquals((Object)"'su root' failed for lonvick on /dev/pts/8", (Object)message.getMessage());
    }

    @Test
    public void testRfc5424ParserExample2() throws Exception {
        SyslogParser parser = Rfc5424SyslogParser.getParser((String)"<165>1 2003-10-11T22:14:15.000003-00:00 192.0.2.1 myproc 8710 - - %% It's time to make the do-nuts.");
        Assert.assertTrue((boolean)parser.find());
        SyslogMessage message = parser.parse();
        Date date = new Date(1065910455003L);
        Assert.assertEquals((Object)SyslogFacility.LOCAL4, (Object)message.getFacility());
        Assert.assertEquals((Object)SyslogSeverity.NOTICE, (Object)message.getSeverity());
        Assert.assertEquals((long)1L, (long)message.getVersion().intValue());
        Assert.assertEquals((Object)date, (Object)message.getDate());
        Assert.assertEquals((Object)"192.0.2.1", (Object)message.getHostName());
        Assert.assertEquals((Object)"myproc", (Object)message.getProcessName());
        Assert.assertEquals((long)8710L, (long)message.getProcessId().intValue());
        Assert.assertEquals(null, (Object)message.getMessageID());
        Assert.assertEquals((Object)"%% It's time to make the do-nuts.", (Object)message.getMessage());
    }

    @Test
    public void testRfc5424ParserExample3() throws Exception {
        SyslogParser parser = Rfc5424SyslogParser.getParser((String)"<165>1 2003-10-11T22:14:15.003Z mymachine.example.com evntslog - ID47 [exampleSDID@32473 iut=\"3\" eventSource=\"Application\" eventID=\"1011\"] BOMAn application event log entry...");
        Assert.assertTrue((boolean)parser.find());
        SyslogMessage message = parser.parse();
        Assert.assertEquals((Object)SyslogFacility.LOCAL4, (Object)message.getFacility());
        Assert.assertEquals((Object)SyslogSeverity.NOTICE, (Object)message.getSeverity());
        Assert.assertEquals((long)1L, (long)message.getVersion().intValue());
        Assert.assertEquals((Object)"mymachine.example.com", (Object)message.getHostName());
        Assert.assertEquals((Object)"evntslog", (Object)message.getProcessName());
        Assert.assertEquals(null, (Object)message.getProcessId());
        Assert.assertEquals((Object)"ID47", (Object)message.getMessageID());
        Assert.assertEquals((Object)"An application event log entry...", (Object)message.getMessage());
    }

    @Test
    public void testRfc5424ParserExample4() throws Exception {
        SyslogParser parser = Rfc5424SyslogParser.getParser((String)"<165>1 2003-10-11T22:14:15.003Z mymachine.example.com evntslog - ID47 [exampleSDID@32473 iut=\"3\" eventSource=\"Application\" eventID=\"1011\"][examplePriority@32473 class=\"high\"]");
        Assert.assertTrue((boolean)parser.find());
        SyslogMessage message = parser.parse();
        Assert.assertEquals((Object)SyslogFacility.LOCAL4, (Object)message.getFacility());
        Assert.assertEquals((Object)SyslogSeverity.NOTICE, (Object)message.getSeverity());
        Assert.assertEquals((long)1L, (long)message.getVersion().intValue());
        Assert.assertEquals((Object)"mymachine.example.com", (Object)message.getHostName());
        Assert.assertEquals((Object)"evntslog", (Object)message.getProcessName());
        Assert.assertEquals(null, (Object)message.getProcessId());
        Assert.assertEquals((Object)"ID47", (Object)message.getMessageID());
    }

    @Test
    public void testRfc5424Nms5051() throws Exception {
        SyslogParser parser = Rfc5424SyslogParser.getParser((String)"<85>1 2011-11-15T14:42:18+01:00 hostname sudo - - - pam_unix(sudo:auth): authentication failure; logname=username uid=0 euid=0 tty=/dev/pts/0 ruser=username rhost= user=username");
        Assert.assertTrue((boolean)parser.find());
        SyslogMessage message = parser.parse();
        Assert.assertEquals((Object)SyslogFacility.AUTHPRIV, (Object)message.getFacility());
        Assert.assertEquals((Object)SyslogSeverity.NOTICE, (Object)message.getSeverity());
        Assert.assertEquals((long)1L, (long)message.getVersion().intValue());
        Assert.assertEquals((Object)"hostname", (Object)message.getHostName());
        Assert.assertEquals((Object)"sudo", (Object)message.getProcessName());
        Assert.assertEquals(null, (Object)message.getProcessId());
        Assert.assertEquals(null, (Object)message.getMessageID());
    }

    @Test
    public void testJuniperCFMFault() throws Exception {
        SyslogParser parser = JuniperSyslogParser.getParser((String)"<7>Nov 17 03:38:24 junos-mx480-space cfmd[1461]: CFMD_CCM_DEFECT_RMEP: CFM defect: Remote CCM timeout detected by MEP on Level: 0 MD: customer MA: customer-site1 Interface: ge-5/0/2.0");
        Assert.assertTrue((boolean)parser.find());
        SyslogMessage message = parser.parse();
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)SyslogFacility.KERNEL, (Object)message.getFacility());
        Assert.assertEquals((Object)SyslogSeverity.DEBUG, (Object)message.getSeverity());
        Assert.assertEquals((Object)"junos-mx480-space", (Object)message.getHostName());
        Assert.assertEquals((Object)"cfmd", (Object)message.getProcessName());
        Assert.assertEquals((Object)1461, (Object)message.getProcessId());
        Assert.assertEquals(null, (Object)message.getMessageID());
    }
}

