/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.statsd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.opennms.netmgt.dao.FilterDao;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.dao.RrdDao;
import org.opennms.netmgt.dao.castor.statsd.PackageReport;
import org.opennms.netmgt.dao.castor.statsd.StatsdPackage;
import org.opennms.netmgt.dao.support.BottomNAttributeStatisticVisitor;
import org.opennms.netmgt.dao.support.MockResourceType;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.ExternalValueAttribute;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.statsd.RelativeTime;
import org.opennms.netmgt.statsd.ReportDefinition;
import org.opennms.netmgt.statsd.ReportInstance;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.test.mock.EasyMockUtils;

public class ReportDefinitionTest
extends TestCase {
    private EasyMockUtils m_mocks = new EasyMockUtils();
    private ResourceDao m_resourceDao = (ResourceDao)this.m_mocks.createMock(ResourceDao.class);
    private RrdDao m_rrdDao = (RrdDao)this.m_mocks.createMock(RrdDao.class);
    private FilterDao m_filterDao = (FilterDao)this.m_mocks.createMock(FilterDao.class);

    protected void runTest() throws Throwable {
        super.runTest();
        this.m_mocks.verifyAll();
    }

    public void testBogusReportClass() throws Exception {
        this.m_mocks.replayAll();
        ReportDefinition def = new ReportDefinition();
        Class<?> clazz = Class.forName("java.lang.String");
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("*** ThrowableAnticipator ignore Throwable.getMessage() ***"));
        try {
            def.setReportClass(clazz);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testAfterPropertiesSet() {
        this.m_mocks.replayAll();
        this.createReportDefinition();
    }

    public void testReportWalking() throws Exception {
        EasyMock.expect((Object)this.m_resourceDao.findTopLevelResources()).andReturn(new ArrayList(0));
        ReportDefinition def = this.createReportDefinition();
        def.setResourceAttributeKey("ifSpeed");
        def.setResourceAttributeValueMatch("100000000");
        ReportInstance report = def.createReport(this.m_resourceDao, this.m_rrdDao, this.m_filterDao);
        this.m_mocks.replayAll();
        report.walk();
        ReportDefinitionTest.assertEquals((String)"results size", (int)0, (int)report.getResults().size());
    }

    public void testUnfilteredResourceAttributeFilteringWithNoMatch() throws Exception {
        MockResourceType resourceType = new MockResourceType();
        resourceType.setName("interfaceSnmp");
        RrdGraphAttribute attribute = new RrdGraphAttribute("IfInOctets", "something", "something else");
        OnmsResource resource = new OnmsResource("1", "Node One", (OnmsResourceType)resourceType, Collections.singleton(attribute));
        EasyMock.expect((Object)this.m_resourceDao.findTopLevelResources()).andReturn(Collections.singletonList(resource));
        ReportDefinition def = this.createReportDefinition();
        def.setResourceAttributeKey("ifSpeed");
        def.setResourceAttributeValueMatch("100000000");
        ReportInstance report = def.createReport(this.m_resourceDao, this.m_rrdDao, this.m_filterDao);
        this.m_mocks.replayAll();
        report.walk();
        ReportDefinitionTest.assertEquals((String)"results size", (int)0, (int)report.getResults().size());
    }

    public void testUnfilteredResourceAttributeFilteringWithMatch() throws Exception {
        RrdGraphAttribute rrdAttribute = new RrdGraphAttribute("IfInOctets", "something", "something else");
        ExternalValueAttribute externalValueAttribute = new ExternalValueAttribute("ifSpeed", "100000000");
        HashSet<Object> attributes = new HashSet<Object>();
        attributes.add(rrdAttribute);
        attributes.add(externalValueAttribute);
        MockResourceType resourceType = new MockResourceType();
        resourceType.setName("interfaceSnmp");
        OnmsResource resource = new OnmsResource("1", "Node One", (OnmsResourceType)resourceType, attributes);
        EasyMock.expect((Object)this.m_resourceDao.findTopLevelResources()).andReturn(Collections.singletonList(resource));
        ReportDefinition def = this.createReportDefinition();
        def.setResourceAttributeKey(externalValueAttribute.getName());
        def.setResourceAttributeValueMatch(externalValueAttribute.getValue());
        ReportInstance report = def.createReport(this.m_resourceDao, this.m_rrdDao, this.m_filterDao);
        EasyMock.expect((Object)this.m_rrdDao.getPrintValue((OnmsAttribute)rrdAttribute, def.getConsolidationFunction(), report.getStartTime(), report.getEndTime())).andReturn((Object)1.0);
        this.m_mocks.replayAll();
        report.walk();
        this.m_mocks.verifyAll();
        ReportDefinitionTest.assertEquals((String)"results size", (int)1, (int)report.getResults().size());
        this.m_mocks.replayAll();
    }

    public void testFilteredResourceAttributeFilteringWithNoMatch() throws Exception {
        final OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(1));
        node.setLabel("Node One");
        MockResourceType resourceType = new MockResourceType();
        resourceType.setName("interfaceSnmp");
        RrdGraphAttribute attribute = new RrdGraphAttribute("IfInOctets", "something", "something else");
        OnmsResource resource = new OnmsResource(node.getId().toString(), node.getLabel(), (OnmsResourceType)resourceType, Collections.singleton(attribute));
        ReportDefinition def = this.createReportDefinition();
        def.getReport().getPackage().setFilter("");
        def.setResourceAttributeKey("ifSpeed");
        def.setResourceAttributeValueMatch("100000000");
        ReportInstance report = def.createReport(this.m_resourceDao, this.m_rrdDao, this.m_filterDao);
        this.m_filterDao.walkMatchingNodes((String)EasyMock.eq((Object)""), (EntityVisitor)EasyMock.isA(EntityVisitor.class));
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

            public Object answer() throws Throwable {
                ((EntityVisitor)EasyMock.getCurrentArguments()[1]).visitNode(node);
                return null;
            }
        });
        EasyMock.expect((Object)this.m_resourceDao.getResourceForNode(node)).andReturn((Object)resource);
        this.m_mocks.replayAll();
        report.walk();
        ReportDefinitionTest.assertEquals((String)"results size", (int)0, (int)report.getResults().size());
    }

    public void testFilteredResourceAttributeFilteringWithMatch() throws Exception {
        RrdGraphAttribute rrdAttribute = new RrdGraphAttribute("IfInOctets", "something", "something else");
        ExternalValueAttribute externalValueAttribute = new ExternalValueAttribute("ifSpeed", "100000000");
        HashSet<Object> attributes = new HashSet<Object>();
        attributes.add(rrdAttribute);
        attributes.add(externalValueAttribute);
        final OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(1));
        node.setLabel("Node One");
        MockResourceType resourceType = new MockResourceType();
        resourceType.setName("interfaceSnmp");
        OnmsResource resource = new OnmsResource(node.getId().toString(), node.getLabel(), (OnmsResourceType)resourceType, attributes);
        ReportDefinition def = this.createReportDefinition();
        def.getReport().getPackage().setFilter("");
        def.setResourceAttributeKey(externalValueAttribute.getName());
        def.setResourceAttributeValueMatch(externalValueAttribute.getValue());
        ReportInstance report = def.createReport(this.m_resourceDao, this.m_rrdDao, this.m_filterDao);
        this.m_filterDao.walkMatchingNodes((String)EasyMock.eq((Object)""), (EntityVisitor)EasyMock.isA(EntityVisitor.class));
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

            public Object answer() throws Throwable {
                ((EntityVisitor)EasyMock.getCurrentArguments()[1]).visitNode(node);
                return null;
            }
        });
        EasyMock.expect((Object)this.m_resourceDao.getResourceForNode(node)).andReturn((Object)resource);
        EasyMock.expect((Object)this.m_rrdDao.getPrintValue((OnmsAttribute)rrdAttribute, def.getConsolidationFunction(), report.getStartTime(), report.getEndTime())).andReturn((Object)1.0);
        this.m_mocks.replayAll();
        report.walk();
        ReportDefinitionTest.assertEquals((String)"results size", (int)1, (int)report.getResults().size());
    }

    private ReportDefinition createReportDefinition() {
        ReportDefinition def = new ReportDefinition();
        def.setReport(this.createPackageReport());
        def.setCount(Integer.valueOf(10));
        def.setConsolidationFunction("AVERAGE");
        def.setRelativeTime(RelativeTime.LASTHOUR);
        def.setResourceTypeMatch("interfaceSnmp");
        def.setAttributeMatch("IfInOctets");
        def.setReportClass(BottomNAttributeStatisticVisitor.class);
        def.afterPropertiesSet();
        return def;
    }

    private PackageReport createPackageReport() {
        PackageReport packageReport = new PackageReport();
        packageReport.setDescription("a package!");
        packageReport.setEnabled(true);
        packageReport.setPackage(new StatsdPackage());
        packageReport.setReport(null);
        packageReport.setRetainInterval(new Long(86400000L));
        packageReport.setSchedule("hmm");
        return packageReport;
    }
}

