/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmpinterfacepoller.pollable;

import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollContext;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-proxy-snmp.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath:/META-INF/opennms/applicationContext-snmpinterfacepollerd.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class PollContextTest {
    @Autowired
    private PollContext m_pollContext;
    @Autowired
    private NodeDao m_nodeDao;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        NetworkBuilder nb = new NetworkBuilder();
        nb.addNode("cisco2691").setForeignSource("linkd").setForeignId("cisco2691").setSysObjectId(".1.3.6.1.4.1.9.1.122").setType("A");
        nb.addInterface("10.1.4.2").setIsSnmpPrimary("P").setIsManaged("M").addSnmpInterface(4).setIfType(Integer.valueOf(6)).setCollectionEnabled(false).setIfSpeed(10000000L).setPhysAddr("c00397a70001").setIfOperStatus(Integer.valueOf(2)).setIfDescr("Null0");
        nb.addInterface("10.1.5.1").setIsSnmpPrimary("S").setIsManaged("M").addSnmpInterface(2).setIfType(Integer.valueOf(6)).setCollectionEnabled(false).setIfSpeed(100000000L).setPhysAddr("c00397a70000").setIfOperStatus(Integer.valueOf(1)).setIfDescr("FastEthernet0");
        nb.addInterface("10.1.7.1").setIsSnmpPrimary("S").setIsManaged("M").addSnmpInterface(1).setIfType(Integer.valueOf(6)).setCollectionEnabled(false).setIfSpeed(100000000L).setPhysAddr("c00397a70010").setIfOperStatus(Integer.valueOf(1)).setIfDescr("Ethernet0");
        for (OnmsSnmpInterface iface : nb.getCurrentNode().getSnmpInterfaces()) {
            iface.setPoll("P");
        }
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("cisco1700").setForeignSource("linkd").setForeignId("cisco1700").setSysObjectId(".1.3.6.1.4.1.9.1.200").setType("A");
        nb.addInterface("10.1.5.2").setIsSnmpPrimary("P").setIsManaged("M").addSnmpInterface(2).setIfType(Integer.valueOf(6)).setCollectionEnabled(true).setIfSpeed(100000000L).setPhysAddr("d00297a60000");
        for (OnmsSnmpInterface iface : nb.getCurrentNode().getSnmpInterfaces()) {
            iface.setPoll("P");
        }
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        this.m_nodeDao.flush();
    }

    @After
    public void tearDown() throws Exception {
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            this.m_nodeDao.delete((Object)node);
        }
        this.m_nodeDao.flush();
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    public void testCriterias() throws Exception {
        Assert.assertNotNull((Object)this.m_pollContext);
        OnmsNode node = this.m_nodeDao.findByForeignId("linkd", "cisco2691");
        Assert.assertNotNull((Object)node);
        List ipInterfaces = this.m_pollContext.getPollableNodes();
        Assert.assertNotNull((Object)ipInterfaces);
        Assert.assertEquals((long)2L, (long)ipInterfaces.size());
        ipInterfaces = this.m_pollContext.getPollableNodesByIp("10.1.4.2");
        Assert.assertNotNull((Object)ipInterfaces);
        Assert.assertEquals((long)1L, (long)ipInterfaces.size());
        ipInterfaces = this.m_pollContext.getPollableNodesByIp("10.1.5.1");
        Assert.assertNotNull((Object)ipInterfaces);
        Assert.assertEquals((long)0L, (long)ipInterfaces.size());
        String criteria = "snmpifdescr like '%Ethernet%' and ipinterfac1_.ipaddr like '10.1.5.%'";
        List snmpInterfaces = this.m_pollContext.get(node.getId().intValue(), criteria);
        Assert.assertNotNull((Object)snmpInterfaces);
        Assert.assertEquals((long)1L, (long)snmpInterfaces.size());
    }
}

