/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.db.TemporaryDatabase;
import org.opennms.netmgt.dao.db.TemporaryDatabaseAware;
import org.opennms.netmgt.poller.remote.PollerFrontEnd;
import org.opennms.netmgt.poller.remote.PollerSettings;
import org.opennms.test.FileAnticipator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.PropertyOverrideConfigurer;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-pollerBackEnd.xml", "classpath:/META-INF/opennms/applicationContext-exportedPollerBackEnd-rmi.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/org/opennms/netmgt/poller/remote/applicationContext-configOverride.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class PollerFrontEndIntegrationTest
implements InitializingBean,
TemporaryDatabaseAware<TemporaryDatabase> {
    @Autowired
    private DatabasePopulator m_populator;
    private FileAnticipator m_fileAnticipator;
    private PollerFrontEnd m_frontEnd;
    private PollerSettings m_settings;
    private ClassPathXmlApplicationContext m_frontEndContext;
    private TemporaryDatabase m_database;

    public void setTemporaryDatabase(TemporaryDatabase database) {
        this.m_database = database;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.assertNotNull((Object)this.m_populator);
    }

    @After
    public void afterTest() throws Throwable {
        this.m_frontEndContext.stop();
        this.m_frontEndContext.close();
        if (this.m_fileAnticipator.isInitialized()) {
            this.m_fileAnticipator.deleteExpected();
        }
        this.m_fileAnticipator.tearDown();
    }

    @Before
    public void onSetUpInTransactionIfEnabled() throws Exception {
        this.m_fileAnticipator = new FileAnticipator();
        String filename = this.m_fileAnticipator.expecting("remote-poller.configuration").getCanonicalPath();
        filename = filename.replace("+", "%2B");
        System.setProperty("opennms.poller.configuration.resource", "file://" + filename);
        this.m_populator.populateDatabase();
        this.m_frontEndContext = new ClassPathXmlApplicationContext(new String[]{"classpath:/META-INF/opennms/applicationContext-remotePollerBackEnd-rmi.xml", "classpath:/META-INF/opennms/applicationContext-pollerFrontEnd.xml"}, false);
        Properties props = new Properties();
        props.setProperty("configCheckTrigger.repeatInterval", "1000");
        PropertyOverrideConfigurer testPropertyConfigurer = new PropertyOverrideConfigurer();
        testPropertyConfigurer.setProperties(props);
        this.m_frontEndContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)testPropertyConfigurer);
        this.m_frontEndContext.refresh();
        this.m_frontEnd = (PollerFrontEnd)this.m_frontEndContext.getBean("pollerFrontEnd");
        this.m_settings = (PollerSettings)this.m_frontEndContext.getBean("pollerSettings");
    }

    @Test
    public void testRegister() throws Exception {
        Assert.assertFalse((boolean)this.m_frontEnd.isRegistered());
        Assert.assertEquals((long)0L, (long)this.m_database.getJdbcTemplate().queryForInt("select count(*) from location_monitors", new Object[0]));
        Assert.assertEquals((long)0L, (long)this.m_database.getJdbcTemplate().queryForInt("select count(*) from location_monitor_details", new Object[0]));
        Assert.assertTrue((String)"There were unexpected poll results", (0 == this.m_database.getJdbcTemplate().queryForInt("select count(*) from location_specific_status_changes", new Object[0]) ? 1 : 0) != 0);
        this.m_frontEnd.register("RDU");
        Integer monitorId = this.m_settings.getMonitorId();
        Assert.assertTrue((boolean)this.m_frontEnd.isRegistered());
        Assert.assertEquals((long)1L, (long)this.m_database.getJdbcTemplate().queryForInt("select count(*) from location_monitors where id=?", new Object[]{monitorId}));
        Assert.assertEquals((long)5L, (long)this.m_database.getJdbcTemplate().queryForInt("select count(*) from location_monitor_details where locationMonitorId = ?", new Object[]{monitorId}));
        Assert.assertEquals((Object)System.getProperty("os.name"), (Object)this.m_database.getJdbcTemplate().queryForObject("select propertyValue from location_monitor_details where locationMonitorId = ? and property = ?", String.class, new Object[]{monitorId, "os.name"}));
        Thread.sleep(60000L);
        Assert.assertEquals((long)1L, (long)this.m_database.getJdbcTemplate().queryForInt("select count(*) from location_monitors where id=?", new Object[]{monitorId}));
        Assert.assertEquals((long)0L, (long)this.m_database.getJdbcTemplate().queryForInt("select count(*) from location_monitors where status='DISCONNECTED' and id=?", new Object[]{monitorId}));
        Assert.assertTrue((String)"Could not find any pollResults", (0 < this.m_database.getJdbcTemplate().queryForInt("select count(*) from location_specific_status_changes where locationMonitorId = ?", new Object[]{monitorId}) ? 1 : 0) != 0);
        this.m_frontEnd.stop();
    }
}

