/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.annotations.JUnitHttpServer;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.mock.MockMonitoredService;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.MonitorTestUtils;
import org.opennms.netmgt.poller.monitors.TcpMonitor;
import org.opennms.test.mock.MockLogAppender;
import org.opennms.test.mock.MockUtil;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/emptyContext.xml"})
@JUnitConfigurationEnvironment
public class TcpMonitorTest {
    private boolean m_runTests = true;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
    }

    @Test
    public void testExternalServerConnection() throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        TcpMonitor monitor = new TcpMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService(99, "www.opennms.org", "TCP");
        p.setKey("port");
        p.setValue("3020");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("1");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        PollStatus status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)2L, (long)status.getStatusCode());
        Assert.assertNotNull((Object)status.getReason());
    }

    @Test
    @JUnitHttpServer(port=10342)
    public void testLocalhostConnection() throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        TcpMonitor monitor = new TcpMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService(3, "localhost", "TCP");
        p.setKey("port");
        p.setValue("10342");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("1");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        PollStatus status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
    }

    @Test
    @JUnitHttpServer(port=10342)
    public void testLocalhostIPv6Connection() throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        TcpMonitor monitor = new TcpMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService(3, "::1", "TCP");
        p.setKey("port");
        p.setValue("10342");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("1");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        PollStatus status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
    }
}

