/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.LinkdConfig;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.dao.DataLinkInterfaceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-proxy-snmp.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath:/META-INF/opennms/applicationContext-linkd.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/applicationContext-minimal-conf.xml", "classpath:/applicationContext-linkd-test.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class LinkdTest {
    @Autowired
    private Linkd m_linkd;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private DataLinkInterfaceDao m_dataLinkInterfaceDao;
    @Autowired
    private LinkdConfig m_linkdConfig;

    @Before
    public void setUp() throws Exception {
        Properties p = new Properties();
        p.setProperty("log4j.logger.org.hibernate.SQL", "WARN");
        MockLogAppender.setupLogging((Properties)p);
        NetworkBuilder nb = new NetworkBuilder();
        nb.addNode("test.example.com").setForeignSource("linkd").setForeignId("1").setSysObjectId(".1.3.6.1.4.1.1724.81").setType("A");
        nb.addInterface("192.168.1.10").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("laptop").setForeignSource("linkd").setForeignId("laptop").setSysObjectId(".1.3.6.1.4.1.8072.3.2.255").setType("A");
        nb.addInterface("10.1.1.2").setIsSnmpPrimary("P").setIsManaged("M").addSnmpInterface(10).setIfType(Integer.valueOf(6)).setCollectionEnabled(true).setIfSpeed(1000000000L).setPhysAddr("065568ae696c");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("cisco7200a").setForeignSource("linkd").setForeignId("cisco7200a").setSysObjectId(".1.3.6.1.4.1.9.1.222").setType("A");
        nb.addInterface("10.1.1.1").setIsSnmpPrimary("P").setIsManaged("M").addSnmpInterface(3).setIfType(Integer.valueOf(6)).setCollectionEnabled(true).setIfSpeed(1000000000L).setPhysAddr("ca0497a80038");
        nb.addInterface("10.1.2.1").setIsSnmpPrimary("S").setIsManaged("M").addSnmpInterface(2).setIfType(Integer.valueOf(6)).setCollectionEnabled(false).setIfSpeed(100000000L).setPhysAddr("ca0497a8001c");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("cisco7200b").setForeignSource("linkd").setForeignId("cisco7200b").setSysObjectId(".1.3.6.1.4.1.9.1.222").setType("A");
        nb.addInterface("10.1.2.2").setIsSnmpPrimary("P").setIsManaged("M").addSnmpInterface(4).setIfType(Integer.valueOf(6)).setCollectionEnabled(true).setIfSpeed(10000000L).setPhysAddr("ca0597a80038");
        nb.addInterface("10.1.3.1").setIsSnmpPrimary("S").setIsManaged("M").addSnmpInterface(2).setIfType(Integer.valueOf(6)).setCollectionEnabled(false).setIfSpeed(100000000L).setPhysAddr("ca0597a8001c");
        nb.addInterface("10.1.4.1").setIsSnmpPrimary("S").setIsManaged("M").addSnmpInterface(1).setIfType(Integer.valueOf(6)).setCollectionEnabled(false).setIfSpeed(100000000L).setPhysAddr("ca0597a80000");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("cisco3700").setForeignSource("linkd").setForeignId("cisco3700").setSysObjectId(".1.3.6.1.4.1.9.1.122").setType("A");
        nb.addInterface("10.1.3.2").setIsSnmpPrimary("P").setIsManaged("M").addSnmpInterface(1).setIfType(Integer.valueOf(6)).setCollectionEnabled(true).setIfSpeed(10000000L).setPhysAddr("c20197a50000");
        nb.addInterface("10.1.6.1").setIsSnmpPrimary("S").setIsManaged("M").addSnmpInterface(3).setIfType(Integer.valueOf(6)).setCollectionEnabled(false).setIfSpeed(1000000000L).setPhysAddr("c20197a50001");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("cisco2691").setForeignSource("linkd").setForeignId("cisco2691").setSysObjectId(".1.3.6.1.4.1.9.1.122").setType("A");
        nb.addInterface("10.1.4.2").setIsSnmpPrimary("P").setIsManaged("M").addSnmpInterface(4).setIfType(Integer.valueOf(6)).setCollectionEnabled(false).setIfSpeed(10000000L).setPhysAddr("c00397a70001");
        nb.addInterface("10.1.5.1").setIsSnmpPrimary("S").setIsManaged("M").addSnmpInterface(2).setIfType(Integer.valueOf(6)).setCollectionEnabled(false).setIfSpeed(100000000L).setPhysAddr("c00397a70000");
        nb.addInterface("10.1.7.1").setIsSnmpPrimary("S").setIsManaged("M").addSnmpInterface(1).setIfType(Integer.valueOf(6)).setCollectionEnabled(false).setIfSpeed(100000000L).setPhysAddr("c00397a70010");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("cisco1700").setForeignSource("linkd").setForeignId("cisco1700").setSysObjectId(".1.3.6.1.4.1.9.1.200").setType("A");
        nb.addInterface("10.1.5.2").setIsSnmpPrimary("P").setIsManaged("M").addSnmpInterface(2).setIfType(Integer.valueOf(6)).setCollectionEnabled(true).setIfSpeed(100000000L).setPhysAddr("d00297a60000");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("cisco3600").setForeignSource("linkd").setForeignId("cisco3600").setSysObjectId(".1.3.6.1.4.1.9.1.122").setType("A");
        nb.addInterface("10.1.6.2").setIsSnmpPrimary("P").setIsManaged("M").addSnmpInterface(1).setIfType(Integer.valueOf(6)).setCollectionEnabled(true).setIfSpeed(100000000L).setPhysAddr("cc0097a30000");
        nb.addInterface("10.1.7.2").setIsSnmpPrimary("S").setIsManaged("M").addSnmpInterface(2).setIfType(Integer.valueOf(6)).setCollectionEnabled(false).setIfSpeed(100000000L).setPhysAddr("cc0097a30010");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        this.m_nodeDao.flush();
        for (Package pkg : Collections.list(this.m_linkdConfig.enumeratePackage())) {
            pkg.setForceIpRouteDiscoveryOnEthernet(true);
        }
    }

    @After
    public void tearDown() throws Exception {
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            this.m_nodeDao.delete((Object)node);
        }
        this.m_nodeDao.flush();
    }

    @Test
    @Ignore
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.5.1", port=161, resource="classpath:linkd/cisco1700b.properties"), @JUnitSnmpAgent(host="10.1.5.2", port=161, resource="classpath:linkd/cisco1700.properties")})
    public void testSimpleConnection() throws Exception {
        this.m_nodeDao.delete((Object)this.m_nodeDao.findByForeignId("linkd", "cisco2691"));
        this.m_nodeDao.flush();
        NetworkBuilder nb = new NetworkBuilder();
        nb.addNode("cisco1700b").setForeignSource("linkd").setForeignId("cisco1700b").setSysObjectId(".1.3.6.1.4.1.9.1.200").setType("A");
        nb.addInterface("10.1.5.1").setIsSnmpPrimary("P").setIsManaged("M").addSnmpInterface(2).setIfType(Integer.valueOf(6)).setCollectionEnabled(false).setIfSpeed(100000000L).setPhysAddr("c00397a70000");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        this.m_nodeDao.flush();
        OnmsNode cisco1700 = this.m_nodeDao.findByForeignId("linkd", "cisco1700");
        OnmsNode cisco1700b = this.m_nodeDao.findByForeignId("linkd", "cisco1700b");
        LogUtils.debugf((Object)this, (String)"cisco1700  = %s", (Object[])new Object[]{cisco1700});
        LogUtils.debugf((Object)this, (String)"cisco1700b = %s", (Object[])new Object[]{cisco1700b});
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco1700.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco1700b.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleCollection(cisco1700.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleCollection(cisco1700b.getId().intValue()));
        List ifaces = this.m_dataLinkInterfaceDao.findAll();
        Assert.assertEquals((String)"we should have found 2 data link", (long)2L, (long)ifaces.size());
    }

    @Test
    @Ignore
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.1", port=161, resource="classpath:linkd/cisco7200a.properties"), @JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:linkd/laptop.properties"), @JUnitSnmpAgent(host="10.1.2.2", port=161, resource="classpath:linkd/cisco7200b.properties"), @JUnitSnmpAgent(host="10.1.3.2", port=161, resource="classpath:linkd/cisco3700.properties"), @JUnitSnmpAgent(host="10.1.4.2", port=161, resource="classpath:linkd/cisco2691.properties"), @JUnitSnmpAgent(host="10.1.5.2", port=161, resource="classpath:linkd/cisco1700.properties"), @JUnitSnmpAgent(host="10.1.6.2", port=161, resource="classpath:linkd/cisco3600.properties")})
    public void testFakeCiscoNetwork() throws Exception {
        OnmsNode laptop = this.m_nodeDao.findByForeignId("linkd", "laptop");
        OnmsNode cisco7200a = this.m_nodeDao.findByForeignId("linkd", "cisco7200a");
        OnmsNode cisco7200b = this.m_nodeDao.findByForeignId("linkd", "cisco7200b");
        OnmsNode cisco3700 = this.m_nodeDao.findByForeignId("linkd", "cisco3700");
        OnmsNode cisco2691 = this.m_nodeDao.findByForeignId("linkd", "cisco2691");
        OnmsNode cisco1700 = this.m_nodeDao.findByForeignId("linkd", "cisco1700");
        OnmsNode cisco3600 = this.m_nodeDao.findByForeignId("linkd", "cisco3600");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(laptop.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco7200a.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco7200b.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco3700.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco2691.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco1700.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco3600.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleCollection(laptop.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleCollection(cisco7200a.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleCollection(cisco7200b.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleCollection(cisco3700.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleCollection(cisco2691.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleCollection(cisco1700.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleCollection(cisco3600.getId().intValue()));
        List ifaces = this.m_dataLinkInterfaceDao.findAll();
        Assert.assertEquals((String)"we should have found 6 data links", (long)6L, (long)ifaces.size());
    }
}

