/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.net.InetAddress;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.db.TemporaryDatabase;
import org.opennms.netmgt.dao.db.TemporaryDatabaseAware;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.Eventd;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.AlarmData;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-eventDaemon.xml", "classpath:META-INF/opennms/smallEventConfDao.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class EventdTest
implements TemporaryDatabaseAware<TemporaryDatabase> {
    @Autowired
    private JdbcTemplate m_jdbcTemplate;
    @Autowired
    @Qualifier(value="eventIpcManagerImpl")
    private EventIpcManager m_eventdIpcMgr;
    @Autowired
    private Eventd m_eventd;
    @Autowired
    private DatabasePopulator m_databasePopulator;
    private TemporaryDatabase m_database;

    public void setTemporaryDatabase(TemporaryDatabase database) {
        this.m_database = database;
    }

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        this.m_databasePopulator.populateDatabase();
        this.m_eventd.onStart();
    }

    @After
    public void tearDown() throws Exception {
        this.m_eventd.onStop();
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    @JUnitTemporaryDatabase
    public void testPersistEvent() throws Exception {
        Assert.assertEquals((long)0L, (long)this.m_database.countRows(String.format("select * from events where eventuei = '%s'", "uei.opennms.org/nodes/nodeDown"), new Object[0]));
        OnmsNode node = this.m_databasePopulator.getNode1();
        Assert.assertNotNull((Object)node);
        this.sendNodeDownEvent(null, node);
        Thread.sleep(1000L);
        Assert.assertEquals((long)1L, (long)this.m_database.countRows(String.format("select * from events where eventuei = '%s'", "uei.opennms.org/nodes/nodeDown"), new Object[0]));
        node = this.m_databasePopulator.getNode2();
        Assert.assertNotNull((Object)node);
        this.sendNodeDownEvent(null, node);
        Thread.sleep(1000L);
        Assert.assertEquals((long)2L, (long)this.m_database.countRows(String.format("select * from events where eventuei = '%s'", "uei.opennms.org/nodes/nodeDown"), new Object[0]));
    }

    @Test
    @JUnitTemporaryDatabase
    public void testPersistEventWithService() throws Exception {
        Assert.assertEquals((long)0L, (long)this.m_database.countRows(String.format("select * from events where eventuei = '%s'", "uei.opennms.org/nodes/serviceUnresponsive"), new Object[0]));
        Assert.assertEquals((String)"service ID for ICMP", (long)1L, (long)this.m_jdbcTemplate.queryForInt("select serviceid from service where servicename = 'ICMP'"));
        OnmsNode node = this.m_databasePopulator.getNode1();
        Assert.assertNotNull((Object)node);
        OnmsIpInterface intf = node.getIpInterfaceByIpAddress("192.168.1.1");
        Assert.assertNotNull((Object)intf);
        OnmsMonitoredService svc = intf.getMonitoredServiceByServiceType("ICMP");
        Assert.assertNotNull((Object)svc);
        Assert.assertEquals((long)1L, (long)svc.getNodeId().intValue());
        Assert.assertEquals((Object)"192.168.1.1", (Object)InetAddressUtils.str((InetAddress)svc.getIpAddress()));
        Assert.assertEquals((long)1L, (long)svc.getServiceId().intValue());
        this.sendServiceDownEvent(null, svc);
        Thread.sleep(1000L);
        Assert.assertEquals((long)1L, (long)this.m_database.countRows(String.format("select * from events where eventuei = '%s'", "uei.opennms.org/nodes/serviceUnresponsive"), new Object[0]));
        Assert.assertEquals((String)"service ID for event", (long)1L, (long)this.m_jdbcTemplate.queryForInt(String.format("select serviceID from events where eventuei = '%s'", "uei.opennms.org/nodes/serviceUnresponsive")));
    }

    private void sendNodeDownEvent(String reductionKey, OnmsNode node) {
        EventBuilder e = MockEventUtil.createNodeDownEventBuilder((String)"Test", (OnmsNode)node);
        if (reductionKey != null) {
            AlarmData data = new AlarmData();
            data.setAlarmType(Integer.valueOf(1));
            data.setReductionKey(reductionKey);
            e.setAlarmData(data);
        } else {
            e.setAlarmData(null);
        }
        e.setLogDest("logndisplay");
        e.setLogMessage("testing");
        this.m_eventdIpcMgr.sendNow(e.getEvent());
    }

    private void sendServiceDownEvent(String reductionKey, OnmsMonitoredService svc) {
        EventBuilder e = MockEventUtil.createEventBuilder((String)"Test", (String)"uei.opennms.org/nodes/serviceUnresponsive", (int)svc.getNodeId(), (String)InetAddressUtils.str((InetAddress)svc.getIpAddress()), (String)svc.getServiceName(), (String)"Not responding");
        if (reductionKey != null) {
            AlarmData data = new AlarmData();
            data.setAlarmType(Integer.valueOf(1));
            data.setReductionKey(reductionKey);
            e.setAlarmData(data);
        } else {
            e.setAlarmData(null);
        }
        e.setLogDest("logndisplay");
        e.setLogMessage("testing");
        this.m_eventdIpcMgr.sendNow(e.getEvent());
    }
}

