/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.WmiPeerFactory;

public class WmiPeerFactoryTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        WmiPeerFactory.init();
    }

    public final void testOneSpecific() throws MarshalException, ValidationException, IOException {
        String amiConfigXml = "<?xml version=\"1.0\"?>\n<wmi-config retry=\"3\" timeout=\"800\"\n   password=\"password\">\n   <definition>\n       <specific>192.168.0.5</specific>\n   </definition>\n\n</wmi-config>\n";
        WmiPeerFactory factory = new WmiPeerFactory((InputStream)new ByteArrayInputStream(amiConfigXml.getBytes("UTF-8")));
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinitionCount());
        WmiPeerFactory.optimize();
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinitionCount());
    }

    public final void testAddAdjacentSpecificToDef() throws MarshalException, ValidationException, IOException {
        String amiConfigXml = "<?xml version=\"1.0\"?>\n<wmi-config retry=\"3\" timeout=\"800\"\n   password=\"password\">\n   <definition>\n       <specific>192.168.0.5</specific>\n       <specific>192.168.0.6</specific>\n   </definition>\n\n</wmi-config>\n";
        WmiPeerFactory factory = new WmiPeerFactory((InputStream)new ByteArrayInputStream(amiConfigXml.getBytes("UTF-8")));
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinitionCount());
        WmiPeerFactoryTest.assertEquals((int)2, (int)factory.getConfig().getDefinition(0).getSpecificCount());
        WmiPeerFactoryTest.assertEquals((int)0, (int)factory.getConfig().getDefinition(0).getRangeCount());
        WmiPeerFactory.optimize();
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinitionCount());
        WmiPeerFactoryTest.assertEquals((int)0, (int)factory.getConfig().getDefinition(0).getSpecificCount());
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinition(0).getRangeCount());
        WmiPeerFactoryTest.assertEquals((String)"192.168.0.5", (String)factory.getConfig().getDefinition(0).getRange(0).getBegin());
        WmiPeerFactoryTest.assertEquals((String)"192.168.0.6", (String)factory.getConfig().getDefinition(0).getRange(0).getEnd());
    }

    public final void testAddAdjacentSpecificToDefIPv6() throws MarshalException, ValidationException, IOException {
        String amiConfigXml = "<?xml version=\"1.0\"?>\n<wmi-config retry=\"3\" timeout=\"800\"\n   password=\"password\">\n   <definition>\n       <specific>fe80:0000:0000:0000:0000:0000:0000:fedb</specific>\n       <specific>fe80:0000:0000:0000:0000:0000:0000:fedc</specific>\n   </definition>\n\n</wmi-config>\n";
        WmiPeerFactory factory = new WmiPeerFactory((InputStream)new ByteArrayInputStream(amiConfigXml.getBytes("UTF-8")));
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinitionCount());
        WmiPeerFactoryTest.assertEquals((int)2, (int)factory.getConfig().getDefinition(0).getSpecificCount());
        WmiPeerFactoryTest.assertEquals((int)0, (int)factory.getConfig().getDefinition(0).getRangeCount());
        WmiPeerFactory.optimize();
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinitionCount());
        WmiPeerFactoryTest.assertEquals((int)0, (int)factory.getConfig().getDefinition(0).getSpecificCount());
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinition(0).getRangeCount());
        WmiPeerFactoryTest.assertEquals((String)"fe80:0000:0000:0000:0000:0000:0000:fedb", (String)factory.getConfig().getDefinition(0).getRange(0).getBegin());
        WmiPeerFactoryTest.assertEquals((String)"fe80:0000:0000:0000:0000:0000:0000:fedc", (String)factory.getConfig().getDefinition(0).getRange(0).getEnd());
    }

    public final void testAddAdjacentSpecificToDefIPv6WithSameScopeId() throws MarshalException, ValidationException, IOException {
        String amiConfigXml = "<?xml version=\"1.0\"?>\n<wmi-config retry=\"3\" timeout=\"800\"\n   password=\"password\">\n   <definition>\n       <specific>fe80:0000:0000:0000:0000:0000:0000:fedb%5</specific>\n       <specific>fe80:0000:0000:0000:0000:0000:0000:fedc%5</specific>\n   </definition>\n\n</wmi-config>\n";
        WmiPeerFactory factory = new WmiPeerFactory((InputStream)new ByteArrayInputStream(amiConfigXml.getBytes("UTF-8")));
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinitionCount());
        WmiPeerFactoryTest.assertEquals((int)2, (int)factory.getConfig().getDefinition(0).getSpecificCount());
        WmiPeerFactoryTest.assertEquals((int)0, (int)factory.getConfig().getDefinition(0).getRangeCount());
        WmiPeerFactory.optimize();
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinitionCount());
        WmiPeerFactoryTest.assertEquals((int)0, (int)factory.getConfig().getDefinition(0).getSpecificCount());
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinition(0).getRangeCount());
        WmiPeerFactoryTest.assertEquals((String)"fe80:0000:0000:0000:0000:0000:0000:fedb%5", (String)factory.getConfig().getDefinition(0).getRange(0).getBegin());
        WmiPeerFactoryTest.assertEquals((String)"fe80:0000:0000:0000:0000:0000:0000:fedc%5", (String)factory.getConfig().getDefinition(0).getRange(0).getEnd());
    }

    public final void testAddAdjacentSpecificToDefIPv6WithDifferentScopeIds() throws MarshalException, ValidationException, IOException {
        String amiConfigXml = "<?xml version=\"1.0\"?>\n<wmi-config retry=\"3\" timeout=\"800\"\n   password=\"password\">\n   <definition>\n       <specific>fe80:0000:0000:0000:0000:0000:0000:fedb%1</specific>\n       <specific>fe80:0000:0000:0000:0000:0000:0000:fedc%2</specific>\n   </definition>\n\n</wmi-config>\n";
        WmiPeerFactory factory = new WmiPeerFactory((InputStream)new ByteArrayInputStream(amiConfigXml.getBytes("UTF-8")));
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinitionCount());
        WmiPeerFactoryTest.assertEquals((int)2, (int)factory.getConfig().getDefinition(0).getSpecificCount());
        WmiPeerFactoryTest.assertEquals((int)0, (int)factory.getConfig().getDefinition(0).getRangeCount());
        WmiPeerFactory.optimize();
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinitionCount());
        WmiPeerFactoryTest.assertEquals((int)2, (int)factory.getConfig().getDefinition(0).getSpecificCount());
        WmiPeerFactoryTest.assertEquals((int)0, (int)factory.getConfig().getDefinition(0).getRangeCount());
    }

    public void testRecombineSpecificIntoRange() throws MarshalException, ValidationException, IOException {
        String amiConfigXml = "<?xml version=\"1.0\"?>\n<wmi-config retry=\"3\" timeout=\"800\"\n   password=\"password\">\n   <definition>\n       <range begin=\"fe80:0000:0000:0000:0000:0000:0000:fed0%1\" end=\"fe80:0000:0000:0000:0000:0000:0000:fed9%1\"/>\n       <range begin=\"fe80:0000:0000:0000:0000:0000:0000:fedb%1\" end=\"fe80:0000:0000:0000:0000:0000:0000:fedf%1\"/>\n       <specific>fe80:0000:0000:0000:0000:0000:0000:feda%1</specific>\n   </definition>\n\n</wmi-config>\n";
        WmiPeerFactory factory = new WmiPeerFactory((InputStream)new ByteArrayInputStream(amiConfigXml.getBytes("UTF-8")));
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinitionCount());
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinition(0).getSpecificCount());
        WmiPeerFactoryTest.assertEquals((int)2, (int)factory.getConfig().getDefinition(0).getRangeCount());
        WmiPeerFactory.optimize();
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinitionCount());
        WmiPeerFactoryTest.assertEquals((int)0, (int)factory.getConfig().getDefinition(0).getSpecificCount());
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinition(0).getRangeCount());
        WmiPeerFactoryTest.assertEquals((String)"fe80:0000:0000:0000:0000:0000:0000:fed0%1", (String)factory.getConfig().getDefinition(0).getRange(0).getBegin());
        WmiPeerFactoryTest.assertEquals((String)"fe80:0000:0000:0000:0000:0000:0000:fedf%1", (String)factory.getConfig().getDefinition(0).getRange(0).getEnd());
    }

    public void testRecombineSpecificIntoRangeWithDifferentScopeIds() throws MarshalException, ValidationException, IOException {
        String amiConfigXml = "<?xml version=\"1.0\"?>\n<wmi-config retry=\"3\" timeout=\"800\"\n   password=\"password\">\n   <definition>\n       <range begin=\"fe80:0000:0000:0000:0000:0000:0000:fed0%1\" end=\"fe80:0000:0000:0000:0000:0000:0000:fed9%1\"/>\n       <range begin=\"fe80:0000:0000:0000:0000:0000:0000:fedb%2\" end=\"fe80:0000:0000:0000:0000:0000:0000:fedf%2\"/>\n       <specific>fe80:0000:0000:0000:0000:0000:0000:feda%1</specific>\n   </definition>\n\n</wmi-config>\n";
        WmiPeerFactory factory = new WmiPeerFactory((InputStream)new ByteArrayInputStream(amiConfigXml.getBytes("UTF-8")));
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinitionCount());
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinition(0).getSpecificCount());
        WmiPeerFactoryTest.assertEquals((int)2, (int)factory.getConfig().getDefinition(0).getRangeCount());
        WmiPeerFactory.optimize();
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinitionCount());
        WmiPeerFactoryTest.assertEquals((int)0, (int)factory.getConfig().getDefinition(0).getSpecificCount());
        WmiPeerFactoryTest.assertEquals((int)2, (int)factory.getConfig().getDefinition(0).getRangeCount());
        WmiPeerFactoryTest.assertEquals((String)"fe80:0000:0000:0000:0000:0000:0000:fed0%1", (String)factory.getConfig().getDefinition(0).getRange(0).getBegin());
        WmiPeerFactoryTest.assertEquals((String)"fe80:0000:0000:0000:0000:0000:0000:feda%1", (String)factory.getConfig().getDefinition(0).getRange(0).getEnd());
        WmiPeerFactoryTest.assertEquals((String)"fe80:0000:0000:0000:0000:0000:0000:fedb%2", (String)factory.getConfig().getDefinition(0).getRange(1).getBegin());
        WmiPeerFactoryTest.assertEquals((String)"fe80:0000:0000:0000:0000:0000:0000:fedf%2", (String)factory.getConfig().getDefinition(0).getRange(1).getEnd());
    }

    public final void testNewSpecificSameAsBeginInOldDef() throws MarshalException, ValidationException, IOException {
        String amiConfigXml = "<?xml version=\"1.0\"?>\n<wmi-config retry=\"3\" timeout=\"800\"\n   password=\"password\">\n   <definition>\n       <range begin=\"192.168.0.6\" end=\"192.168.0.12\"/>\n       <specific>192.168.0.6</specific>\n   </definition>\n\n</wmi-config>\n";
        WmiPeerFactory factory = new WmiPeerFactory((InputStream)new ByteArrayInputStream(amiConfigXml.getBytes("UTF-8")));
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinitionCount());
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinition(0).getSpecificCount());
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinition(0).getRangeCount());
        WmiPeerFactory.optimize();
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinitionCount());
        WmiPeerFactoryTest.assertEquals((int)0, (int)factory.getConfig().getDefinition(0).getSpecificCount());
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinition(0).getRangeCount());
        WmiPeerFactoryTest.assertEquals((String)"192.168.0.6", (String)factory.getConfig().getDefinition(0).getRange(0).getBegin());
        WmiPeerFactoryTest.assertEquals((String)"192.168.0.12", (String)factory.getConfig().getDefinition(0).getRange(0).getEnd());
    }

    public final void testNewSpecificSameAsEndInOldDef() throws MarshalException, ValidationException, IOException {
        String amiConfigXml = "<?xml version=\"1.0\"?>\n<wmi-config retry=\"3\" timeout=\"800\"\n   password=\"password\">\n   <definition>\n       <range begin=\"192.168.0.6\" end=\"192.168.0.12\"/>\n       <specific>192.168.0.12</specific>\n   </definition>\n\n</wmi-config>\n";
        WmiPeerFactory factory = new WmiPeerFactory((InputStream)new ByteArrayInputStream(amiConfigXml.getBytes("UTF-8")));
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinitionCount());
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinition(0).getSpecificCount());
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinition(0).getRangeCount());
        WmiPeerFactory.optimize();
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinitionCount());
        WmiPeerFactoryTest.assertEquals((int)0, (int)factory.getConfig().getDefinition(0).getSpecificCount());
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinition(0).getRangeCount());
        WmiPeerFactoryTest.assertEquals((String)"192.168.0.6", (String)factory.getConfig().getDefinition(0).getRange(0).getBegin());
        WmiPeerFactoryTest.assertEquals((String)"192.168.0.12", (String)factory.getConfig().getDefinition(0).getRange(0).getEnd());
    }

    public void testOverlapsTwoRanges() throws MarshalException, ValidationException, IOException {
        String amiConfigXml = "<?xml version=\"1.0\"?>\n<wmi-config retry=\"3\" timeout=\"800\"\n   password=\"password\">\n   <definition>\n       <range begin=\"192.168.0.6\" end=\"192.168.0.12\"/>\n       <range begin=\"192.168.0.20\" end=\"192.168.0.100\"/>\n       <range begin=\"192.168.0.8\" end=\"192.168.0.30\"/>\n   </definition>\n\n</wmi-config>\n";
        WmiPeerFactory factory = new WmiPeerFactory((InputStream)new ByteArrayInputStream(amiConfigXml.getBytes("UTF-8")));
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinitionCount());
        WmiPeerFactoryTest.assertEquals((int)0, (int)factory.getConfig().getDefinition(0).getSpecificCount());
        WmiPeerFactoryTest.assertEquals((int)3, (int)factory.getConfig().getDefinition(0).getRangeCount());
        WmiPeerFactory.optimize();
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinitionCount());
        WmiPeerFactoryTest.assertEquals((int)0, (int)factory.getConfig().getDefinition(0).getSpecificCount());
        WmiPeerFactoryTest.assertEquals((int)1, (int)factory.getConfig().getDefinition(0).getRangeCount());
        WmiPeerFactoryTest.assertEquals((String)"192.168.0.6", (String)factory.getConfig().getDefinition(0).getRange(0).getBegin());
        WmiPeerFactoryTest.assertEquals((String)"192.168.0.100", (String)factory.getConfig().getDefinition(0).getRange(0).getEnd());
    }
}

