/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.util.Date;
import org.opennms.netmgt.config.AbstractTimeIntervalSequence;
import org.opennms.netmgt.config.IntervalTestCase;
import org.opennms.netmgt.config.OwnedInterval;
import org.opennms.netmgt.config.OwnedIntervalSequence;
import org.opennms.netmgt.config.TimeInterval;
import org.opennms.netmgt.config.TimeIntervalSequence;

public class TimeIntervalSequenceTest
extends IntervalTestCase {
    public void testPreceeds() throws Exception {
        TimeInterval first = new TimeInterval(new Date(0L), this.date("18-08-2005 00:00:00"));
        TimeInterval second = this.aug(18);
        TimeIntervalSequenceTest.assertTrue((boolean)first.preceeds(second));
        TimeIntervalSequenceTest.assertFalse((boolean)second.preceeds(first));
    }

    public void testFollows() throws Exception {
        TimeInterval first = new TimeInterval(new Date(0L), this.date("18-08-2005 00:00:00"));
        TimeInterval second = this.aug(18);
        TimeIntervalSequenceTest.assertTrue((boolean)second.follows(first));
        TimeIntervalSequenceTest.assertFalse((boolean)first.follows(second));
    }

    public void testEmptySequence() {
        TimeIntervalSequence seq = new TimeIntervalSequence();
        this.assertTimeIntervalSequence(new TimeInterval[0], (AbstractTimeIntervalSequence)seq);
    }

    public void testSingletonSeq() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence(this.aug(18));
        this.assertTimeIntervalSequence(new TimeInterval[]{this.aug(18)}, (AbstractTimeIntervalSequence)seq);
    }

    public void testAddToEmptySeq() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence();
        seq.addInterval(this.aug(18));
        this.assertTimeIntervalSequence(new TimeInterval[]{this.aug(18)}, (AbstractTimeIntervalSequence)seq);
    }

    public void testAddNonOverlappingLater() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence(this.aug(18));
        seq.addInterval(this.aug(19, 11, 12));
        this.assertTimeIntervalSequence(new TimeInterval[]{this.aug(18), this.aug(19, 11, 12)}, (AbstractTimeIntervalSequence)seq);
    }

    public void testAddNonOverlappingEarlier() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence(this.aug(18));
        seq.addInterval(this.aug(17, 11, 12));
        this.assertTimeIntervalSequence(new TimeInterval[]{this.aug(17, 11, 12), this.aug(18)}, (AbstractTimeIntervalSequence)seq);
    }

    public void testAddEquals() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence(this.aug(18, 8, 17));
        seq.addInterval(this.aug(18, 8, 17));
        this.assertTimeIntervalSequence(new TimeInterval[]{this.aug(18, 8, 17)}, (AbstractTimeIntervalSequence)seq);
    }

    public void testAddOverlappingCentered() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence(this.aug(18, 8, 17));
        seq.addInterval(this.aug(18, 11, 12));
        this.assertTimeIntervalSequence(new TimeInterval[]{this.aug(18, 8, 11), this.aug(18, 11, 12), this.aug(18, 12, 17)}, (AbstractTimeIntervalSequence)seq);
    }

    public void testAddOverlappingLater() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence(this.aug(18, 8, 17));
        seq.addInterval(this.aug(18, 11, 20));
        this.assertTimeIntervalSequence(new TimeInterval[]{this.aug(18, 8, 11), this.aug(18, 11, 17), this.aug(18, 17, 20)}, (AbstractTimeIntervalSequence)seq);
    }

    public void testAddOverlappingEarlier() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence(this.aug(18, 8, 17));
        seq.addInterval(this.aug(18, 3, 12));
        this.assertTimeIntervalSequence(new TimeInterval[]{this.aug(18, 3, 8), this.aug(18, 8, 12), this.aug(18, 12, 17)}, (AbstractTimeIntervalSequence)seq);
    }

    public void testAddOverlappingStraddle() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence(this.aug(18, 8, 17));
        seq.addInterval(this.aug(18, 3, 20));
        this.assertTimeIntervalSequence(new TimeInterval[]{this.aug(18, 3, 8), this.aug(18, 8, 17), this.aug(18, 17, 20)}, (AbstractTimeIntervalSequence)seq);
    }

    public void testAddOverlappingFirstSegmentEmpty() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence(this.aug(18, 8, 17));
        seq.addInterval(this.aug(18, 8, 20));
        this.assertTimeIntervalSequence(new TimeInterval[]{this.aug(18, 8, 17), this.aug(18, 17, 20)}, (AbstractTimeIntervalSequence)seq);
    }

    public void testAddOverlappingLastSegmentEmpty() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence(this.aug(18, 8, 17));
        seq.addInterval(this.aug(18, 3, 17));
        this.assertTimeIntervalSequence(new TimeInterval[]{this.aug(18, 3, 8), this.aug(18, 8, 17)}, (AbstractTimeIntervalSequence)seq);
    }

    public void testAddOverlappingMany() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence(this.aug(18, 8, 17));
        seq.addInterval(this.aug(19, 8, 17));
        seq.addInterval(this.aug(20, 8, 17));
        seq.addInterval(this.aug(18, 0, 20, 24));
        TimeInterval[] expected = new TimeInterval[]{this.aug(18, 0, 8), this.aug(18, 8, 17), this.aug(18, 17, 19, 8), this.aug(19, 8, 17), this.aug(19, 17, 20, 8), this.aug(20, 8, 17), this.aug(20, 17, 24)};
        this.assertTimeIntervalSequence(expected, (AbstractTimeIntervalSequence)seq);
    }

    public void testRemoveOnlyInterval() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence(this.aug(18, 8, 17));
        seq.removeInterval(this.aug(18, 8, 17));
        this.assertTimeIntervalSequence(new TimeInterval[0], (AbstractTimeIntervalSequence)seq);
    }

    public void testRemoveFirstEntireInterval() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence(this.aug(18, 8, 17));
        seq.addInterval(this.aug(19, 11, 12));
        seq.removeInterval(this.aug(18, 8, 17));
        this.assertTimeIntervalSequence(new TimeInterval[]{this.aug(19, 11, 12)}, (AbstractTimeIntervalSequence)seq);
    }

    public void testRemoveMiddleEntireInterval() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence(this.aug(18, 8, 17));
        seq.addInterval(this.aug(19, 11, 12));
        seq.addInterval(this.aug(20, 11, 12));
        seq.removeInterval(this.aug(19, 11, 12));
        this.assertTimeIntervalSequence(new TimeInterval[]{this.aug(18, 8, 17), this.aug(20, 11, 12)}, (AbstractTimeIntervalSequence)seq);
    }

    public void testRemoveLastEntireInterval() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence(this.aug(18, 8, 17));
        seq.addInterval(this.aug(19, 11, 12));
        seq.removeInterval(this.aug(19, 11, 12));
        this.assertTimeIntervalSequence(new TimeInterval[]{this.aug(18, 8, 17)}, (AbstractTimeIntervalSequence)seq);
    }

    public void testRemoveCenteredOverlappingInterval() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence(this.aug(18, 8, 17));
        seq.removeInterval(this.aug(18, 11, 12));
        this.assertTimeIntervalSequence(new TimeInterval[]{this.aug(18, 8, 11), this.aug(18, 12, 17)}, (AbstractTimeIntervalSequence)seq);
    }

    public void testRemoveOverlappingLater() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence(this.aug(18, 8, 17));
        seq.removeInterval(this.aug(18, 11, 20));
        this.assertTimeIntervalSequence(new TimeInterval[]{this.aug(18, 8, 11)}, (AbstractTimeIntervalSequence)seq);
    }

    public void testRemoveOverlappingEarlier() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence(this.aug(18, 8, 17));
        seq.removeInterval(this.aug(18, 3, 12));
        this.assertTimeIntervalSequence(new TimeInterval[]{this.aug(18, 12, 17)}, (AbstractTimeIntervalSequence)seq);
    }

    public void testRemoveOverlappingStraddle() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence(this.aug(18, 8, 17));
        seq.removeInterval(this.aug(18, 3, 20));
        this.assertTimeIntervalSequence(new TimeInterval[0], (AbstractTimeIntervalSequence)seq);
    }

    public void testRemoveOverlappingDegeneratePrefix() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence(this.aug(18, 8, 17));
        seq.removeInterval(this.aug(18, 8, 12));
        this.assertTimeIntervalSequence(new TimeInterval[]{this.aug(18, 12, 17)}, (AbstractTimeIntervalSequence)seq);
    }

    public void testRemoveOverlappingDegenerateSuffix() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence(this.aug(18, 8, 17));
        seq.removeInterval(this.aug(18, 12, 17));
        this.assertTimeIntervalSequence(new TimeInterval[]{this.aug(18, 8, 12)}, (AbstractTimeIntervalSequence)seq);
    }

    public void testRemoveOverlappingMany() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence(this.aug(18, 8, 17));
        seq.addInterval(this.aug(19, 8, 17));
        seq.addInterval(this.aug(20, 8, 17));
        seq.addInterval(this.aug(21, 8, 17));
        seq.addInterval(this.aug(22, 8, 17));
        seq.removeInterval(this.aug(19, 12, 21, 12));
        TimeInterval[] expected = new TimeInterval[]{this.aug(18, 8, 17), this.aug(19, 8, 12), this.aug(21, 12, 17), this.aug(22, 8, 17)};
        this.assertTimeIntervalSequence(expected, (AbstractTimeIntervalSequence)seq);
    }

    public void testBound() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence(this.aug(18, 8, 17));
        seq.addInterval(this.aug(19, 8, 17));
        seq.addInterval(this.aug(20, 8, 17));
        seq.addInterval(this.aug(21, 8, 17));
        seq.addInterval(this.aug(22, 8, 17));
        seq.bound(this.aug(19, 12, 21, 12));
        TimeInterval[] expected = new TimeInterval[]{this.aug(19, 12, 17), this.aug(20, 8, 17), this.aug(21, 8, 12)};
        this.assertTimeIntervalSequence(expected, (AbstractTimeIntervalSequence)seq);
    }

    public void testGetBounds() throws Exception {
        TimeIntervalSequence seq = new TimeIntervalSequence(this.aug(18, 8, 17));
        seq.addInterval(this.aug(19, 8, 17));
        seq.addInterval(this.aug(20, 8, 17));
        seq.addInterval(this.aug(21, 8, 17));
        seq.addInterval(this.aug(22, 8, 17));
        TimeIntervalSequenceTest.assertEquals((Object)this.aug(18, 8, 22, 17), (Object)seq.getBounds());
    }

    public void testExtensionAdd() throws Exception {
        OwnedIntervalSequence seq = new OwnedIntervalSequence(this.ownedOne(this.aug(18, 8, 17)));
        seq.addInterval((TimeInterval)this.ownedOne(this.aug(19, 8, 17)));
        seq.addInterval((TimeInterval)this.ownedOne(this.aug(20, 8, 17)));
        seq.addInterval((TimeInterval)this.ownedTwo(this.aug(18, 12, 20, 24)));
        OwnedInterval[] expected = new OwnedInterval[]{this.ownedOne(this.aug(18, 8, 12)), this.ownedOneAndTwo(this.aug(18, 12, 17)), this.ownedTwo(this.aug(18, 17, 19, 8)), this.ownedOneAndTwo(this.aug(19, 8, 17)), this.ownedTwo(this.aug(19, 17, 20, 8)), this.ownedOneAndTwo(this.aug(20, 8, 17)), this.ownedTwo(this.aug(20, 17, 24))};
        this.assertTimeIntervalSequence((TimeInterval[])expected, (AbstractTimeIntervalSequence)seq);
    }

    public void testExtensionRemoveWrongOwner() throws Exception {
        OwnedIntervalSequence seq = new OwnedIntervalSequence(this.ownedOne(this.aug(18, 8, 17)));
        seq.addInterval((TimeInterval)this.ownedOne(this.aug(19, 8, 17)));
        seq.addInterval((TimeInterval)this.ownedOne(this.aug(20, 8, 17)));
        seq.removeInterval((TimeInterval)this.ownedTwo(this.aug(18, 12, 20, 24)));
        OwnedInterval[] expected = new OwnedInterval[]{this.ownedOne(this.aug(18, 8, 17)), this.ownedOne(this.aug(19, 8, 17)), this.ownedOne(this.aug(20, 8, 17))};
        this.assertTimeIntervalSequence((TimeInterval[])expected, (AbstractTimeIntervalSequence)seq);
    }

    public void testExtensionRemoveOneOwner() throws Exception {
        OwnedIntervalSequence seq = new OwnedIntervalSequence(this.ownedOneAndTwo(this.aug(18, 8, 17)));
        seq.addInterval((TimeInterval)this.ownedOneAndTwo(this.aug(19, 8, 17)));
        seq.addInterval((TimeInterval)this.ownedOneAndTwo(this.aug(20, 8, 17)));
        seq.removeInterval((TimeInterval)this.ownedTwo(this.aug(18, 12, 20, 13)));
        OwnedInterval[] expected = new OwnedInterval[]{this.ownedOneAndTwo(this.aug(18, 8, 12)), this.ownedOne(this.aug(18, 12, 17)), this.ownedOne(this.aug(19, 8, 17)), this.ownedOne(this.aug(20, 8, 13)), this.ownedOneAndTwo(this.aug(20, 13, 17))};
        this.assertTimeIntervalSequence((TimeInterval[])expected, (AbstractTimeIntervalSequence)seq);
    }

    public void testExtensionRemoveAllOwners() throws Exception {
        OwnedIntervalSequence seq = new OwnedIntervalSequence(this.ownedOneAndTwo(this.aug(18, 8, 17)));
        seq.addInterval((TimeInterval)this.ownedOneAndTwo(this.aug(19, 8, 17)));
        seq.addInterval((TimeInterval)this.ownedOneAndTwo(this.aug(20, 8, 17)));
        seq.removeInterval((TimeInterval)this.ownedOneAndTwo(this.aug(18, 12, 20, 13)));
        OwnedInterval[] expected = new OwnedInterval[]{this.ownedOneAndTwo(this.aug(18, 8, 12)), this.ownedOneAndTwo(this.aug(20, 13, 17))};
        this.assertTimeIntervalSequence((TimeInterval[])expected, (AbstractTimeIntervalSequence)seq);
    }

    public void testExtensionUnscheduled() throws Exception {
        OwnedIntervalSequence seq = new OwnedIntervalSequence(this.ownedOneAndTwo(this.aug(18, 8, 17)));
        seq.addInterval((TimeInterval)this.ownedOneAndTwo(this.aug(19, 8, 17)));
        seq.addInterval((TimeInterval)this.ownedOneAndTwo(this.aug(20, 8, 17)));
        OwnedIntervalSequence unscheduled = new OwnedIntervalSequence(this.owned(this.aug(18)));
        unscheduled.removeAll((AbstractTimeIntervalSequence)seq);
        OwnedInterval[] expected = new OwnedInterval[]{this.owned(this.aug(18, 0, 8)), this.owned(this.aug(18, 17, 24))};
        this.assertTimeIntervalSequence((TimeInterval[])expected, (AbstractTimeIntervalSequence)unscheduled);
    }
}

