/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import junit.framework.TestCase;
import org.opennms.netmgt.config.AbstractTimeIntervalSequence;
import org.opennms.netmgt.config.OwnedInterval;
import org.opennms.netmgt.config.Owner;
import org.opennms.netmgt.config.TimeInterval;

public class IntervalTestCase
extends TestCase {
    DateFormat m_dateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");

    protected Date date(String dateStr) throws Exception {
        return this.m_dateFormat.parse(dateStr);
    }

    protected TimeInterval interval(int startMonth, int startDay, int startHour, int endMonth, int endDay, int endHour) throws Exception {
        return new TimeInterval(this.date(startDay + "-" + startMonth + "-2005 " + startHour + ":00:00"), this.date(endDay + "-" + endMonth + "-2005 " + endHour + ":00:00"));
    }

    protected TimeInterval jun(int startDay, int startHour, int endDay, int endHour) throws Exception {
        return this.interval(6, startDay, startHour, 6, endDay, endHour);
    }

    protected TimeInterval jul(int startDay, int startHour, int endDay, int endHour) throws Exception {
        return this.interval(7, startDay, startHour, 7, endDay, endHour);
    }

    protected TimeInterval aug(int startDay, int startHour, int endDay, int endHour) throws Exception {
        return this.interval(8, startDay, startHour, 8, endDay, endHour);
    }

    protected TimeInterval sep(int startDay, int startHour, int endDay, int endHour) throws Exception {
        return this.interval(9, startDay, startHour, 9, endDay, endHour);
    }

    protected TimeInterval oct(int startDay, int startHour, int endDay, int endHour) throws Exception {
        return this.interval(10, startDay, startHour, 10, endDay, endHour);
    }

    protected TimeInterval nov(int startDay, int startHour, int endDay, int endHour) throws Exception {
        return this.interval(11, startDay, startHour, 11, endDay, endHour);
    }

    protected TimeInterval dec(int startDay, int startHour, int endDay, int endHour) throws Exception {
        return this.interval(12, startDay, startHour, 12, endDay, endHour);
    }

    protected TimeInterval jun(int day, int beginHour, int endHour) throws Exception {
        return this.jun(day, beginHour, day, endHour);
    }

    protected TimeInterval jul(int day, int beginHour, int endHour) throws Exception {
        return this.jul(day, beginHour, day, endHour);
    }

    protected TimeInterval aug(int day, int beginHour, int endHour) throws Exception {
        return this.aug(day, beginHour, day, endHour);
    }

    protected TimeInterval sep(int day, int beginHour, int endHour) throws Exception {
        return this.sep(day, beginHour, day, endHour);
    }

    protected TimeInterval oct(int day, int beginHour, int endHour) throws Exception {
        return this.oct(day, beginHour, day, endHour);
    }

    protected TimeInterval nov(int day, int beginHour, int endHour) throws Exception {
        return this.nov(day, beginHour, day, endHour);
    }

    protected TimeInterval dec(int day, int beginHour, int endHour) throws Exception {
        return this.dec(day, beginHour, day, endHour);
    }

    protected TimeInterval aug(int day) throws Exception {
        return this.aug(day, 0, 24);
    }

    protected <T extends TimeInterval> void assertTimeIntervalSequence(T[] intervals, AbstractTimeIntervalSequence<T> seq) {
        int count = 0;
        for (TimeInterval interval : seq) {
            this.assertInterval((TimeInterval)intervals[count], interval);
            ++count;
        }
        IntervalTestCase.assertEquals((int)intervals.length, (int)count);
    }

    protected void assertInterval(TimeInterval expected, TimeInterval actual) {
        IntervalTestCase.assertEquals((Object)expected, (Object)actual);
    }

    protected OwnedInterval owned(Owner owner, TimeInterval interval) {
        return owner == null ? new OwnedInterval(interval) : new OwnedInterval(owner, interval);
    }

    protected OwnedInterval owned(TimeInterval interval) {
        return this.owned(null, interval);
    }

    protected OwnedInterval ownedOne(TimeInterval interval) {
        return this.owned(new Owner("one", "one"), interval);
    }

    protected OwnedInterval ownedTwo(TimeInterval interval) {
        return this.owned(new Owner("two", "two"), interval);
    }

    protected OwnedInterval ownedOneAndTwo(TimeInterval interval) {
        Owner[] owners = new Owner[]{new Owner("one", "one"), new Owner("two", "two")};
        return new OwnedInterval(Arrays.asList(owners), interval);
    }
}

