/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.InputStream;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.DefaultCapsdConfigManager;
import org.opennms.netmgt.config.capsd.Property;
import org.opennms.netmgt.config.capsd.ProtocolPlugin;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.ThrowableAnticipator;

public class CapsdConfigManagerTest
extends TestCase {
    public void testBogus() {
    }

    public void DISABLEDtestBadPlugin() throws Exception {
        InputStream reader = ConfigurationTestUtils.getInputStreamForResource((Object)((Object)this), (String)"/org/opennms/netmgt/config/capsd-configuration-bad-class.xml");
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new ValidationException("*** ThrowableAnticipator ignore Throwable.getMessage() ***"));
        try {
            new DefaultCapsdConfigManager(reader);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public final void testHttpRegex() throws Exception {
        DefaultCapsdConfigManager config = new DefaultCapsdConfigManager(Thread.currentThread().getContextClassLoader().getResourceAsStream("testHttpRegex.xml"));
        ProtocolPlugin http = config.getProtocolPlugin("HTTP");
        Property regexProperty = null;
        for (Property prop : http.getPropertyCollection()) {
            if (!"response-text".equals(prop.getKey())) continue;
            regexProperty = prop;
            break;
        }
        CapsdConfigManagerTest.assertEquals((String)"HTTP regex does not match expected value", (String)"~\\{.nodes.: \\[\\{.nodeid.:.*", (String)regexProperty.getValue());
        Pattern bodyPat = Pattern.compile(regexProperty.getValue().substring(1), 32);
        CapsdConfigManagerTest.assertTrue((boolean)bodyPat.matcher("{\"nodes\": [{\"nodeid\": \"19\", \"nodelabel\": \"\"},{\"nodeid\": \"21\", \"nodelabel\": \"\"}]}").matches());
        CapsdConfigManagerTest.assertFalse((boolean)bodyPat.matcher("{\"nodes\": [ ]}").matches());
    }
}

