/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.net.InetAddress;
import junit.framework.TestSuite;
import org.opennms.core.test.snmp.SnmpTestSuiteUtils;
import org.opennms.netmgt.collectd.SnmpCollectorTestCase;
import org.opennms.netmgt.collectd.SnmpNodeCollector;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.snmp.CollectionTracker;

public class SnmpNodeCollectorTest
extends SnmpCollectorTestCase {
    public static TestSuite suite() {
        return SnmpTestSuiteUtils.createSnmpVersionTestSuite(SnmpNodeCollectorTest.class);
    }

    public void testZeroVars() throws Exception {
        SnmpNodeCollector collector = this.createNodeCollector();
        this.assertMibObjectsPresent((CollectionResource)collector.getCollectionSet().getNodeInfo(), this.getAttributeList());
    }

    public void testInvalidVar() throws Exception {
        this.addAttribute("invalid", ".1.3.6.1.2.1.2", "0", "string");
        SnmpNodeCollector collector = this.createNodeCollector();
        SnmpNodeCollectorTest.assertTrue((boolean)collector.getEntry().isEmpty());
    }

    public void testInvalidInst() throws Exception {
        this.addAttribute("invalid", ".1.3.6.1.2.1.1.3", "1", "timeTicks");
        SnmpNodeCollector collector = this.createNodeCollector();
        SnmpNodeCollectorTest.assertTrue((boolean)collector.getEntry().isEmpty());
    }

    public void testOneVar() throws Exception {
        this.addSysName();
        SnmpNodeCollector collector = this.createNodeCollector();
        this.assertMibObjectsPresent((CollectionResource)collector.getCollectionSet().getNodeInfo(), this.getAttributeList());
    }

    private SnmpNodeCollector createNodeCollector() throws Exception, InterruptedException {
        this.initializeAgent();
        SnmpNodeCollector collector = new SnmpNodeCollector(InetAddress.getLocalHost(), this.getCollectionSet().getAttributeList(), this.getCollectionSet());
        this.createWalker((CollectionTracker)collector);
        this.waitForSignal();
        SnmpNodeCollectorTest.assertNotNull((String)"No entry data", (Object)collector.getEntry());
        SnmpNodeCollectorTest.assertFalse((String)"Timeout collecting data", (boolean)collector.timedOut());
        SnmpNodeCollectorTest.assertFalse((String)"Collector failed to collect data", (boolean)collector.failed());
        return collector;
    }
}

