/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionSpecification;
import org.opennms.netmgt.collectd.CollectorTestUtils;
import org.opennms.netmgt.collectd.DefaultCollectionAgent;
import org.opennms.netmgt.collectd.JUnitCollector;
import org.opennms.netmgt.collectd.JUnitCollectorExecutionListener;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.collectd.SnmpCollector;
import org.opennms.netmgt.collectd.TestContextAware;
import org.opennms.netmgt.config.DatabaseSchemaConfigFactory;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.collector.CollectionSet;
import org.opennms.netmgt.dao.FilterDao;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.ServiceTypeDao;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.db.TemporaryDatabase;
import org.opennms.netmgt.dao.db.TemporaryDatabaseAware;
import org.opennms.netmgt.dao.support.JdbcFilterDao;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.mock.MockEventIpcManager;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.test.mock.MockLogAppender;
import org.opennms.test.mock.MockUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@TestExecutionListeners(value={JUnitCollectorExecutionListener.class})
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-proxy-snmp.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(reuseDatabase=false)
public class SnmpCollectorTest
implements InitializingBean,
TemporaryDatabaseAware<TemporaryDatabase>,
TestContextAware {
    @Autowired
    private MockEventIpcManager m_mockEventIpcManager;
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private ServiceTypeDao m_serviceTypeDao;
    @Autowired
    private SnmpPeerFactory m_snmpPeerFactory;
    private TestContext m_context;
    private String m_testHostName;
    private static final String TEST_NODE_LABEL = "TestNode";
    private CollectionSpecification m_collectionSpecification;
    private CollectionAgent m_collectionAgent;
    private TemporaryDatabase m_database;
    private SnmpAgentConfig m_agentConfig;

    public void setTemporaryDatabase(TemporaryDatabase database) {
        this.m_database = database;
    }

    public void afterPropertiesSet() {
        Assert.assertNotNull((Object)this.m_mockEventIpcManager);
        Assert.assertNotNull((Object)this.m_transactionManager);
        Assert.assertNotNull((Object)this.m_nodeDao);
        Assert.assertNotNull((Object)this.m_ipInterfaceDao);
        Assert.assertNotNull((Object)this.m_serviceTypeDao);
    }

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        DatabaseSchemaConfigFactory.init();
        JdbcFilterDao jdbcFilterDao = new JdbcFilterDao();
        jdbcFilterDao.setDataSource((DataSource)this.m_database);
        jdbcFilterDao.setDatabaseSchemaConfigFactory(DatabaseSchemaConfigFactory.getInstance());
        jdbcFilterDao.afterPropertiesSet();
        FilterDaoFactory.setInstance((FilterDao)jdbcFilterDao);
        RrdUtils.setStrategy((RrdStrategy)RrdUtils.getSpecificStrategy((RrdUtils.StrategyName)RrdUtils.StrategyName.basicRrdStrategy));
        this.m_testHostName = InetAddressUtils.str((InetAddress)InetAddress.getLocalHost());
        OnmsIpInterface iface = null;
        OnmsNode testNode = null;
        List testNodes = this.m_nodeDao.findByLabel(TEST_NODE_LABEL);
        if (testNodes == null || testNodes.size() < 1) {
            NetworkBuilder builder = new NetworkBuilder();
            builder.addNode(TEST_NODE_LABEL).setId(Integer.valueOf(1)).setSysObjectId(".1.3.6.1.4.1.1588.2.1.1.1");
            builder.addSnmpInterface(1).setIfName("lo0").setPhysAddr("00:11:22:33:44");
            builder.addSnmpInterface(2).setIfName("gif0").setPhysAddr("00:11:22:33:45").setIfType(Integer.valueOf(55));
            builder.addSnmpInterface(3).setIfName("stf0").setPhysAddr("00:11:22:33:46").setIfType(Integer.valueOf(57));
            NetworkBuilder.InterfaceBuilder ifBldr = builder.addInterface(this.m_testHostName).setIsSnmpPrimary("P");
            ifBldr.addSnmpInterface(6).setIfName("fw0").setPhysAddr("44:33:22:11:00").setIfType(Integer.valueOf(144)).setCollectionEnabled(true);
            testNode = builder.getCurrentNode();
            Assert.assertNotNull((Object)testNode);
            this.m_nodeDao.save((Object)testNode);
            this.m_nodeDao.flush();
        } else {
            testNode = (OnmsNode)testNodes.iterator().next();
        }
        Set ifaces = testNode.getIpInterfaces();
        Assert.assertEquals((long)1L, (long)ifaces.size());
        iface = (OnmsIpInterface)ifaces.iterator().next();
        SnmpPeerFactory.setInstance((SnmpPeerFactory)this.m_snmpPeerFactory);
        SnmpCollector collector = new SnmpCollector();
        collector.initialize(null);
        this.m_collectionSpecification = CollectorTestUtils.createCollectionSpec("SNMP", (ServiceCollector)collector, "default");
        this.m_collectionAgent = DefaultCollectionAgent.create((Integer)iface.getId(), (IpInterfaceDao)this.m_ipInterfaceDao, (PlatformTransactionManager)this.m_transactionManager);
        this.m_agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.getLocalHostAddress());
    }

    @After
    public void tearDown() throws Exception {
        MockUtil.println((String)"------------ End Test --------------------------");
    }

    @Test
    @JUnitCollector(datacollectionConfig="/org/opennms/netmgt/config/datacollection-config.xml", datacollectionType="snmp", anticipateFiles={"1", "1/fw0"}, anticipateRrds={"1/tcpActiveOpens", "1/tcpAttemptFails", "1/tcpPassiveOpens", "1/tcpRetransSegs", "1/tcpCurrEstab", "1/tcpEstabResets", "1/tcpInErrors", "1/tcpInSegs", "1/tcpOutRsts", "1/tcpOutSegs", "1/fw0/ifInDiscards", "1/fw0/ifInErrors", "1/fw0/ifInNUcastpkts", "1/fw0/ifInOctets", "1/fw0/ifInUcastpkts", "1/fw0/ifOutErrors", "1/fw0/ifOutNUcastPkts", "1/fw0/ifOutOctets", "1/fw0/ifOutUcastPkts"})
    @JUnitSnmpAgent(resource="/org/opennms/netmgt/snmp/snmpTestData1.properties")
    public void testCollect() throws Exception {
        System.setProperty("org.opennms.netmgt.collectd.SnmpCollector.limitCollectionToInstances", "true");
        this.m_collectionSpecification.initialize(this.m_collectionAgent);
        CollectionSet collectionSet = this.m_collectionSpecification.collect(this.m_collectionAgent);
        Assert.assertEquals((String)"collection status", (long)1L, (long)collectionSet.getStatus());
        CollectorTestUtils.persistCollectionSet(this.m_collectionSpecification, collectionSet);
        System.err.println("FIRST COLLECTION FINISHED");
        Thread.sleep(1000L);
        Assert.assertEquals((String)"collection status", (long)1L, (long)this.m_collectionSpecification.collect(this.m_collectionAgent).getStatus());
        System.err.println("SECOND COLLECTION FINISHED");
        this.m_collectionSpecification.release(this.m_collectionAgent);
    }

    @Test
    @Transactional
    @JUnitCollector(datacollectionConfig="/org/opennms/netmgt/config/datacollection-persistTest-config.xml", datacollectionType="snmp", anticipateFiles={"1", "1/fw0"}, anticipateRrds={"1/tcpCurrEstab", "1/fw0/ifInOctets"})
    @JUnitSnmpAgent(resource="/org/opennms/netmgt/snmp/snmpTestData1.properties")
    public void testPersist() throws Exception {
        File snmpRrdDirectory = (File)this.m_context.getAttribute("rrdDirectory");
        File nodeDir = new File(snmpRrdDirectory, "1");
        File rrdFile = new File(nodeDir, SnmpCollectorTest.rrd("tcpCurrEstab"));
        File ifDir = new File(nodeDir, "fw0");
        File ifRrdFile = new File(ifDir, SnmpCollectorTest.rrd("ifInOctets"));
        int numUpdates = 2;
        int stepSizeInSecs = 1;
        int stepSizeInMillis = stepSizeInSecs * 1000;
        this.m_collectionSpecification.initialize(this.m_collectionAgent);
        CollectorTestUtils.collectNTimes(this.m_collectionSpecification, this.m_collectionAgent, numUpdates);
        Assert.assertEquals((Object)new Double(123.0), (Object)RrdUtils.fetchLastValueInRange((String)rrdFile.getAbsolutePath(), (String)"tcpCurrEstab", (int)stepSizeInMillis, (int)stepSizeInMillis));
        Assert.assertEquals((Object)new Double(1234567.0), (Object)RrdUtils.fetchLastValueInRange((String)ifRrdFile.getAbsolutePath(), (String)"ifInOctets", (int)stepSizeInMillis, (int)stepSizeInMillis));
        SnmpUtils.set((SnmpAgentConfig)this.m_agentConfig, (SnmpObjId)SnmpObjId.get((String)".1.3.6.1.2.1.6.9.0"), (SnmpValue)SnmpUtils.getValueFactory().getInt32(456));
        SnmpUtils.set((SnmpAgentConfig)this.m_agentConfig, (SnmpObjId)SnmpObjId.get((String)".1.3.6.1.2.1.2.2.1.10.6"), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(7654321L));
        CollectorTestUtils.collectNTimes(this.m_collectionSpecification, this.m_collectionAgent, numUpdates);
        Assert.assertEquals((Object)new Double(456.0), (Object)RrdUtils.fetchLastValueInRange((String)rrdFile.getAbsolutePath(), (String)"tcpCurrEstab", (int)stepSizeInMillis, (int)stepSizeInMillis));
        Assert.assertEquals((Object)new Double(7654321.0), (Object)RrdUtils.fetchLastValueInRange((String)ifRrdFile.getAbsolutePath(), (String)"ifInOctets", (int)stepSizeInMillis, (int)stepSizeInMillis));
        this.m_collectionSpecification.release(this.m_collectionAgent);
    }

    @Test
    @Transactional
    @JUnitCollector(datacollectionConfig="/org/opennms/netmgt/config/datacollection-config.xml", datacollectionType="snmp", anticipateRrds={"test"})
    public void testUsingFetch() throws Exception {
        File snmpDir = (File)this.m_context.getAttribute("rrdDirectory");
        int stepSize = 1;
        int numUpdates = 2;
        long start = System.currentTimeMillis();
        File rrdFile = new File(snmpDir, SnmpCollectorTest.rrd("test"));
        RrdStrategy m_rrdStrategy = RrdUtils.getStrategy();
        RrdDataSource rrdDataSource = new RrdDataSource("testAttr", "GAUGE", stepSize * 2, "U", "U");
        Object def = m_rrdStrategy.createDefinition("test", snmpDir.getAbsolutePath(), "test", stepSize, Collections.singletonList(rrdDataSource), Collections.singletonList("RRA:AVERAGE:0.5:1:100"));
        m_rrdStrategy.createFile(def);
        Object rrdFileObject = m_rrdStrategy.openFile(rrdFile.getAbsolutePath());
        for (int i = 0; i < numUpdates; ++i) {
            m_rrdStrategy.updateFile(rrdFileObject, "test", start / 1000L - (long)(stepSize * (numUpdates - i)) + ":1");
        }
        m_rrdStrategy.closeFile(rrdFileObject);
        Assert.assertEquals((Object)new Double(1.0), (Object)m_rrdStrategy.fetchLastValueInRange(rrdFile.getAbsolutePath(), "testAttr", stepSize * 1000, stepSize * 1000));
    }

    @Test
    @Transactional
    @JUnitCollector(datacollectionConfig="/org/opennms/netmgt/config/datacollection-brocade-config.xml", datacollectionType="snmp", anticipateRrds={"1/brocadeFCPortIndex/1/swFCPortTxWords", "1/brocadeFCPortIndex/1/swFCPortRxWords", "1/brocadeFCPortIndex/2/swFCPortTxWords", "1/brocadeFCPortIndex/2/swFCPortRxWords", "1/brocadeFCPortIndex/3/swFCPortTxWords", "1/brocadeFCPortIndex/3/swFCPortRxWords", "1/brocadeFCPortIndex/4/swFCPortTxWords", "1/brocadeFCPortIndex/4/swFCPortRxWords", "1/brocadeFCPortIndex/5/swFCPortTxWords", "1/brocadeFCPortIndex/5/swFCPortRxWords", "1/brocadeFCPortIndex/6/swFCPortTxWords", "1/brocadeFCPortIndex/6/swFCPortRxWords", "1/brocadeFCPortIndex/7/swFCPortTxWords", "1/brocadeFCPortIndex/7/swFCPortRxWords", "1/brocadeFCPortIndex/8/swFCPortTxWords", "1/brocadeFCPortIndex/8/swFCPortRxWords"}, anticipateFiles={"1", "1/brocadeFCPortIndex", "1/brocadeFCPortIndex/1/strings.properties", "1/brocadeFCPortIndex/1", "1/brocadeFCPortIndex/2/strings.properties", "1/brocadeFCPortIndex/2", "1/brocadeFCPortIndex/3/strings.properties", "1/brocadeFCPortIndex/3", "1/brocadeFCPortIndex/4/strings.properties", "1/brocadeFCPortIndex/4", "1/brocadeFCPortIndex/5/strings.properties", "1/brocadeFCPortIndex/5", "1/brocadeFCPortIndex/6/strings.properties", "1/brocadeFCPortIndex/6", "1/brocadeFCPortIndex/7/strings.properties", "1/brocadeFCPortIndex/7", "1/brocadeFCPortIndex/8/strings.properties", "1/brocadeFCPortIndex/8"})
    @JUnitSnmpAgent(resource="/org/opennms/netmgt/snmp/brocadeTestData1.properties")
    public void testBrocadeCollect() throws Exception {
        this.m_collectionSpecification.initialize(this.m_collectionAgent);
        CollectionSet collectionSet = this.m_collectionSpecification.collect(this.m_collectionAgent);
        Assert.assertEquals((String)"collection status", (long)1L, (long)collectionSet.getStatus());
        CollectorTestUtils.persistCollectionSet(this.m_collectionSpecification, collectionSet);
        System.err.println("FIRST COLLECTION FINISHED");
        Thread.sleep(1000L);
        Assert.assertEquals((String)"collection status", (long)1L, (long)this.m_collectionSpecification.collect(this.m_collectionAgent).getStatus());
        System.err.println("SECOND COLLECTION FINISHED");
        this.m_collectionSpecification.release(this.m_collectionAgent);
    }

    @Test
    @Transactional
    @JUnitCollector(datacollectionConfig="/org/opennms/netmgt/config/datacollection-brocade-no-ifaces-config.xml", datacollectionType="snmp", anticipateRrds={"1/brocadeFCPortIndex/1/swFCPortTxWords", "1/brocadeFCPortIndex/1/swFCPortRxWords", "1/brocadeFCPortIndex/2/swFCPortTxWords", "1/brocadeFCPortIndex/2/swFCPortRxWords", "1/brocadeFCPortIndex/3/swFCPortTxWords", "1/brocadeFCPortIndex/3/swFCPortRxWords", "1/brocadeFCPortIndex/4/swFCPortTxWords", "1/brocadeFCPortIndex/4/swFCPortRxWords", "1/brocadeFCPortIndex/5/swFCPortTxWords", "1/brocadeFCPortIndex/5/swFCPortRxWords", "1/brocadeFCPortIndex/6/swFCPortTxWords", "1/brocadeFCPortIndex/6/swFCPortRxWords", "1/brocadeFCPortIndex/7/swFCPortTxWords", "1/brocadeFCPortIndex/7/swFCPortRxWords", "1/brocadeFCPortIndex/8/swFCPortTxWords", "1/brocadeFCPortIndex/8/swFCPortRxWords"}, anticipateFiles={"1", "1/brocadeFCPortIndex", "1/brocadeFCPortIndex/1/strings.properties", "1/brocadeFCPortIndex/1", "1/brocadeFCPortIndex/2/strings.properties", "1/brocadeFCPortIndex/2", "1/brocadeFCPortIndex/3/strings.properties", "1/brocadeFCPortIndex/3", "1/brocadeFCPortIndex/4/strings.properties", "1/brocadeFCPortIndex/4", "1/brocadeFCPortIndex/5/strings.properties", "1/brocadeFCPortIndex/5", "1/brocadeFCPortIndex/6/strings.properties", "1/brocadeFCPortIndex/6", "1/brocadeFCPortIndex/7/strings.properties", "1/brocadeFCPortIndex/7", "1/brocadeFCPortIndex/8/strings.properties", "1/brocadeFCPortIndex/8"})
    @JUnitSnmpAgent(resource="/org/opennms/netmgt/snmp/brocadeTestData1.properties")
    public void testBug2447_GenericIndexedOnlyCollect() throws Exception {
        this.m_collectionSpecification.initialize(this.m_collectionAgent);
        CollectionSet collectionSet = this.m_collectionSpecification.collect(this.m_collectionAgent);
        Assert.assertEquals((String)"collection status", (long)1L, (long)collectionSet.getStatus());
        CollectorTestUtils.persistCollectionSet(this.m_collectionSpecification, collectionSet);
        System.err.println("FIRST COLLECTION FINISHED");
        Thread.sleep(1000L);
        Assert.assertEquals((String)"collection status", (long)1L, (long)this.m_collectionSpecification.collect(this.m_collectionAgent).getStatus());
        System.err.println("SECOND COLLECTION FINISHED");
        this.m_collectionSpecification.release(this.m_collectionAgent);
    }

    private static String rrd(String file) {
        return file + RrdUtils.getExtension();
    }

    @Override
    public void setTestContext(TestContext context) {
        this.m_context = context;
    }
}

