/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import junit.framework.TestSuite;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.test.snmp.SnmpTestSuiteUtils;
import org.opennms.netmgt.capsd.plugins.SnmpPlugin;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.mock.OpenNMSTestCase;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class SnmpPluginTest
extends OpenNMSTestCase {
    private boolean m_runAssertions = false;
    private SnmpPlugin m_plugin = null;

    public static TestSuite suite() {
        return SnmpTestSuiteUtils.createSnmpStrategyTestSuite(SnmpPluginTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        SnmpPluginTest.assertNotNull((String)"The org.opennms.snmp.strategyClass must be set to run this test", (Object)System.getProperty("org.opennms.snmp.strategyClass"));
        super.setUp();
        if (this.m_plugin == null) {
            this.m_plugin = new SnmpPlugin();
        }
        m_runSupers = false;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testIsForcedV1ProtocolSupported() throws UnknownHostException {
        InetAddress address = this.myLocalHost();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("forced version", "snmpv1");
        if (this.m_runAssertions) {
            SnmpPluginTest.assertTrue((String)"protocol is not supported", (boolean)this.m_plugin.isProtocolSupported(address, map));
        }
    }

    public void testIsExpectedValue() throws UnknownHostException {
        InetAddress address = this.myLocalHost();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("vbvalue", "\\.1\\.3\\.6\\.1\\.4\\.1.*");
        if (this.m_runAssertions) {
            SnmpPluginTest.assertTrue((String)"protocol is not supported", (boolean)this.m_plugin.isProtocolSupported(address, map));
        }
    }

    public final void testIsProtocolSupportedInetAddress() throws UnknownHostException {
        if (this.m_runAssertions) {
            SnmpPluginTest.assertTrue((String)"protocol is not supported", (boolean)this.m_plugin.isProtocolSupported(this.myLocalHost()));
        }
    }

    public final void testIsV3ProtocolSupported() throws ValidationException, IOException, IOException, MarshalException {
        this.setVersion(3);
        ByteArrayResource rsrc = new ByteArrayResource(this.getSnmpConfig().getBytes());
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory((Resource)rsrc));
        if (this.m_runAssertions) {
            SnmpPluginTest.assertTrue((String)"protocol is not supported", (boolean)this.m_plugin.isProtocolSupported(this.myLocalHost()));
        }
    }

    public final void testIsV3ForcedToV1Supported() throws ValidationException, IOException, IOException, MarshalException {
        this.setVersion(3);
        ByteArrayResource rsrc = new ByteArrayResource(this.getSnmpConfig().getBytes());
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory((Resource)rsrc));
        HashMap<String, String> qualifiers = new HashMap<String, String>();
        qualifiers.put("force version", "snmpv1");
        if (this.m_runAssertions) {
            SnmpPluginTest.assertTrue((String)"protocol is not supported", (boolean)this.m_plugin.isProtocolSupported(this.myLocalHost(), qualifiers));
        }
    }
}

