/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.mock.snmp.MockSnmpAgent;
import org.opennms.netmgt.capsd.IfSnmpCollector;
import org.opennms.netmgt.capsd.snmp.IfTable;
import org.opennms.netmgt.capsd.snmp.IfXTable;
import org.opennms.netmgt.capsd.snmp.IpAddrTable;
import org.opennms.netmgt.capsd.snmp.SystemGroup;
import org.opennms.netmgt.mock.OpenNMSTestCase;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class IfSnmpCollectorTestCase
extends OpenNMSTestCase {
    private static final String HOST_PROPERTY = "mock.snmpHost";
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final int PORT = 9161;
    private InetAddress m_addr;
    private volatile MockSnmpAgent m_agent;
    private volatile IfSnmpCollector m_ifSnmpc;
    private volatile boolean m_hasRun = false;

    @Override
    protected void setUp() throws Exception {
        this.setStartEventd(false);
        super.setUp();
        String hostName = System.getProperty(HOST_PROPERTY, DEFAULT_HOST);
        this.m_addr = InetAddressUtils.addr((String)hostName);
        this.m_ifSnmpc = new IfSnmpCollector(this.m_addr);
        this.m_agent = MockSnmpAgent.createAgentAndRun((Resource)new ClassPathResource("org/opennms/netmgt/snmp/snmpTestData1.properties"), (String)(InetAddressUtils.str((InetAddress)this.m_addr) + "/" + 9161));
        this.runCollection();
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_agent.shutDownAndWait();
        super.tearDown();
    }

    public final void testIfSnmpCollector() throws UnknownHostException {
        IfSnmpCollectorTestCase.assertFalse((String)"collection should not have failed", (boolean)this.m_ifSnmpc.failed());
    }

    public void testFailed() throws Exception {
        this.m_agent.shutDownAndWait();
        IfSnmpCollector ifSnmpc = new IfSnmpCollector(this.m_addr);
        ifSnmpc.run();
        IfSnmpCollectorTestCase.assertTrue((String)"collection should fail", (boolean)ifSnmpc.failed());
        IfSnmpCollectorTestCase.assertTrue((String)"system group collection should fail", (boolean)ifSnmpc.getSystemGroup().failed());
        IfSnmpCollectorTestCase.assertTrue((String)"ifTable collection should fail", (boolean)ifSnmpc.getIfTable().failed());
        IfSnmpCollectorTestCase.assertTrue((String)"ifXTable collection should fail", (boolean)ifSnmpc.getIfXTable().failed());
        IfSnmpCollectorTestCase.assertTrue((String)"ipAddrTable collection should fail", (boolean)ifSnmpc.getIpAddrTable().failed());
    }

    public final void testHasSystemGroup() {
        IfSnmpCollectorTestCase.assertTrue((String)"should have a system group", (boolean)this.m_ifSnmpc.hasSystemGroup());
    }

    public final void testGetSystemGroup() throws UnknownHostException {
        SystemGroup sg = this.m_ifSnmpc.getSystemGroup();
        IfSnmpCollectorTestCase.assertNotNull((String)"system group should not be null", (Object)sg);
        IfSnmpCollectorTestCase.assertFalse((String)"system group should not have failed", (boolean)sg.failed());
        IfSnmpCollectorTestCase.assertEquals((String)"system group name", (String)"brozow.local", (String)sg.getSysName());
    }

    public final void testHasIfTable() {
        IfSnmpCollectorTestCase.assertTrue((boolean)this.m_ifSnmpc.hasIfTable());
    }

    public final void testGetIfTable() {
        IfTable ifTable = this.m_ifSnmpc.getIfTable();
        IfSnmpCollectorTestCase.assertNotNull((String)"should have an ifTable", (Object)ifTable);
        IfSnmpCollectorTestCase.assertFalse((String)"ifTable collection should not have failed", (boolean)ifTable.failed());
        IfSnmpCollectorTestCase.assertEquals((String)"iftype", (int)24, (int)ifTable.getIfType(1));
    }

    public final void testHasIpAddrTable() {
        IfSnmpCollectorTestCase.assertTrue((String)"should have an ipAddrTable", (boolean)this.m_ifSnmpc.hasIpAddrTable());
    }

    public final void testGetIpAddrTable() throws UnknownHostException {
        IpAddrTable ipAddrTable = this.m_ifSnmpc.getIpAddrTable();
        IfSnmpCollectorTestCase.assertNotNull((String)"ipAddrTable should not be null", (Object)ipAddrTable);
        IfSnmpCollectorTestCase.assertFalse((String)"ipAddrTable collection should not hahve failed", (boolean)ipAddrTable.failed());
        IfSnmpCollectorTestCase.assertEquals((String)"ipAddrTable ifIndex of 127.0.0.1", (int)1, (int)ipAddrTable.getIfIndex(InetAddressUtils.addr((String)DEFAULT_HOST)));
        List addresses = ipAddrTable.getIpAddresses();
        IfSnmpCollectorTestCase.assertTrue((String)"ipAddrTable should contain 172.20.1.201", (boolean)addresses.contains(InetAddressUtils.addr((String)"172.20.1.201")));
        IfSnmpCollectorTestCase.assertTrue((String)"ipAddrTable should contain 127.0.0.1 like any good IP stack should", (boolean)addresses.contains(InetAddressUtils.addr((String)DEFAULT_HOST)));
    }

    public final void testHasIfXTable() {
        IfSnmpCollectorTestCase.assertTrue((String)"should have an ifXTable", (boolean)this.m_ifSnmpc.hasIfXTable());
    }

    public final void testGetIfXTable() {
        IfXTable ifXTable = this.m_ifSnmpc.getIfXTable();
        IfSnmpCollectorTestCase.assertNotNull((String)"ifXTable should not be null", (Object)ifXTable);
        IfSnmpCollectorTestCase.assertFalse((String)"ifXTable collection should not have failed", (boolean)ifXTable.failed());
    }

    public final void testGetCollectorTargetAddress() {
        InetAddress target = this.m_ifSnmpc.getCollectorTargetAddress();
        IfSnmpCollectorTestCase.assertNotNull((String)"target addresss should not be null", (Object)target);
        IfSnmpCollectorTestCase.assertEquals((String)"target address", (Object)this.myLocalHost(), (Object)target);
    }

    public final void testGetIfAddressAndMask() {
        InetAddress[] addrMask = this.m_ifSnmpc.getIfAddressAndMask(1);
        IfSnmpCollectorTestCase.assertNotNull((String)"address mask should not be null", (Object)addrMask);
        IfSnmpCollectorTestCase.assertEquals((String)"localhost address", (String)DEFAULT_HOST, (String)InetAddressUtils.str((InetAddress)addrMask[0]));
        IfSnmpCollectorTestCase.assertEquals((String)"localhost mask... mmm... class A.... yummy", (String)"255.0.0.0", (String)InetAddressUtils.str((InetAddress)addrMask[1]));
    }

    public final void testGetAdminStatus() {
        int adminStatus = this.m_ifSnmpc.getAdminStatus(1);
        IfSnmpCollectorTestCase.assertEquals((String)"admin status", (int)1, (int)adminStatus);
    }

    public final void testGetIfType() {
        int ifType = this.m_ifSnmpc.getIfType(1);
        IfSnmpCollectorTestCase.assertEquals((String)"ifType", (int)24, (int)ifType);
    }

    public final void testGetIfIndex() throws UnknownHostException {
        int ifIndex = this.m_ifSnmpc.getIfIndex(InetAddressUtils.addr((String)"172.20.1.201"));
        IfSnmpCollectorTestCase.assertEquals((String)"ifIndex", (int)5, (int)ifIndex);
    }

    public final void testGetIfName() {
        String ifName = this.m_ifSnmpc.getIfName(1);
        IfSnmpCollectorTestCase.assertNotNull((String)"ifName should not be null", (Object)ifName);
        IfSnmpCollectorTestCase.assertEquals((String)"ifName", (String)"There's no place like 127.0.0.1", (String)ifName);
    }

    public final void testGetIfSpeed() {
        Long ifSpeed = this.m_ifSnmpc.getInterfaceSpeed(4);
        IfSnmpCollectorTestCase.assertNotNull((String)"ifSpeed should not be null", (Object)ifSpeed);
        IfSnmpCollectorTestCase.assertEquals((String)"ifSpeed", (Object)new Long(10000000L), (Object)ifSpeed);
    }

    public final void testGetIfAlias() {
        String ifAlias = this.m_ifSnmpc.getIfAlias(1);
        IfSnmpCollectorTestCase.assertNotNull((String)"ifAlias should not be null", (Object)ifAlias);
        IfSnmpCollectorTestCase.assertEquals((String)"ifAlias", (String)"We don't need no stinkin' ifAlias!", (String)ifAlias);
    }

    private void runCollection() {
        if (this.m_hasRun) {
            return;
        }
        this.m_ifSnmpc.run();
        this.m_hasRun = true;
    }

    public static class SNMP4JIfSnmpCollectorTestCase
    extends IfSnmpCollectorTestCase {
        @Override
        public void setUp() throws Exception {
            System.setProperty("org.opennms.snmp.strategyClass", "org.opennms.netmgt.snmp.snmp4j.Snmp4JStrategy");
            super.setUp();
        }
    }

    public static class JoeSnmpIfSnmpCollectorTestCase
    extends IfSnmpCollectorTestCase {
        @Override
        public void setUp() throws Exception {
            System.setProperty("org.opennms.snmp.strategyClass", "org.opennms.netmgt.snmp.joesnmp.JoeSnmpStrategy");
            super.setUp();
        }
    }
}

