/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.destinationPaths.DestinationPaths;
import org.opennms.netmgt.config.destinationPaths.Escalate;
import org.opennms.netmgt.config.destinationPaths.Header;
import org.opennms.netmgt.config.destinationPaths.Path;
import org.opennms.netmgt.config.destinationPaths.Target;
import org.opennms.netmgt.events.api.EventConstants;

public abstract class DestinationPathManager {
    private DestinationPaths allPaths;
    private Map<String, Path> m_destinationPaths;
    private Header oldHeader;

    protected void parseXML(InputStream stream) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(stream);){
            this.allPaths = (DestinationPaths)JaxbUtils.unmarshal(DestinationPaths.class, (Reader)isr);
            this.oldHeader = this.allPaths.getHeader();
            this.initializeDestinationPaths();
        }
    }

    private void initializeDestinationPaths() {
        this.m_destinationPaths = new TreeMap<String, Path>();
        for (Path curPath : this.allPaths.getPaths()) {
            this.m_destinationPaths.put(curPath.getName(), curPath);
        }
    }

    public Path getPath(String pathName) throws IOException {
        this.update();
        return this.m_destinationPaths.get(pathName);
    }

    public Map<String, Path> getPaths() throws IOException {
        this.update();
        return Collections.unmodifiableMap(this.m_destinationPaths);
    }

    public Collection<String> getTargetCommands(Path path, int index, String target) throws IOException {
        this.update();
        Target[] targets = this.getTargetList(index, path);
        for (int i = 0; i < targets.length; ++i) {
            if (!targets[i].getName().equals(target)) continue;
            return targets[i].getCommands();
        }
        return null;
    }

    public Target[] getTargetList(int index, Path path) throws IOException {
        this.update();
        Target[] targets = null;
        targets = index == -1 ? path.getTargets().toArray(new Target[0]) : ((Escalate)path.getEscalates().get(index)).getTargets().toArray(new Target[0]);
        return targets;
    }

    public boolean pathHasTarget(Path path, String target) throws IOException {
        this.update();
        for (Target curTarget : path.getTargets()) {
            if (!curTarget.getName().equals(target)) continue;
            return true;
        }
        return false;
    }

    public synchronized void addPath(Path newPath) throws IOException {
        this.m_destinationPaths.put(newPath.getName(), newPath);
        this.saveCurrent();
    }

    public synchronized void replacePath(String oldName, Path newPath) throws IOException {
        if (this.m_destinationPaths.containsKey(oldName)) {
            this.m_destinationPaths.remove(oldName);
        }
        this.addPath(newPath);
    }

    public synchronized void removePath(Path path) throws IOException {
        this.m_destinationPaths.remove(path.getName());
        this.saveCurrent();
    }

    public synchronized void removePath(String name) throws IOException {
        this.m_destinationPaths.remove(name);
        this.saveCurrent();
    }

    public synchronized void saveCurrent() throws IOException {
        this.allPaths.clearPaths();
        for (Path path : this.m_destinationPaths.values()) {
            this.allPaths.addPath(path);
        }
        this.allPaths.setHeader(this.rebuildHeader());
        StringWriter stringWriter = new StringWriter();
        JaxbUtils.marshal((Object)this.allPaths, (Writer)stringWriter);
        String writerString = stringWriter.toString();
        this.saveXML(writerString);
    }

    protected abstract void saveXML(String var1) throws IOException;

    private Header rebuildHeader() {
        Header header = this.oldHeader;
        header.setCreated(EventConstants.formatToString((Date)new Date()));
        return header;
    }

    public abstract void update() throws IOException, FileNotFoundException;
}

