/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.config.GroupFactory;
import org.opennms.netmgt.config.UserManager;

public class UserFactory
extends UserManager {
    private static UserManager instance;
    private static boolean initialized;
    private File m_usersConfFile;
    private long m_lastModified;
    private long m_fileSize;

    public UserFactory() throws MarshalException, ValidationException, FileNotFoundException, IOException {
        super(GroupFactory.getInstance());
        this.reload();
    }

    public static synchronized void init() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        if (instance == null || !initialized) {
            GroupFactory.init();
            instance = new UserFactory();
            initialized = true;
        }
    }

    public static synchronized UserManager getInstance() {
        return instance;
    }

    public static synchronized void setInstance(UserManager mgr) {
        initialized = true;
        instance = mgr;
    }

    @Override
    public void reload() throws IOException, FileNotFoundException {
        this.m_usersConfFile = ConfigFileConstants.getFile((int)ConfigFileConstants.USERS_CONF_FILE_NAME);
        FileInputStream configIn = new FileInputStream(this.m_usersConfFile);
        this.m_lastModified = this.m_usersConfFile.lastModified();
        this.m_fileSize = this.m_usersConfFile.length();
        this.parseXML(configIn);
        initialized = true;
    }

    @Override
    protected void saveXML(String writerString) throws IOException {
        if (writerString != null) {
            OutputStreamWriter fileWriter = null;
            try {
                fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.m_usersConfFile), "UTF-8");
                fileWriter.write(writerString);
                ((Writer)fileWriter).flush();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriter);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)fileWriter);
        }
    }

    @Override
    public boolean isUpdateNeeded() {
        if (this.m_usersConfFile == null) {
            return true;
        }
        long fileLastModified = this.m_usersConfFile.lastModified();
        if (this.m_fileSize != this.m_usersConfFile.length()) {
            return true;
        }
        return this.m_lastModified != fileLastModified;
    }

    @Override
    public void doUpdate() throws IOException, FileNotFoundException {
        if (this.isUpdateNeeded()) {
            this.reload();
        }
    }

    @Override
    public long getLastModified() {
        return this.m_lastModified;
    }

    @Override
    public long getFileSize() {
        return this.m_fileSize;
    }

    static {
        initialized = false;
    }
}

