/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.RWSConfig;
import org.opennms.netmgt.config.rws.BaseUrl;
import org.opennms.netmgt.config.rws.RwsConfiguration;
import org.opennms.netmgt.config.rws.StandbyUrl;
import org.opennms.rancid.ConnectionProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RWSConfigManager
implements RWSConfig {
    private static final Logger LOG = LoggerFactory.getLogger(RWSConfigManager.class);
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    private int m_cursor = 0;
    private RwsConfiguration m_config;

    public RWSConfigManager() {
    }

    public RWSConfigManager(InputStream stream) throws MarshalException, ValidationException, IOException {
        this.reloadXML(stream);
    }

    @Override
    public Lock getReadLock() {
        return this.m_readLock;
    }

    @Override
    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    @Override
    public ConnectionProperties getBase() {
        try {
            this.getReadLock().lock();
            LOG.debug("Connections used: {}{}", (Object)this.getBaseUrl().getServer_url(), (Object)this.getBaseUrl().getDirectory());
            LOG.debug("RWS timeout(sec): {}", (Object)this.getBaseUrl().getTimeout());
            if (this.getBaseUrl().getUsername() == null) {
                ConnectionProperties connectionProperties = new ConnectionProperties(this.getBaseUrl().getServer_url(), this.getBaseUrl().getDirectory(), this.getBaseUrl().getTimeout());
                return connectionProperties;
            }
            String password = "";
            if (this.getBaseUrl().getPassword() != null) {
                password = this.getBaseUrl().getPassword();
            }
            ConnectionProperties connectionProperties = new ConnectionProperties(this.getBaseUrl().getUsername(), password, this.getBaseUrl().getServer_url(), this.getBaseUrl().getDirectory(), this.getBaseUrl().getTimeout());
            return connectionProperties;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionProperties getNextStandBy() {
        if (!this.hasStandbyUrl()) {
            return null;
        }
        try {
            this.getReadLock().lock();
            StandbyUrl standByUrl = this.getNextStandbyUrl();
            LOG.debug("Connections used: {}{}", (Object)standByUrl.getServer_url(), (Object)standByUrl.getDirectory());
            LOG.debug("RWS timeout(sec): {}", (Object)standByUrl.getTimeout());
            if (standByUrl.getUsername() == null) {
                ConnectionProperties connectionProperties = new ConnectionProperties(standByUrl.getServer_url(), standByUrl.getDirectory(), standByUrl.getTimeout());
                return connectionProperties;
            }
            String password = "";
            if (standByUrl.getPassword() != null) {
                password = standByUrl.getPassword();
            }
            ConnectionProperties connectionProperties = new ConnectionProperties(standByUrl.getUsername(), password, standByUrl.getServer_url(), standByUrl.getDirectory(), standByUrl.getTimeout());
            return connectionProperties;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public ConnectionProperties[] getStandBy() {
        return null;
    }

    @Override
    public BaseUrl getBaseUrl() {
        try {
            this.getReadLock().lock();
            BaseUrl baseUrl = this.m_config.getBaseUrl();
            return baseUrl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public StandbyUrl[] getStanbyUrls() {
        try {
            this.getReadLock().lock();
            StandbyUrl[] standbyUrlArray = this.m_config.getStandbyUrl();
            return standbyUrlArray;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public StandbyUrl getNextStandbyUrl() {
        try {
            this.getReadLock().lock();
            StandbyUrl standbyUrl = null;
            if (this.hasStandbyUrl()) {
                if (this.m_cursor == this.m_config.getStandbyUrlCount()) {
                    this.m_cursor = 0;
                }
                standbyUrl = this.m_config.getStandbyUrl(this.m_cursor++);
            }
            StandbyUrl standbyUrl2 = standbyUrl;
            return standbyUrl2;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public boolean hasStandbyUrl() {
        try {
            this.getReadLock().lock();
            boolean bl = this.m_config.getStandbyUrlCount() > 0;
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    protected void reloadXML(InputStream stream) throws MarshalException, ValidationException, IOException {
        try {
            this.getWriteLock().lock();
            this.m_config = (RwsConfiguration)CastorUtils.unmarshal(RwsConfiguration.class, (InputStream)stream);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    public RwsConfiguration getConfiguration() {
        try {
            this.getReadLock().lock();
            RwsConfiguration rwsConfiguration = this.m_config;
            return rwsConfiguration;
        }
        finally {
            this.getReadLock().unlock();
        }
    }
}

