/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd.rrdtool;

import java.io.File;
import java.util.List;
import java.util.Properties;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.rrdtool.AbstractJniRrdStrategy;
import org.opennms.netmgt.rrd.rrdtool.Interface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JniRrdStrategy
extends AbstractJniRrdStrategy<CreateCommand, StringBuffer> {
    private static final Logger LOG = LoggerFactory.getLogger(JniRrdStrategy.class);
    private Properties m_configurationProperties;

    public Properties getConfigurationProperties() {
        return this.m_configurationProperties;
    }

    public void setConfigurationProperties(Properties configurationParameters) {
        this.m_configurationProperties = configurationParameters;
    }

    public void closeFile(StringBuffer rrd) throws Exception {
        String command = rrd.toString();
        String[] results = Interface.launch(command);
        if (results[0] != null) {
            throw new Exception(results[0]);
        }
    }

    public CreateCommand createDefinition(String creator, String directory, String rrdName, int step, List<RrdDataSource> dataSources, List<String> rraList) throws Exception {
        String fileName;
        File f = new File(directory);
        if (!f.exists() && !f.mkdirs()) {
            LOG.warn("Could not make directory: {}", (Object)f.getPath());
        }
        if (new File(fileName = directory + File.separator + rrdName + this.getDefaultFileExtension()).exists()) {
            LOG.debug("createDefinition: filename [{}] already exists returning null as definition", (Object)fileName);
            return null;
        }
        StringBuffer parameter = new StringBuffer();
        parameter.append(" --start=" + (System.currentTimeMillis() / 1000L - 10L));
        parameter.append(" --step=" + step);
        for (RrdDataSource dataSource : dataSources) {
            parameter.append(" DS:");
            parameter.append(dataSource.getName()).append(':');
            parameter.append(dataSource.getType()).append(":");
            parameter.append(dataSource.getHeartBeat()).append(':');
            parameter.append(dataSource.getMin()).append(':');
            parameter.append(dataSource.getMax());
        }
        for (String rra : rraList) {
            parameter.append(' ');
            parameter.append(rra);
        }
        return new CreateCommand(fileName, parameter.toString());
    }

    public void createFile(CreateCommand createCommand) throws Exception {
        if (createCommand == null) {
            LOG.debug("createRRD: skipping RRD file");
            return;
        }
        LOG.debug("Executing: rrdtool {}", (Object)createCommand.toString());
        Interface.launch(createCommand.toString());
    }

    public StringBuffer openFile(String fileName) throws Exception {
        return new StringBuffer("update " + fileName);
    }

    public void updateFile(StringBuffer rrd, String owner, String data) throws Exception {
        rrd.append(' ');
        rrd.append(data);
    }

    public JniRrdStrategy() throws Exception {
        Interface.init();
    }

    public Double fetchLastValue(String rrdFile, String ds, int interval) throws NumberFormatException, RrdException {
        return this.fetchLastValue(rrdFile, ds, "AVERAGE", interval);
    }

    public Double fetchLastValue(String rrdFile, String ds, String consolidationFunction, int interval) {
        String fetchCmd = "fetch " + rrdFile + " " + consolidationFunction + " -s now-" + interval / 1000 + " -e now-" + interval / 1000;
        LOG.debug("fetch: Issuing RRD command: {}", (Object)fetchCmd);
        String[] fetchStrings = Interface.launch(fetchCmd);
        if (fetchStrings == null) {
            LOG.error("fetch: Unexpected error issuing RRD 'fetch' command, no error text available.");
            return null;
        }
        if (fetchStrings[0] != null) {
            LOG.error("fetch: RRD database 'fetch' failed, reason: {}", (Object)fetchStrings[0]);
            return null;
        }
        if (fetchStrings[1] == null || fetchStrings[2] == null) {
            LOG.error("fetch: RRD database 'fetch' failed, no data retrieved.");
            return null;
        }
        String[] dsNames = fetchStrings[1].split("\\s");
        int dsIndex = 0;
        for (int i = 0; i < dsNames.length; ++i) {
            if (!dsNames[i].equals(ds)) continue;
            dsIndex = i;
        }
        String dsName = dsNames[dsIndex].trim();
        String[] dsValues = fetchStrings[2].split("\\s");
        Double dsValue = null;
        if (dsValues[dsIndex].trim().toLowerCase().endsWith("nan")) {
            dsValue = new Double(Double.NaN);
        } else {
            try {
                dsValue = new Double(dsValues[dsIndex].trim());
            }
            catch (NumberFormatException nfe) {
                LOG.warn("fetch: Unable to convert fetched value ({}) to Double for data source {}", (Object)dsValues[dsIndex].trim(), (Object)dsName);
                throw nfe;
            }
        }
        LOG.debug("fetch: fetch successful: {}={}", (Object)dsName, (Object)dsValue);
        return dsValue;
    }

    public Double fetchLastValueInRange(String rrdFile, String ds, int interval, int range) throws NumberFormatException, RrdException {
        long now = System.currentTimeMillis();
        long latestUpdateTime = (now - now % (long)interval) / 1000L;
        long earliestUpdateTime = (now - now % (long)interval - (long)range) / 1000L;
        LOG.debug("fetchInRange: fetching data from {} to {}", (Object)earliestUpdateTime, (Object)latestUpdateTime);
        String fetchCmd = "fetch " + rrdFile + " AVERAGE -s " + earliestUpdateTime + " -e " + latestUpdateTime;
        String[] fetchStrings = Interface.launch(fetchCmd);
        if (fetchStrings == null) {
            LOG.error("fetchInRange: Unexpected error issuing RRD 'fetch' command, no error text available.");
            return null;
        }
        if (fetchStrings[0] != null) {
            LOG.error("fetchInRange: RRD database 'fetch' failed, reason: {}", (Object)fetchStrings[0]);
            return null;
        }
        if (fetchStrings[1] == null || fetchStrings[2] == null) {
            LOG.error("fetchInRange: RRD database 'fetch' failed, no data retrieved.");
            return null;
        }
        int numFetched = fetchStrings.length;
        LOG.debug("fetchInRange: got {} strings from RRD", (Object)numFetched);
        String[] dsNames = fetchStrings[1].split("\\s");
        int dsIndex = 0;
        for (int i = 0; i < dsNames.length; ++i) {
            if (!dsNames[i].equals(ds)) continue;
            dsIndex = i;
        }
        String dsName = dsNames[dsIndex].trim();
        for (int i = fetchStrings.length - 2; i > 1; --i) {
            String[] dsValues = fetchStrings[i].split("\\s");
            if (!dsValues[dsIndex].trim().toLowerCase().endsWith("nan")) {
                try {
                    Double dsValue = new Double(dsValues[dsIndex].trim());
                    LOG.debug("fetchInRange: fetch successful: {}= {}", (Object)dsName, (Object)dsValue);
                    return dsValue;
                }
                catch (NumberFormatException nfe) {
                    LOG.warn("fetchInRange: Unable to convert fetched value ({}) to Double for data source {}", (Object)dsValues[dsIndex].trim(), (Object)dsName);
                    throw nfe;
                }
            }
            LOG.debug("fetchInRange: Got a NaN value - continuing back in time");
        }
        return null;
    }

    public static class CreateCommand {
        private static final String OPERATION = "create";
        String filename;
        String parameter;

        public CreateCommand(String filename, String parameter) {
            this.filename = filename;
            this.parameter = parameter;
        }

        public String toString() {
            return "create " + this.filename + " " + this.parameter;
        }
    }
}

