/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd.rrdtool;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.opennms.core.utils.StringUtils;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdGraphDetails;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.rrd.rrdtool.Interface;
import org.opennms.netmgt.rrd.rrdtool.JniGraphDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;

public class JniRrdStrategy
implements RrdStrategy<CreateCommand, StringBuffer> {
    private static final Logger LOG = LoggerFactory.getLogger(JniRrdStrategy.class);
    private static final String IGNORABLE_LIBART_WARNING_STRING = "*** attempt to put segment in horiz list twice";
    private static final String IGNORABLE_LIBART_WARNING_REGEX = "\\*\\*\\* attempt to put segment in horiz list twice\r?\n?";
    private Properties m_configurationProperties;

    public Properties getConfigurationProperties() {
        return this.m_configurationProperties;
    }

    public void setConfigurationProperties(Properties configurationParameters) {
        this.m_configurationProperties = configurationParameters;
    }

    public void closeFile(StringBuffer rrd) throws Exception {
        String command = rrd.toString();
        String[] results = Interface.launch(command);
        if (results[0] != null) {
            throw new Exception(results[0]);
        }
    }

    public CreateCommand createDefinition(String creator, String directory, String rrdName, int step, List<RrdDataSource> dataSources, List<String> rraList) throws Exception {
        File f = new File(directory);
        f.mkdirs();
        String fileName = directory + File.separator + rrdName + RrdUtils.getExtension();
        if (new File(fileName).exists()) {
            LOG.debug("createDefinition: filename [{}] already exists returning null as definition", (Object)fileName);
            return null;
        }
        StringBuffer parameter = new StringBuffer();
        parameter.append(" --start=" + (System.currentTimeMillis() / 1000L - 10L));
        parameter.append(" --step=" + step);
        for (RrdDataSource dataSource : dataSources) {
            parameter.append(" DS:");
            parameter.append(dataSource.getName()).append(':');
            parameter.append(dataSource.getType()).append(":");
            parameter.append(dataSource.getHeartBeat()).append(':');
            parameter.append(dataSource.getMin()).append(':');
            parameter.append(dataSource.getMax());
        }
        for (String rra : rraList) {
            parameter.append(' ');
            parameter.append(rra);
        }
        return new CreateCommand(fileName, parameter.toString());
    }

    public void createFile(CreateCommand createCommand, Map<String, String> attributeMappings) throws Exception {
        if (createCommand == null) {
            LOG.debug("createRRD: skipping RRD file");
            return;
        }
        LOG.debug("Executing: rrdtool {}", (Object)createCommand.toString());
        Interface.launch(createCommand.toString());
        String filenameWithoutExtension = createCommand.filename.replace(RrdUtils.getExtension(), "");
        int lastIndexOfSeparator = filenameWithoutExtension.lastIndexOf(File.separator);
        RrdUtils.createMetaDataFile((String)filenameWithoutExtension.substring(0, lastIndexOfSeparator), (String)filenameWithoutExtension.substring(lastIndexOfSeparator), attributeMappings);
    }

    public StringBuffer openFile(String fileName) throws Exception {
        return new StringBuffer("update " + fileName);
    }

    public void updateFile(StringBuffer rrd, String owner, String data) throws Exception {
        rrd.append(' ');
        rrd.append(data);
    }

    public JniRrdStrategy() throws Exception {
        Interface.init();
    }

    public Double fetchLastValue(String rrdFile, String ds, int interval) throws NumberFormatException, RrdException {
        return this.fetchLastValue(rrdFile, ds, "AVERAGE", interval);
    }

    public Double fetchLastValue(String rrdFile, String ds, String consolidationFunction, int interval) {
        String fetchCmd = "fetch " + rrdFile + " " + consolidationFunction + " -s now-" + interval / 1000 + " -e now-" + interval / 1000;
        LOG.debug("fetch: Issuing RRD command: {}", (Object)fetchCmd);
        String[] fetchStrings = Interface.launch(fetchCmd);
        if (fetchStrings == null) {
            LOG.error("fetch: Unexpected error issuing RRD 'fetch' command, no error text available.");
            return null;
        }
        if (fetchStrings[0] != null) {
            LOG.error("fetch: RRD database 'fetch' failed, reason: {}", (Object)fetchStrings[0]);
            return null;
        }
        if (fetchStrings[1] == null || fetchStrings[2] == null) {
            LOG.error("fetch: RRD database 'fetch' failed, no data retrieved.");
            return null;
        }
        String[] dsNames = fetchStrings[1].split("\\s");
        int dsIndex = 0;
        for (int i = 0; i < dsNames.length; ++i) {
            if (!dsNames[i].equals(ds)) continue;
            dsIndex = i;
        }
        String dsName = dsNames[dsIndex].trim();
        String[] dsValues = fetchStrings[2].split("\\s");
        Double dsValue = null;
        if (dsValues[dsIndex].trim().equalsIgnoreCase("nan")) {
            dsValue = new Double(Double.NaN);
        } else {
            try {
                dsValue = new Double(dsValues[dsIndex].trim());
            }
            catch (NumberFormatException nfe) {
                LOG.warn("fetch: Unable to convert fetched value ({}) to Double for data source {}", (Object)dsValues[dsIndex].trim(), (Object)dsName);
                throw nfe;
            }
        }
        LOG.debug("fetch: fetch successful: {}={}", (Object)dsName, (Object)dsValue);
        return dsValue;
    }

    public Double fetchLastValueInRange(String rrdFile, String ds, int interval, int range) throws NumberFormatException, RrdException {
        long now = System.currentTimeMillis();
        long latestUpdateTime = (now - now % (long)interval) / 1000L;
        long earliestUpdateTime = (now - now % (long)interval - (long)range) / 1000L;
        LOG.debug("fetchInRange: fetching data from {} to {}", (Object)earliestUpdateTime, (Object)latestUpdateTime);
        String fetchCmd = "fetch " + rrdFile + " AVERAGE -s " + earliestUpdateTime + " -e " + latestUpdateTime;
        String[] fetchStrings = Interface.launch(fetchCmd);
        if (fetchStrings == null) {
            LOG.error("fetchInRange: Unexpected error issuing RRD 'fetch' command, no error text available.");
            return null;
        }
        if (fetchStrings[0] != null) {
            LOG.error("fetchInRange: RRD database 'fetch' failed, reason: {}", (Object)fetchStrings[0]);
            return null;
        }
        if (fetchStrings[1] == null || fetchStrings[2] == null) {
            LOG.error("fetchInRange: RRD database 'fetch' failed, no data retrieved.");
            return null;
        }
        int numFetched = fetchStrings.length;
        LOG.debug("fetchInRange: got {} strings from RRD", (Object)numFetched);
        String[] dsNames = fetchStrings[1].split("\\s");
        int dsIndex = 0;
        for (int i = 0; i < dsNames.length; ++i) {
            if (!dsNames[i].equals(ds)) continue;
            dsIndex = i;
        }
        String dsName = dsNames[dsIndex].trim();
        for (int i = fetchStrings.length - 2; i > 1; --i) {
            String[] dsValues = fetchStrings[i].split("\\s");
            if (!dsValues[dsIndex].trim().equalsIgnoreCase("nan")) {
                try {
                    Double dsValue = new Double(dsValues[dsIndex].trim());
                    LOG.debug("fetchInRange: fetch successful: {}= {}", (Object)dsName, (Object)dsValue);
                    return dsValue;
                }
                catch (NumberFormatException nfe) {
                    LOG.warn("fetchInRange: Unable to convert fetched value ({}) to Double for data source {}", (Object)dsValues[dsIndex].trim(), (Object)dsName);
                    throw nfe;
                }
            }
            LOG.debug("fetchInRange: Got a NaN value - continuing back in time");
        }
        return null;
    }

    public InputStream createGraph(String command, File workDir) throws IOException, RrdException {
        byte[] byteArray = this.createGraphAsByteArray(command, workDir);
        return new ByteArrayInputStream(byteArray);
    }

    private byte[] createGraphAsByteArray(String command, File workDir) throws IOException, RrdException {
        Process process;
        String[] commandArray = StringUtils.createCommandArray((String)command, (char)'@');
        try {
            process = Runtime.getRuntime().exec(commandArray, null, workDir);
        }
        catch (IOException e) {
            IOException newE = new IOException("IOException thrown while executing command '" + command + "' in " + workDir.getAbsolutePath() + ": " + e);
            newE.initCause(e);
            throw newE;
        }
        byte[] byteArray = FileCopyUtils.copyToByteArray((InputStream)process.getInputStream());
        String errors = FileCopyUtils.copyToString((Reader)new InputStreamReader(process.getErrorStream()));
        if (errors.length() > 0 && errors.contains(IGNORABLE_LIBART_WARNING_STRING)) {
            LOG.debug("Ignoring libart warning message in rrdtool stderr stream: {}", (Object)IGNORABLE_LIBART_WARNING_STRING);
            errors = errors.replaceAll(IGNORABLE_LIBART_WARNING_REGEX, "");
        }
        if (errors.length() > 0) {
            throw new RrdException(errors);
        }
        return byteArray;
    }

    public String getStats() {
        return "";
    }

    public int getGraphLeftOffset() {
        return 65;
    }

    public int getGraphRightOffset() {
        return -30;
    }

    public int getGraphTopOffsetWithText() {
        return -75;
    }

    public String getDefaultFileExtension() {
        return ".rrd";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RrdGraphDetails createGraphReturnDetails(String command, File workDir) throws IOException, RrdException {
        ByteArrayInputStream pngStream;
        String[] printLines;
        int height;
        int width;
        File pngFile = File.createTempFile("opennms.rrdtool.", ".png");
        command = command.replaceFirst("graph - ", "graph " + pngFile.getAbsolutePath() + " ");
        try {
            InputStream is = this.createGraph(command, workDir);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            try {
                String line = null;
                line = reader.readLine();
                if (line == null) {
                    throw new IOException("No output from the createGraph() command");
                }
                String[] s = line.split("x");
                width = Integer.parseInt(s[0]);
                height = Integer.parseInt(s[1]);
                ArrayList<String> printLinesList = new ArrayList<String>();
                while ((line = reader.readLine()) != null) {
                    printLinesList.add(line);
                }
                printLines = printLinesList.toArray(new String[printLinesList.size()]);
            }
            finally {
                reader.close();
            }
            byte[] byteArray = FileCopyUtils.copyToByteArray((File)pngFile);
            pngStream = new ByteArrayInputStream(byteArray);
        }
        catch (Throwable e) {
            throw new RrdException("Can't execute command " + command, e);
        }
        finally {
            pngFile.delete();
        }
        return new JniGraphDetails(width, height, printLines, pngStream);
    }

    public void promoteEnqueuedFiles(Collection<String> rrdFiles) {
    }

    public static class CreateCommand {
        private static final String OPERATION = "create";
        String filename;
        String parameter;

        public CreateCommand(String filename, String parameter) {
            this.filename = filename;
            this.parameter = parameter;
        }

        public String toString() {
            return "create " + this.filename + " " + this.parameter;
        }
    }
}

