/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd.tcp;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.rrd.tcp.PerformanceDataProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RrdOutputSocket {
    private static final Logger LOG = LoggerFactory.getLogger(RrdOutputSocket.class);
    private final String m_host;
    private final int m_port;
    private final PerformanceDataProtos.PerformanceDataReadings.Builder m_messages;
    private int m_messageCount = 0;

    public RrdOutputSocket(String host, int port) {
        this.m_host = host;
        this.m_port = port;
        this.m_messages = PerformanceDataProtos.PerformanceDataReadings.newBuilder();
    }

    public void addData(String filename, String owner, String data) {
        Long timestamp = this.parseRrdTimestamp(data);
        List<Double> values = this.parseRrdValues(data);
        this.m_messages.addMessage(PerformanceDataProtos.PerformanceDataReading.newBuilder().setPath(filename).setOwner(owner).setTimestamp(timestamp).addAllDblValue(values).addAllStrValue(new ArrayList()));
        ++this.m_messageCount;
    }

    public void addData(String filename, String owner, Long timestampInSec, List<Double> dblValues, List<String> strValues) {
        this.m_messages.addMessage(PerformanceDataProtos.PerformanceDataReading.newBuilder().setPath(filename).setOwner(owner).setTimestamp(timestampInSec * 1000L).addAllDblValue(dblValues).addAllStrValue(strValues));
        ++this.m_messageCount;
    }

    public void writeData() {
        Socket socket = null;
        try {
            socket = new Socket(InetAddressUtils.addr((String)this.m_host), this.m_port);
            OutputStream out = socket.getOutputStream();
            this.m_messages.build().writeTo(out);
            out.flush();
        }
        catch (Throwable e) {
            LOG.warn("Error when trying to open connection to {}:{}, dropping {} performance messages: {}", new Object[]{this.m_host, this.m_port, this.m_messageCount, e.getMessage()});
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    LOG.warn("IOException when closing TCP performance data socket: {}", (Object)e.getMessage());
                }
            }
        }
    }

    private Long parseRrdTimestamp(String data) {
        if (data.startsWith("N:")) {
            return System.currentTimeMillis();
        }
        String timestamp = data.split(":")[0];
        return Long.valueOf(timestamp) * 1000L;
    }

    private List<Double> parseRrdValues(String data) {
        ArrayList<Double> retval = new ArrayList<Double>();
        String[] values = data.split(":");
        for (int i = 1; i < values.length; ++i) {
            if (values[i] == null || "null".equals(values[i])) {
                retval.add(Double.NaN);
                continue;
            }
            if ("U".equals(values[i])) {
                retval.add(Double.NaN);
                continue;
            }
            retval.add(new Double(values[i]));
        }
        return retval;
    }
}

