/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.netmgt.rrd.model.AbstractDS;
import org.opennms.netmgt.rrd.model.AbstractRRA;
import org.opennms.netmgt.rrd.model.LongAdapter;
import org.opennms.netmgt.rrd.model.Row;

public abstract class AbstractRRD {
    private String version;
    private Long step;
    private Long lastupdate;

    protected abstract AbstractRRD createRRD();

    public abstract List<? extends AbstractDS> getDataSources();

    public abstract List<? extends AbstractRRA> getRras();

    public abstract void addRRA(AbstractRRA var1);

    public abstract void addDataSource(AbstractDS var1);

    public abstract AbstractDS getDataSource(int var1);

    @XmlElement(name="version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @XmlElement(name="step")
    @XmlJavaTypeAdapter(value=LongAdapter.class)
    public Long getStep() {
        return this.step;
    }

    public void setStep(Long step) {
        this.step = step;
    }

    @XmlElement(name="lastupdate")
    @XmlJavaTypeAdapter(value=LongAdapter.class)
    public Long getLastUpdate() {
        return this.lastupdate;
    }

    public void setLastUpdate(Long lastUpdate) {
        this.lastupdate = lastUpdate;
    }

    public Long getStartTimestamp(AbstractRRA rra) {
        if (this.getLastUpdate() == null || this.getStep() == null || rra == null) {
            return null;
        }
        return this.getEndTimestamp(rra) - this.getStep() * rra.getPdpPerRow() * (long)rra.getRows().size();
    }

    public Long getEndTimestamp(AbstractRRA rra) {
        if (this.getLastUpdate() == null || this.getStep() == null || rra == null) {
            return null;
        }
        return this.getLastUpdate() - this.getLastUpdate() % (this.getStep() * rra.getPdpPerRow()) + this.getStep() * rra.getPdpPerRow();
    }

    public Long findTimestampByRow(AbstractRRA rra, Row row) {
        int rowNumber = rra.getRows().indexOf(row);
        if (rowNumber < 0) {
            return null;
        }
        return this.getStartTimestamp(rra) + (long)rowNumber * rra.getPdpPerRow() * this.getStep();
    }

    public Row findRowByTimestamp(AbstractRRA rra, Long timestamp) {
        try {
            Long n = (timestamp - this.getStartTimestamp(rra)) / (rra.getPdpPerRow() * this.getStep());
            return rra.getRows().get(n.intValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    public void merge(AbstractRRD rrdSrc) throws IllegalArgumentException {
        if (!this.formatEquals(rrdSrc)) {
            throw new IllegalArgumentException("Invalid RRD format");
        }
        int rraNum = 0;
        for (AbstractRRA abstractRRA : rrdSrc.getRras()) {
            for (Row row : abstractRRA.getRows()) {
                if (row.isNan()) continue;
                Long ts = rrdSrc.findTimestampByRow(abstractRRA, row);
                Row localRow = this.findRowByTimestamp(this.getRras().get(rraNum), ts);
                if (localRow == null) continue;
                localRow.setValues(row.getValues());
            }
            ++rraNum;
        }
    }

    public void merge(List<? extends AbstractRRD> rrdList) throws IllegalArgumentException {
        if (rrdList.size() != this.getDataSources().size()) {
            throw new IllegalArgumentException("Cannot merge RRDs because the amount of RRDs doesn't match the amount of data sources.");
        }
        for (AbstractRRD abstractRRD : rrdList) {
            if (!this.getVersion().equals(this.getVersion())) {
                throw new IllegalArgumentException("Cannot merge RRDs because one of them have a different file version.");
            }
            if (!this.hasEqualsRras(abstractRRD)) {
                throw new IllegalArgumentException("Cannot merge RRDs because one of them as different RRA configuration.");
            }
            if (abstractRRD.getDataSources().size() <= 1) continue;
            throw new IllegalArgumentException("Cannot merge RRDs because one of them has more than one DS.");
        }
        Collections.sort(rrdList, new Comparator<AbstractRRD>(){

            @Override
            public int compare(AbstractRRD a, AbstractRRD b) {
                int aInt = AbstractRRD.this.getIndex(a.getDataSources().get(0).getName());
                int bInt = AbstractRRD.this.getIndex(b.getDataSources().get(0).getName());
                return aInt - bInt;
            }
        });
        for (int i = 0; i < this.getRras().size(); ++i) {
            AbstractRRA abstractRRA = this.getRras().get(i);
            for (int j = 0; j < abstractRRA.getRows().size(); ++j) {
                Row row = abstractRRA.getRows().get(j);
                for (int k = 0; k < row.getValues().size(); ++k) {
                    Double v = rrdList.get(k).getRras().get(i).getRows().get(j).getValues().get(0);
                    if (v.isNaN()) continue;
                    row.getValues().set(k, v);
                }
            }
        }
    }

    public List<AbstractRRD> split() throws IllegalArgumentException {
        if (this.getDataSources().size() <= 1) {
            throw new IllegalArgumentException("Cannot split an RRD composed by 1 or less data-sources.");
        }
        ArrayList<AbstractRRD> rrds = new ArrayList<AbstractRRD>();
        for (int i = 0; i < this.getDataSources().size(); ++i) {
            AbstractRRD rrd = this.createRRD();
            rrd.addDataSource(this.getDataSource(i));
            for (int j = 0; j < this.getRras().size(); ++j) {
                AbstractRRA currentRra = this.getRras().get(j);
                AbstractRRA rra = currentRra.createSingleRRA(i);
                for (Row currentRow : currentRra.getRows()) {
                    Row row = new Row();
                    row.getValues().add(currentRow.getValues().get(i));
                    rra.getRows().add(row);
                }
                rrd.addRRA(rra);
            }
            rrds.add(rrd);
        }
        return rrds;
    }

    public boolean formatEquals(AbstractRRD rrd) {
        if (this.step != null) {
            if (rrd.step == null) {
                return false;
            }
            if (!this.step.equals(rrd.step)) {
                return false;
            }
        } else if (rrd.step != null) {
            return false;
        }
        if (this.getDataSources() != null) {
            if (rrd.getDataSources() == null) {
                return false;
            }
            if (this.getDataSources().size() != rrd.getDataSources().size()) {
                return false;
            }
        } else if (rrd.getDataSources() != null) {
            return false;
        }
        for (int i = 0; i < this.getDataSources().size(); ++i) {
            if (this.getDataSources().get(i).formatEquals(rrd.getDataSources().get(i))) continue;
            return false;
        }
        return this.hasEqualsRras(rrd);
    }

    public boolean hasEqualsRras(AbstractRRD rrd) {
        if (this.getRras() != null) {
            if (rrd.getRras() == null) {
                return false;
            }
            if (this.getRras().size() != rrd.getRras().size()) {
                return false;
            }
        } else if (rrd.getRras() != null) {
            return false;
        }
        for (int i = 0; i < this.getRras().size(); ++i) {
            if (this.getRras().get(i).formatEquals(rrd.getRras().get(i))) continue;
            return false;
        }
        return true;
    }

    protected int getIndex(String dsName) {
        if (this.getDataSources() == null) {
            return -1;
        }
        for (int i = 0; i < this.getDataSources().size(); ++i) {
            if (!this.getDataSources().get(i).getName().equals(dsName)) continue;
            return i;
        }
        return -1;
    }
}

