/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd.model.v3;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.netmgt.rrd.model.AbstractRRA;
import org.opennms.netmgt.rrd.model.v3.CFType;
import org.opennms.netmgt.rrd.model.v3.CFTypeAdapter;
import org.opennms.netmgt.rrd.model.v3.Parameters;
import org.opennms.netmgt.rrd.model.v3.RRADS;

@XmlRootElement(name="rra")
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class RRA
extends AbstractRRA {
    private CFType consolidationFunction;
    private Parameters parameters = new Parameters();
    private List<RRADS> dataSources = new ArrayList<RRADS>();

    @XmlElement(name="cf")
    @XmlJavaTypeAdapter(value=CFTypeAdapter.class)
    public CFType getConsolidationFunction() {
        return this.consolidationFunction;
    }

    public void setConsolidationFunction(CFType consolidationFunction) {
        this.consolidationFunction = consolidationFunction;
    }

    public void setConsolidationFunction(String consolidationFunction) {
        this.consolidationFunction = CFType.fromValue(consolidationFunction);
    }

    @XmlElement(name="params")
    public Parameters getParameters() {
        return this.parameters;
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    @XmlElement(name="ds")
    @XmlElementWrapper(name="cdp_prep")
    public List<RRADS> getDataSources() {
        return this.dataSources;
    }

    public void setDataSources(List<RRADS> dataSources) {
        this.dataSources = dataSources;
    }

    public boolean formatEquals(RRA rra) {
        if (this.consolidationFunction != null) {
            if (rra.consolidationFunction == null) {
                return false;
            }
            if (!this.consolidationFunction.equals((Object)rra.consolidationFunction)) {
                return false;
            }
        } else if (rra.consolidationFunction != null) {
            return false;
        }
        return super.formatEquals(rra);
    }

    @Override
    protected AbstractRRA createSingleRRA(int dsIndex) throws IllegalArgumentException {
        RRA clone = new RRA();
        clone.setConsolidationFunction(this.getConsolidationFunction());
        clone.setPdpPerRow(this.getPdpPerRow());
        clone.getDataSources().add(this.getDataSources().get(dsIndex));
        clone.setParameters(this.getParameters());
        return clone;
    }
}

