/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd.model.v1;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.netmgt.rrd.model.AbstractRRA;
import org.opennms.netmgt.rrd.model.DoubleAdapter;
import org.opennms.netmgt.rrd.model.v1.CFType;
import org.opennms.netmgt.rrd.model.v1.CFTypeAdapter;
import org.opennms.netmgt.rrd.model.v1.RRADS;

@XmlRootElement(name="rra")
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class RRA
extends AbstractRRA {
    private CFType consolidationFunction;
    private List<RRADS> dataSources = new ArrayList<RRADS>();
    private Double xff = 0.5;

    @XmlElement(name="cf")
    @XmlJavaTypeAdapter(value=CFTypeAdapter.class)
    public CFType getConsolidationFunction() {
        return this.consolidationFunction;
    }

    public void setConsolidationFunction(CFType consolidationFunction) {
        this.consolidationFunction = consolidationFunction;
    }

    public void setConsolidationFunction(String consolidationFunction) {
        this.consolidationFunction = CFType.fromValue(consolidationFunction);
    }

    @XmlElement(name="ds")
    @XmlElementWrapper(name="cdp_prep")
    public List<RRADS> getDataSources() {
        return this.dataSources;
    }

    public void setDataSources(List<RRADS> dataSources) {
        this.dataSources = dataSources;
    }

    @XmlElement(name="xff")
    @XmlJavaTypeAdapter(value=DoubleAdapter.class)
    public Double getXff() {
        return this.xff;
    }

    public void setXff(Double xff) {
        this.xff = xff;
    }

    public boolean formatEquals(RRA rra) {
        if (this.consolidationFunction != null) {
            if (rra.consolidationFunction == null) {
                return false;
            }
            if (!this.consolidationFunction.equals((Object)rra.consolidationFunction)) {
                return false;
            }
        } else if (rra.consolidationFunction != null) {
            return false;
        }
        if (this.xff != null) {
            if (rra.xff == null) {
                return false;
            }
            if (!this.xff.equals(rra.xff)) {
                return false;
            }
        } else if (rra.xff != null) {
            return false;
        }
        return super.formatEquals(rra);
    }

    @Override
    protected AbstractRRA createSingleRRA(int dsIndex) throws IllegalArgumentException {
        RRA clone = new RRA();
        clone.setConsolidationFunction(this.getConsolidationFunction());
        clone.setPdpPerRow(this.getPdpPerRow());
        clone.getDataSources().add(this.getDataSources().get(dsIndex));
        clone.setXff(this.getXff());
        return clone;
    }
}

