/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd.jrobin;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jrobin.core.FetchData;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.Sample;
import org.jrobin.data.DataProcessor;
import org.jrobin.data.Plottable;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdGraphDetails;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.rrd.jrobin.JRobinRrdGraphDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JRobinRrdStrategy
implements RrdStrategy<RrdDef, RrdDb> {
    private static final Logger LOG = LoggerFactory.getLogger(JRobinRrdStrategy.class);
    private static final String BACKEND_FACTORY_PROPERTY = "org.jrobin.core.RrdBackendFactory";
    private static final String DEFAULT_BACKEND_FACTORY = "FILE";
    private static boolean s_initialized = false;
    private Properties m_configurationProperties;

    public Properties getConfigurationProperties() {
        return this.m_configurationProperties;
    }

    public void setConfigurationProperties(Properties configurationParameters) {
        this.m_configurationProperties = configurationParameters;
        if (!s_initialized) {
            String factory = null;
            factory = this.m_configurationProperties == null ? DEFAULT_BACKEND_FACTORY : (String)this.m_configurationProperties.get(BACKEND_FACTORY_PROPERTY);
            try {
                RrdDb.setDefaultFactory((String)factory);
                s_initialized = true;
            }
            catch (org.jrobin.core.RrdException e) {
                LOG.error("Could not set default JRobin RRD factory", (Throwable)e);
            }
        }
    }

    public void closeFile(RrdDb rrdFile) throws Exception {
        rrdFile.close();
    }

    public RrdDef createDefinition(String creator, String directory, String rrdName, int step, List<RrdDataSource> dataSources, List<String> rraList) throws Exception {
        File f = new File(directory);
        f.mkdirs();
        String fileName = directory + File.separator + rrdName + RrdUtils.getExtension();
        if (new File(fileName).exists()) {
            LOG.debug("createDefinition: filename [{}] already exists returning null as definition", (Object)fileName);
            return null;
        }
        RrdDef def = new RrdDef(fileName);
        def.setStartTime(1000L);
        def.setStep((long)step);
        for (RrdDataSource dataSource : dataSources) {
            String dsMin = dataSource.getMin();
            String dsMax = dataSource.getMax();
            double min = dsMin == null || "U".equals(dsMin) ? Double.NaN : Double.parseDouble(dsMin);
            double max = dsMax == null || "U".equals(dsMax) ? Double.NaN : Double.parseDouble(dsMax);
            def.addDatasource(dataSource.getName(), dataSource.getType(), (long)dataSource.getHeartBeat(), min, max);
        }
        for (String rra : rraList) {
            def.addArchive(rra);
        }
        return def;
    }

    public void createFile(RrdDef rrdDef, Map<String, String> attributeMappings) throws Exception {
        if (rrdDef == null) {
            LOG.debug("createRRD: skipping RRD file");
            return;
        }
        LOG.info("createRRD: creating RRD file {}", (Object)rrdDef.getPath());
        RrdDb rrd = new RrdDb(rrdDef);
        rrd.close();
        String filenameWithoutExtension = rrdDef.getPath().replace(RrdUtils.getExtension(), "");
        int lastIndexOfSeparator = filenameWithoutExtension.lastIndexOf(File.separator);
        RrdUtils.createMetaDataFile((String)filenameWithoutExtension.substring(0, lastIndexOfSeparator), (String)filenameWithoutExtension.substring(lastIndexOfSeparator), attributeMappings);
    }

    public RrdDb openFile(String fileName) throws Exception {
        return new RrdDb(fileName);
    }

    public void updateFile(RrdDb rrdFile, String owner, String data) throws Exception {
        Sample sample = rrdFile.createSample();
        sample.setAndUpdate(data);
    }

    public JRobinRrdStrategy() throws Exception {
        String home = System.getProperty("opennms.home");
        System.setProperty("jrobin.fontdir", home + File.separator + "etc");
    }

    public Double fetchLastValue(String fileName, String ds, int interval) throws NumberFormatException, RrdException {
        return this.fetchLastValue(fileName, ds, "AVERAGE", interval);
    }

    public Double fetchLastValue(String fileName, String ds, String consolidationFunction, int interval) throws RrdException {
        RrdDb rrd = null;
        try {
            long now = System.currentTimeMillis();
            long collectTime = (now - now % (long)interval) / 1000L;
            rrd = new RrdDb(fileName, true);
            FetchData data = rrd.createFetchRequest(consolidationFunction, collectTime, collectTime).fetchData();
            LOG.debug(data.toString());
            double[] vals = data.getValues(ds);
            if (vals.length > 0) {
                Double d = new Double(vals[vals.length - 1]);
                return d;
            }
            Double d = null;
            return d;
        }
        catch (IOException e) {
            throw new RrdException("Exception occurred fetching data from " + fileName, (Throwable)e);
        }
        catch (org.jrobin.core.RrdException e) {
            throw new RrdException("Exception occurred fetching data from " + fileName, (Throwable)e);
        }
        finally {
            if (rrd != null) {
                try {
                    rrd.close();
                }
                catch (IOException e) {
                    LOG.error("Failed to close rrd file: {}", (Object)fileName, (Object)e);
                }
            }
        }
    }

    public Double fetchLastValueInRange(String fileName, String ds, int interval, int range) throws NumberFormatException, RrdException {
        RrdDb rrd = null;
        try {
            rrd = new RrdDb(fileName, true);
            long now = System.currentTimeMillis();
            long latestUpdateTime = (now - now % (long)interval) / 1000L;
            long earliestUpdateTime = (now - now % (long)interval - (long)range) / 1000L;
            LOG.debug("fetchInRange: fetching data from {} to {}", (Object)earliestUpdateTime, (Object)latestUpdateTime);
            FetchData data = rrd.createFetchRequest("AVERAGE", earliestUpdateTime, latestUpdateTime).fetchData();
            double[] vals = data.getValues(ds);
            long[] times = data.getTimestamps();
            for (int i = vals.length - 1; i >= 0; --i) {
                if (!Double.isNaN(vals[i])) {
                    LOG.debug("Got a non NaN value at interval: {} : {}", (Object)times[i], (Object)vals[i]);
                    Double d = new Double(vals[i]);
                    return d;
                }
                LOG.debug("fetchInRange: Got a NaN value at interval: {} continuing back in time", (Object)times[i]);
            }
            Double d = null;
            return d;
        }
        catch (IOException e) {
            throw new RrdException("Exception occurred fetching data from " + fileName, (Throwable)e);
        }
        catch (org.jrobin.core.RrdException e) {
            throw new RrdException("Exception occurred fetching data from " + fileName, (Throwable)e);
        }
        finally {
            if (rrd != null) {
                try {
                    rrd.close();
                }
                catch (IOException e) {
                    LOG.error("Failed to close rrd file: {}", (Object)fileName, (Object)e);
                }
            }
        }
    }

    private Color getColor(String colorValue) {
        int rVal = Integer.parseInt(colorValue.substring(0, 2), 16);
        int gVal = Integer.parseInt(colorValue.substring(2, 4), 16);
        int bVal = Integer.parseInt(colorValue.substring(4, 6), 16);
        if (colorValue.length() == 6) {
            return new Color(rVal, gVal, bVal);
        }
        int aVal = Integer.parseInt(colorValue.substring(6, 8), 16);
        return new Color(rVal, gVal, bVal, aVal);
    }

    private Color getColorOrInvisible(String[] array, int index) {
        if (array.length > index) {
            return this.getColor(array[index]);
        }
        return new Color(1.0f, 1.0f, 1.0f, 0.0f);
    }

    public InputStream createGraph(String command, File workDir) throws IOException, RrdException {
        return this.createGraphReturnDetails(command, workDir).getInputStream();
    }

    public RrdGraphDetails createGraphReturnDetails(String command, File workDir) throws IOException, RrdException {
        try {
            String[] commandArray = this.tokenize(command, " \t", false);
            RrdGraphDef graphDef = this.createGraphDef(workDir, commandArray);
            graphDef.setSignature("OpenNMS/JRobin");
            RrdGraph graph = new RrdGraph(graphDef);
            return new JRobinRrdGraphDetails(graph, command);
        }
        catch (Throwable e) {
            LOG.error("JRobin: exception occurred creating graph", e);
            throw new RrdException("An exception occurred creating the graph: " + e.getMessage(), e);
        }
    }

    public void promoteEnqueuedFiles(Collection<String> rrdFiles) {
    }

    protected RrdGraphDef createGraphDef(File workDir, String[] inputArray) throws org.jrobin.core.RrdException {
        RrdGraphDef graphDef = new RrdGraphDef();
        graphDef.setImageFormat("PNG");
        long start = 0L;
        long end = 0L;
        int height = 100;
        int width = 400;
        double lowerLimit = Double.NaN;
        double upperLimit = Double.NaN;
        boolean rigid = false;
        LinkedHashMap<String, List<String>> defs = new LinkedHashMap<String, List<String>>();
        Object[] commandArray = inputArray[0].contains("rrdtool") && inputArray[1].equals("graph") && inputArray[2].equals("-") ? Arrays.copyOfRange(inputArray, 3, inputArray.length) : inputArray;
        LOG.debug("command array = {}", (Object)Arrays.toString(commandArray));
        for (int i = 0; i < commandArray.length; ++i) {
            String format;
            String[] color;
            Object arg = commandArray[i];
            if (((String)arg).startsWith("--start=")) {
                start = Long.parseLong(((String)arg).substring("--start=".length()));
                LOG.debug("JRobin start time: {}", (Object)start);
                continue;
            }
            if (((String)arg).equals("--start")) {
                if (i + 1 < commandArray.length) {
                    start = Long.parseLong((String)commandArray[++i]);
                    LOG.debug("JRobin start time: {}", (Object)start);
                    continue;
                }
                throw new IllegalArgumentException("--start must be followed by a start time");
            }
            if (((String)arg).startsWith("--end=")) {
                end = Long.parseLong(((String)arg).substring("--end=".length()));
                LOG.debug("JRobin end time: {}", (Object)end);
                continue;
            }
            if (((String)arg).equals("--end")) {
                if (i + 1 < commandArray.length) {
                    end = Long.parseLong((String)commandArray[++i]);
                    LOG.debug("JRobin end time: {}", (Object)end);
                    continue;
                }
                throw new IllegalArgumentException("--end must be followed by an end time");
            }
            if (((String)arg).startsWith("--title=")) {
                String[] title = this.tokenize((String)arg, "=", true);
                graphDef.setTitle(title[1]);
                continue;
            }
            if (((String)arg).equals("--title")) {
                if (i + 1 < commandArray.length) {
                    graphDef.setTitle((String)commandArray[++i]);
                    continue;
                }
                throw new IllegalArgumentException("--title must be followed by a title");
            }
            if (((String)arg).startsWith("--color=")) {
                String[] color2 = this.tokenize((String)arg, "=", true);
                this.parseGraphColor(graphDef, color2[1]);
                continue;
            }
            if (((String)arg).equals("--color") || ((String)arg).equals("-c")) {
                if (i + 1 < commandArray.length) {
                    this.parseGraphColor(graphDef, (String)commandArray[++i]);
                    continue;
                }
                throw new IllegalArgumentException("--color must be followed by a color");
            }
            if (((String)arg).startsWith("--vertical-label=")) {
                String[] label = this.tokenize((String)arg, "=", true);
                graphDef.setVerticalLabel(label[1]);
                continue;
            }
            if (((String)arg).equals("--vertical-label")) {
                if (i + 1 < commandArray.length) {
                    graphDef.setVerticalLabel((String)commandArray[++i]);
                    continue;
                }
                throw new IllegalArgumentException("--vertical-label must be followed by a label");
            }
            if (((String)arg).startsWith("--height=")) {
                String[] argParm = this.tokenize((String)arg, "=", true);
                height = Integer.parseInt(argParm[1]);
                LOG.debug("JRobin height: {}", (Object)height);
                continue;
            }
            if (((String)arg).equals("--height")) {
                if (i + 1 < commandArray.length) {
                    height = Integer.parseInt((String)commandArray[++i]);
                    LOG.debug("JRobin height: {}", (Object)height);
                    continue;
                }
                throw new IllegalArgumentException("--height must be followed by a number");
            }
            if (((String)arg).startsWith("--width=")) {
                String[] argParm = this.tokenize((String)arg, "=", true);
                width = Integer.parseInt(argParm[1]);
                LOG.debug("JRobin width: {}", (Object)width);
                continue;
            }
            if (((String)arg).equals("--width")) {
                if (i + 1 < commandArray.length) {
                    width = Integer.parseInt((String)commandArray[++i]);
                    LOG.debug("JRobin width: {}", (Object)width);
                    continue;
                }
                throw new IllegalArgumentException("--width must be followed by a number");
            }
            if (((String)arg).startsWith("--units-exponent=")) {
                String[] argParm = this.tokenize((String)arg, "=", true);
                int exponent = Integer.parseInt(argParm[1]);
                LOG.debug("JRobin units exponent: {}", (Object)exponent);
                graphDef.setUnitsExponent(exponent);
                continue;
            }
            if (((String)arg).equals("--units-exponent")) {
                if (i + 1 < commandArray.length) {
                    int exponent = Integer.parseInt((String)commandArray[++i]);
                    LOG.debug("JRobin units exponent: {}", (Object)exponent);
                    graphDef.setUnitsExponent(exponent);
                    continue;
                }
                throw new IllegalArgumentException("--units-exponent must be followed by a number");
            }
            if (((String)arg).startsWith("--lower-limit=")) {
                String[] argParm = this.tokenize((String)arg, "=", true);
                lowerLimit = Double.parseDouble(argParm[1]);
                LOG.debug("JRobin lower limit: {}", (Object)lowerLimit);
                continue;
            }
            if (((String)arg).equals("--lower-limit")) {
                if (i + 1 < commandArray.length) {
                    lowerLimit = Double.parseDouble((String)commandArray[++i]);
                    LOG.debug("JRobin lower limit: {}", (Object)lowerLimit);
                    continue;
                }
                throw new IllegalArgumentException("--lower-limit must be followed by a number");
            }
            if (((String)arg).startsWith("--upper-limit=")) {
                String[] argParm = this.tokenize((String)arg, "=", true);
                upperLimit = Double.parseDouble(argParm[1]);
                LOG.debug("JRobin upper limit: {}", (Object)upperLimit);
                continue;
            }
            if (((String)arg).equals("--upper-limit")) {
                if (i + 1 < commandArray.length) {
                    upperLimit = Double.parseDouble((String)commandArray[++i]);
                    LOG.debug("JRobin upper limit: {}", (Object)upperLimit);
                    continue;
                }
                throw new IllegalArgumentException("--upper-limit must be followed by a number");
            }
            if (((String)arg).startsWith("--base=")) {
                String[] argParm = this.tokenize((String)arg, "=", true);
                graphDef.setBase(Double.parseDouble(argParm[1]));
                continue;
            }
            if (((String)arg).equals("--base")) {
                if (i + 1 < commandArray.length) {
                    graphDef.setBase(Double.parseDouble((String)commandArray[++i]));
                    continue;
                }
                throw new IllegalArgumentException("--base must be followed by a number");
            }
            if (((String)arg).startsWith("--font=")) {
                String[] argParm = this.tokenize((String)arg, "=", true);
                this.processRrdFontArgument(graphDef, argParm[1]);
                continue;
            }
            if (((String)arg).equals("--font")) {
                if (i + 1 < commandArray.length) {
                    this.processRrdFontArgument(graphDef, (String)commandArray[++i]);
                    continue;
                }
                throw new IllegalArgumentException("--font must be followed by an argument");
            }
            if (((String)arg).startsWith("--imgformat=")) {
                String[] argParm = this.tokenize((String)arg, "=", true);
                graphDef.setImageFormat(argParm[1]);
                continue;
            }
            if (((String)arg).equals("--imgformat")) {
                if (i + 1 < commandArray.length) {
                    graphDef.setImageFormat((String)commandArray[++i]);
                    continue;
                }
                throw new IllegalArgumentException("--imgformat must be followed by an argument");
            }
            if (((String)arg).equals("--rigid")) {
                rigid = true;
                continue;
            }
            if (((String)arg).startsWith("DEF:")) {
                String definition = ((String)arg).substring("DEF:".length());
                String[] def = this.splitDef(definition);
                String[] ds = def[0].split("=");
                String replaced = ds[1].replaceAll("\\\\(.)", "$1");
                File rawPathFile = new File(replaced);
                File dsFile = rawPathFile.isAbsolute() ? rawPathFile : new File(workDir, replaced);
                String absolutePath = File.separatorChar == '\\' ? dsFile.getAbsolutePath().replace("\\", "\\\\") : dsFile.getAbsolutePath();
                graphDef.datasource(ds[0], absolutePath, def[1], def[2]);
                ArrayList<String> defBits = new ArrayList<String>();
                defBits.add(absolutePath);
                defBits.add(def[1]);
                defBits.add(def[2]);
                defs.put(ds[0], defBits);
                continue;
            }
            if (((String)arg).startsWith("CDEF:")) {
                String definition = ((String)arg).substring("CDEF:".length());
                String[] cdef = this.tokenize(definition, "=", true);
                graphDef.datasource(cdef[0], cdef[1]);
                ArrayList<String> cdefBits = new ArrayList<String>();
                cdefBits.add(cdef[1]);
                defs.put(cdef[0], cdefBits);
                continue;
            }
            if (((String)arg).startsWith("VDEF:")) {
                String definition = ((String)arg).substring("VDEF:".length());
                String[] vdef = this.tokenize(definition, "=", true);
                String[] expressionTokens = this.tokenize(vdef[1], ",", false);
                this.addVdefDs(graphDef, vdef[0], expressionTokens, start, end, defs);
                continue;
            }
            if (((String)arg).startsWith("LINE1:")) {
                String definition = ((String)arg).substring("LINE1:".length());
                String[] line1 = this.tokenize(definition, ":", true);
                color = this.tokenize(line1[0], "#", true);
                graphDef.line(color[0], (Paint)this.getColorOrInvisible(color, 1), line1.length > 1 ? line1[1] : "");
                continue;
            }
            if (((String)arg).startsWith("LINE2:")) {
                String definition = ((String)arg).substring("LINE2:".length());
                String[] line2 = this.tokenize(definition, ":", true);
                color = this.tokenize(line2[0], "#", true);
                graphDef.line(color[0], (Paint)this.getColorOrInvisible(color, 1), line2.length > 1 ? line2[1] : "", 2.0f);
                continue;
            }
            if (((String)arg).startsWith("LINE3:")) {
                String definition = ((String)arg).substring("LINE3:".length());
                String[] line3 = this.tokenize(definition, ":", true);
                color = this.tokenize(line3[0], "#", true);
                graphDef.line(color[0], (Paint)this.getColorOrInvisible(color, 1), line3.length > 1 ? line3[1] : "", 3.0f);
                continue;
            }
            if (((String)arg).startsWith("GPRINT:")) {
                String definition = ((String)arg).substring("GPRINT:".length());
                String[] gprint = this.tokenize(definition, ":", true);
                format = gprint[2];
                format = format.replaceAll("\\n", "\\\\l");
                graphDef.gprint(gprint[0], gprint[1], format);
                continue;
            }
            if (((String)arg).startsWith("PRINT:")) {
                String definition = ((String)arg).substring("PRINT:".length());
                String[] print = this.tokenize(definition, ":", true);
                format = print[2];
                format = format.replaceAll("\\n", "\\\\l");
                graphDef.print(print[0], print[1], format);
                continue;
            }
            if (((String)arg).startsWith("COMMENT:")) {
                String[] comments = this.tokenize((String)arg, ":", true);
                String format2 = comments[1].replaceAll("\\n", "\\\\l");
                graphDef.comment(format2);
                continue;
            }
            if (((String)arg).startsWith("AREA:")) {
                String definition = ((String)arg).substring("AREA:".length());
                String[] area = this.tokenize(definition, ":", true);
                color = this.tokenize(area[0], "#", true);
                if (area.length > 1) {
                    graphDef.area(color[0], (Paint)this.getColorOrInvisible(color, 1), area[1]);
                    continue;
                }
                graphDef.area(color[0], (Paint)this.getColorOrInvisible(color, 1));
                continue;
            }
            if (((String)arg).startsWith("STACK:")) {
                String definition = ((String)arg).substring("STACK:".length());
                String[] stack = this.tokenize(definition, ":", true);
                color = this.tokenize(stack[0], "#", true);
                graphDef.stack(color[0], (Paint)this.getColor(color[1]), stack.length > 1 ? stack[1] : "");
                continue;
            }
            if (((String)arg).startsWith("HRULE:")) {
                String definition = ((String)arg).substring("HRULE:".length());
                String[] hrule = this.tokenize(definition, ":", true);
                color = this.tokenize(hrule[0], "#", true);
                Double value = Double.valueOf(color[0]);
                graphDef.hrule(value.doubleValue(), (Paint)this.getColor(color[1]), hrule.length > 1 ? hrule[1] : "");
                continue;
            }
            if (((String)arg).endsWith("/rrdtool") || ((String)arg).equals("graph") || ((String)arg).equals("-") || ((String)arg).trim().isEmpty()) continue;
            LOG.warn("JRobin: Unrecognized graph argument: {}", arg);
        }
        graphDef.setTimeSpan(start, end);
        graphDef.setMinValue(lowerLimit);
        graphDef.setMaxValue(upperLimit);
        graphDef.setRigid(rigid);
        graphDef.setHeight(height);
        graphDef.setWidth(width);
        LOG.debug("JRobin Finished tokenizing checking: start time: {}, end time: {}", (Object)start, (Object)end);
        LOG.debug("large font = {}, small font = {}", (Object)graphDef.getLargeFont(), (Object)graphDef.getSmallFont());
        return graphDef;
    }

    private String[] splitDef(String definition) {
        String[] def;
        if (File.separatorChar == '\\') {
            if (definition.matches("[^=]*=[a-zA-Z]:.*")) {
                String[] tempDef = definition.split("(?<!\\\\):");
                def = new String[tempDef.length - 1];
                def[0] = tempDef[0] + ':' + tempDef[1];
                if (tempDef.length > 2) {
                    for (int i = 2; i < tempDef.length; ++i) {
                        def[i - 1] = tempDef[i];
                    }
                }
            } else {
                def = definition.split("(?<!\\\\):");
            }
        } else {
            def = definition.split("(?<!\\\\):");
        }
        return def;
    }

    private void processRrdFontArgument(RrdGraphDef graphDef, String argParm) {
        int fontTag;
        String[] argValue = this.tokenize(argParm, ":", false);
        if (argValue.length < 2) {
            LOG.warn("Argument '{}' does not specify font size", (Object)argParm);
            return;
        }
        if (argValue.length > 3) {
            LOG.debug("Argument '{}' includes extra data, ignoring the extra data.", (Object)argParm);
        }
        float newPointSize = 0.0f;
        try {
            newPointSize = (float)Integer.parseInt(argValue[1]) * 1.5f;
        }
        catch (NumberFormatException e) {
            LOG.warn("Failed to parse {} as an integer: {}", new Object[]{argValue[1], e.getMessage(), e});
        }
        if (argValue[0].equals("DEFAULT")) {
            fontTag = 0;
        } else if (argValue[0].equals("TITLE")) {
            fontTag = 1;
        } else if (argValue[0].equals("AXIS")) {
            fontTag = 2;
        } else if (argValue[0].equals("UNIT")) {
            fontTag = 3;
        } else if (argValue[0].equals("LEGEND")) {
            fontTag = 4;
        } else if (argValue[0].equals("WATERMARK")) {
            fontTag = 5;
        } else {
            LOG.warn("invalid font tag {}", (Object)argValue[0]);
            return;
        }
        try {
            Font font = graphDef.getFont(fontTag);
            if (argValue.length == 3 && argValue[2] != null && argValue[2].length() > 0) {
                float origPointSize = font.getSize2D();
                font = Font.decode(argValue[2]);
                font = newPointSize > 0.0f ? font.deriveFont(newPointSize) : font.deriveFont(origPointSize);
            } else {
                font = font.deriveFont(newPointSize);
            }
            if (fontTag == 0) {
                graphDef.setFont(fontTag, font, true, newPointSize == 0.0f);
            } else {
                graphDef.setFont(fontTag, font);
            }
        }
        catch (Throwable e) {
            LOG.warn("unable to create font from font argument {}", (Object)argParm, (Object)e);
        }
    }

    private String[] tokenize(String line, String delimiters, boolean processQuotes) {
        String passthroughTokens = "lcrjgsJ";
        return JRobinRrdStrategy.tokenizeWithQuotingAndEscapes(line, delimiters, processQuotes, passthroughTokens);
    }

    private void parseGraphColor(RrdGraphDef graphDef, String colorArg) throws IllegalArgumentException {
        block13: {
            String[] colorArgParts = this.tokenize(colorArg, "#", false);
            if (colorArgParts.length != 2) {
                throw new IllegalArgumentException("--color must be followed by value with format COLORTAG#RRGGBB[AA]");
            }
            String colorTag = colorArgParts[0].toUpperCase();
            String colorHex = colorArgParts[1].toUpperCase();
            if (colorHex.length() != 6 && colorHex.length() != 8) {
                throw new IllegalArgumentException("--color must be followed by value with format COLORTAG#RRGGBB[AA]");
            }
            Color color = this.getColor(colorHex);
            try {
                if (colorTag.equals("BACK")) {
                    graphDef.setColor("BACK", (Paint)color);
                    break block13;
                }
                if (colorTag.equals("CANVAS")) {
                    graphDef.setColor("CANVAS", (Paint)color);
                    break block13;
                }
                if (colorTag.equals("SHADEA")) {
                    graphDef.setColor("SHADEA", (Paint)color);
                    break block13;
                }
                if (colorTag.equals("SHADEB")) {
                    graphDef.setColor("SHADEB", (Paint)color);
                    break block13;
                }
                if (colorTag.equals("GRID")) {
                    graphDef.setColor("GRID", (Paint)color);
                    break block13;
                }
                if (colorTag.equals("MGRID")) {
                    graphDef.setColor("MGRID", (Paint)color);
                    break block13;
                }
                if (colorTag.equals("FONT")) {
                    graphDef.setColor("FONT", (Paint)color);
                    break block13;
                }
                if (colorTag.equals("FRAME")) {
                    graphDef.setColor("FRAME", (Paint)color);
                    break block13;
                }
                if (colorTag.equals("ARROW")) {
                    graphDef.setColor("ARROW", (Paint)color);
                    break block13;
                }
                throw new org.jrobin.core.RrdException("Unknown color tag " + colorTag);
            }
            catch (Throwable e) {
                LOG.error("JRobin: exception occurred creating graph", e);
            }
        }
    }

    public String getStats() {
        return "";
    }

    public int getGraphLeftOffset() {
        return 74;
    }

    public int getGraphRightOffset() {
        return -15;
    }

    public int getGraphTopOffsetWithText() {
        return -61;
    }

    public String getDefaultFileExtension() {
        return ".jrb";
    }

    public static String[] tokenizeWithQuotingAndEscapes(String line, String delims, boolean processQuoted) {
        return JRobinRrdStrategy.tokenizeWithQuotingAndEscapes(line, delims, processQuoted, "");
    }

    public static String[] tokenizeWithQuotingAndEscapes(String line, String delims, boolean processQuoted, String tokens) {
        LinkedList<String> tokenList = new LinkedList<String>();
        StringBuffer currToken = new StringBuffer();
        boolean quoting = false;
        boolean escaping = false;
        boolean debugTokens = Boolean.getBoolean("org.opennms.netmgt.rrd.debugTokens");
        if (!LOG.isDebugEnabled()) {
            debugTokens = false;
        }
        if (debugTokens) {
            LOG.debug("tokenize: line={}, delims={}", (Object)line, (Object)delims);
        }
        for (int i = 0; i < line.length(); ++i) {
            char ch = line.charAt(i);
            if (debugTokens) {
                LOG.debug("tokenize: checking char: {}", (Object)Character.valueOf(ch));
            }
            if (escaping) {
                if (ch == 'n') {
                    currToken.append(JRobinRrdStrategy.escapeIfNotPathSepInDEF(ch, '\n', currToken));
                } else if (ch == 'r') {
                    currToken.append(JRobinRrdStrategy.escapeIfNotPathSepInDEF(ch, '\r', currToken));
                } else if (ch == 't') {
                    currToken.append(JRobinRrdStrategy.escapeIfNotPathSepInDEF(ch, '\t', currToken));
                } else if (tokens.indexOf(ch) >= 0) {
                    currToken.append('\\').append(ch);
                } else if (currToken.toString().startsWith("DEF:")) {
                    currToken.append('\\').append(ch);
                } else {
                    currToken.append(ch);
                }
                escaping = false;
                if (!debugTokens) continue;
                LOG.debug("tokenize: escaped. appended to {}", (Object)currToken);
                continue;
            }
            if (ch == '\\') {
                if (debugTokens) {
                    LOG.debug("tokenize: found a backslash... escaping currToken = {}", (Object)currToken);
                }
                if (quoting && !processQuoted) {
                    currToken.append(ch);
                    continue;
                }
                escaping = true;
                continue;
            }
            if (ch == '\"') {
                if (!processQuoted) {
                    currToken.append(ch);
                }
                if (quoting) {
                    if (debugTokens) {
                        LOG.debug("tokenize: found a quote ending quotation currToken = {}", (Object)currToken);
                    }
                    quoting = false;
                    continue;
                }
                if (debugTokens) {
                    LOG.debug("tokenize: found a quote beginning quotation  currToken = {}", (Object)currToken);
                }
                quoting = true;
                continue;
            }
            if (!quoting && delims.indexOf(ch) >= 0) {
                if (debugTokens) {
                    LOG.debug("tokenize: found a token: {} ending token [{}] and starting a new one", (Object)Character.valueOf(ch), (Object)currToken);
                }
                tokenList.add(currToken.toString());
                currToken = new StringBuffer();
                continue;
            }
            if (debugTokens) {
                LOG.debug("tokenize: appending {} to token: {}", (Object)Character.valueOf(ch), (Object)currToken);
            }
            currToken.append(ch);
        }
        if (escaping || quoting) {
            if (debugTokens) {
                LOG.debug("tokenize: ended string but escaping = {} and quoting = {}", (Object)escaping, (Object)quoting);
            }
            throw new IllegalArgumentException("unable to tokenize string " + line + " with token chars " + delims);
        }
        if (debugTokens) {
            LOG.debug("tokenize: reached end of string.  completing token {}", (Object)currToken);
        }
        tokenList.add(currToken.toString());
        return tokenList.toArray(new String[tokenList.size()]);
    }

    public static char[] escapeIfNotPathSepInDEF(char encountered, char escaped, StringBuffer currToken) {
        if ('\\' != File.separatorChar || !currToken.toString().startsWith("DEF:")) {
            return new char[]{escaped};
        }
        return new char[]{'\\', encountered};
    }

    protected void addVdefDs(RrdGraphDef graphDef, String sourceName, String[] rhs, double start, double end, Map<String, List<String>> defs) throws org.jrobin.core.RrdException {
        if (rhs.length == 2) {
            graphDef.datasource(sourceName, rhs[0], rhs[1]);
        } else if (rhs.length == 3 && "PERCENT".equals(rhs[2])) {
            double pctRank = Double.valueOf(rhs[1]);
            DataProcessor dataProcessor = new DataProcessor((long)((int)start), (long)((int)end));
            for (Map.Entry<String, List<String>> entry : defs.entrySet()) {
                String dsName = entry.getKey();
                List<String> thisDef = entry.getValue();
                if (thisDef.size() == 3) {
                    dataProcessor.addDatasource(dsName, thisDef.get(0), thisDef.get(1), thisDef.get(2));
                    continue;
                }
                if (thisDef.size() != 1) continue;
                dataProcessor.addDatasource(dsName, thisDef.get(0));
            }
            try {
                dataProcessor.processData();
            }
            catch (IOException e) {
                throw new org.jrobin.core.RrdException("Caught IOException: " + e.getMessage());
            }
            double result = dataProcessor.getPercentile(rhs[0], pctRank);
            ConstantStaticDef csDef = new ConstantStaticDef((long)start, (long)end, result);
            graphDef.datasource(sourceName, (Plottable)csDef);
        }
    }

    static class ConstantStaticDef
    extends Plottable {
        private double m_startTime = Double.NEGATIVE_INFINITY;
        private double m_endTime = Double.POSITIVE_INFINITY;
        private double m_value = Double.NaN;

        ConstantStaticDef(long startTime, long endTime, double value) {
            this.m_startTime = startTime;
            this.m_endTime = endTime;
            this.m_value = value;
        }

        public double getValue(long timestamp) {
            if (this.m_startTime <= (double)timestamp && this.m_endTime >= (double)timestamp) {
                return this.m_value;
            }
            return Double.NaN;
        }
    }
}

