/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.opennms.core.utils.PropertiesCache;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class RrdUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RrdUtils.class);
    private static PropertiesCache s_cache = new PropertiesCache();

    public static void createMetaDataFile(String directory, String rrdName, Map<String, String> attributeMappings) {
        File metaFile = new File(directory + File.separator + rrdName + ".meta");
        LOG.info("createMetaDataFile: creating meta data file {} with values '{}'", (Object)metaFile, attributeMappings);
        try {
            if (metaFile.exists()) {
                s_cache.updateProperties(metaFile, attributeMappings);
            } else {
                s_cache.saveProperties(metaFile, attributeMappings);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to save metadata file {}", (Object)metaFile, (Object)e);
        }
    }

    public static Map<String, String> readMetaDataFile(String directory, String rrdName) {
        File metaFile = new File(directory + File.separator + rrdName + ".meta");
        try {
            Properties props = s_cache.getProperties(metaFile);
            HashMap<String, String> ret = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                Object value = entry.getValue();
                ret.put(entry.getKey().toString(), value == null ? null : value.toString());
            }
            return ret;
        }
        catch (IOException e) {
            LOG.warn("Failed to retrieve metadata from {}", (Object)metaFile, (Object)e);
            return Collections.emptyMap();
        }
    }

    public static boolean createRRD(RrdStrategy<?, ?> rrdStrategy, String creator, String directory, String dsName, int step, String dsType, int dsHeartbeat, String dsMin, String dsMax, List<String> rraList, Map<String, String> attributeMappings) throws RrdException {
        return RrdUtils.createRRD(rrdStrategy, creator, directory, dsName, step, Collections.singletonList(new RrdDataSource(dsName, dsType, dsHeartbeat, dsMin, dsMax)), rraList, attributeMappings);
    }

    public static boolean createRRD(RrdStrategy<?, ?> rrdStrategy, String creator, String directory, String dsName, int step, String dsType, int dsHeartbeat, String dsMin, String dsMax, List<String> rraList) throws RrdException {
        return RrdUtils.createRRD(rrdStrategy, creator, directory, dsName, step, Collections.singletonList(new RrdDataSource(dsName, dsType, dsHeartbeat, dsMin, dsMax)), rraList, null);
    }

    public static boolean createRRD(RrdStrategy<?, ?> rrdStrategy, String creator, String directory, String rrdName, int step, List<RrdDataSource> dataSources, List<String> rraList) throws RrdException {
        return RrdUtils.createRRD(rrdStrategy, creator, directory, rrdName, step, dataSources, rraList, null);
    }

    public static boolean createRRD(RrdStrategy<?, ?> rrdStrategy, String creator, String directory, String rrdName, int step, List<RrdDataSource> dataSources, List<String> rraList, Map<String, String> attributeMappings) throws RrdException {
        Object def = null;
        try {
            RrdStrategy<Object, Object> strategy = RrdUtils.toGenericType(rrdStrategy);
            def = strategy.createDefinition(creator, directory, rrdName, step, dataSources, rraList);
            strategy.createFile(def, attributeMappings);
            return true;
        }
        catch (Throwable e) {
            String path = directory + File.separator + rrdName + rrdStrategy.getDefaultFileExtension();
            LOG.error("createRRD: An error occurred creating rrdfile {}", (Object)path, (Object)e);
            throw new RrdException("An error occurred creating rrdfile " + path + ": " + e, e);
        }
    }

    public static void updateRRD(RrdStrategy<?, ?> rrdStrategy, String owner, String repositoryDir, String rrdName, String val) throws RrdException {
        RrdUtils.updateRRD(rrdStrategy, owner, repositoryDir, rrdName, System.currentTimeMillis(), val);
    }

    public static void updateRRD(RrdStrategy<?, ?> rrdStrategy, String owner, String repositoryDir, String rrdName, long timestamp, String val) throws RrdException {
        String rrdFile = repositoryDir + File.separator + rrdName + rrdStrategy.getDefaultFileExtension();
        long time = (timestamp + 500L) / 1000L;
        String updateVal = Long.toString(time) + ":" + val;
        LOG.info("updateRRD: updating RRD file {} with values '{}'", (Object)rrdFile, (Object)updateVal);
        RrdStrategy<Object, Object> strategy = RrdUtils.toGenericType(rrdStrategy);
        Object rrd = null;
        try {
            rrd = strategy.openFile(rrdFile);
            strategy.updateFile(rrd, owner, updateVal);
        }
        catch (Throwable e) {
            LOG.error("updateRRD: Error updating RRD file {} with values '{}'", new Object[]{rrdFile, updateVal, e});
            throw new RrdException("Error updating RRD file " + rrdFile + " with values '" + updateVal + "': " + e, e);
        }
        finally {
            try {
                if (rrd != null) {
                    strategy.closeFile(rrd);
                }
            }
            catch (Throwable e) {
                LOG.error("updateRRD: Exception closing RRD file {}", (Object)rrdFile, (Object)e);
                throw new RrdException("Exception closing RRD file " + rrdFile + ": " + e, e);
            }
        }
        LOG.debug("updateRRD: RRD update command completed.");
    }

    private static RrdStrategy<Object, Object> toGenericType(RrdStrategy<?, ?> rrdStrategy) {
        Assert.notNull(rrdStrategy);
        return rrdStrategy;
    }
}

