/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import java.net.InetAddress;
import org.opennms.core.utils.AlphaNumeric;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReverseDnsRecord {
    private static final Logger LOG = LoggerFactory.getLogger(ReverseDnsRecord.class);
    String m_hostname;
    String m_zone;
    InetAddress m_ip;

    public ReverseDnsRecord(OnmsIpInterface ipInterface, int level) {
        OnmsSnmpInterface snmpInterface = ipInterface.getSnmpInterface();
        if (snmpInterface == null) {
            LOG.debug("Constructor: no SnmpInterface found");
            this.m_hostname = ipInterface.getNode().getLabel() + ".";
        } else if (snmpInterface.getIfName() != null) {
            LOG.debug("Constructor: SnmpInterface found: ifname: {}", (Object)snmpInterface.getIfName());
            this.m_hostname = AlphaNumeric.parseAndReplace((String)snmpInterface.getIfName(), (char)'-') + "-" + ipInterface.getNode().getLabel() + ".";
        } else if (snmpInterface.getIfDescr() != null) {
            LOG.debug("Constructor: SnmpInterface found: ifdescr: {}", (Object)snmpInterface.getIfDescr());
            this.m_hostname = AlphaNumeric.parseAndReplace((String)snmpInterface.getIfDescr(), (char)'-') + "-" + ipInterface.getNode().getLabel() + ".";
        } else {
            LOG.debug("Constructor: SnmpInterface found: ifindex: {}", (Object)snmpInterface.getIfDescr());
            this.m_hostname = "ifindex-" + snmpInterface.getIfIndex() + "-" + ipInterface.getNode().getLabel() + ".";
        }
        LOG.debug("Constructor: set hostname: {}", (Object)this.m_hostname);
        this.m_ip = ipInterface.getIpAddress();
        LOG.debug("Constructor: set ip address: {}", (Object)this.m_ip);
        this.m_zone = level == 1 ? ReverseDnsRecord.firstLevelZonefromInet4Address(this.m_ip.getAddress()) : (level == 2 ? ReverseDnsRecord.secondLevelZonefromInet4Address(this.m_ip.getAddress()) : ReverseDnsRecord.thirdLevelZonefromInet4Address(this.m_ip.getAddress()));
        LOG.debug("Constructor: set zone: {}", (Object)this.m_zone);
    }

    public String getHostname() {
        return this.m_hostname;
    }

    public String getZone() {
        return this.m_zone;
    }

    public InetAddress getIp() {
        return this.m_ip;
    }

    public static String thirdLevelZonefromInet4Address(byte[] addr) {
        if (addr.length != 4 && addr.length != 16) {
            throw new IllegalArgumentException("array must contain 4 or 16 elements");
        }
        StringBuilder sb = new StringBuilder();
        if (addr.length == 4) {
            for (int i = addr.length - 2; i >= 0; --i) {
                sb.append(addr[i] & 0xFF);
                if (i <= 0) continue;
                sb.append(".");
            }
        }
        sb.append(".in-addr.arpa.");
        return sb.toString();
    }

    public static String secondLevelZonefromInet4Address(byte[] addr) {
        if (addr.length != 4 && addr.length != 16) {
            throw new IllegalArgumentException("array must contain 4 or 16 elements");
        }
        StringBuilder sb = new StringBuilder();
        if (addr.length == 4) {
            for (int i = addr.length - 3; i >= 0; --i) {
                sb.append(addr[i] & 0xFF);
                if (i <= 0) continue;
                sb.append(".");
            }
        }
        sb.append(".in-addr.arpa.");
        return sb.toString();
    }

    public static String firstLevelZonefromInet4Address(byte[] addr) {
        if (addr.length != 4 && addr.length != 16) {
            throw new IllegalArgumentException("array must contain 4 or 16 elements");
        }
        StringBuilder sb = new StringBuilder();
        if (addr.length == 4) {
            for (int i = addr.length - 4; i >= 0; --i) {
                sb.append(addr[i] & 0xFF);
                if (i <= 0) continue;
                sb.append(".");
            }
        }
        sb.append(".in-addr.arpa.");
        return sb.toString();
    }
}

