/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.provision.ReverseDnsProvisioningAdapterService;
import org.opennms.netmgt.provision.ReverseDnsRecord;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

public class DefaultReverseDnsProvisioningAdapterService
implements ReverseDnsProvisioningAdapterService {
    private NodeDao m_nodeDao;
    private IpInterfaceDao m_ipInterfaceDao;
    private TransactionTemplate m_template;
    private Integer m_level = 3;

    public void setTemplate(TransactionTemplate template) {
        this.m_template = template;
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao dao) {
        this.m_nodeDao = dao;
    }

    public void afterPropertiesSet() throws Exception {
        Integer level;
        Assert.notNull((Object)this.m_nodeDao, (String)"ReverseDnsProvisioner requires a NodeDao which is not null.");
        Assert.notNull((Object)this.m_ipInterfaceDao, (String)"ReverseDnsProvisioner requires an IpInterfaceDao which is not null.");
        String levelString = System.getProperty("importer.adapter.dns.reverse.level");
        if (levelString != null && (level = SystemProperties.getInteger((String)levelString)) != null && level > 0) {
            this.m_level = level;
        }
    }

    @Override
    public List<ReverseDnsRecord> get(final Integer nodeid) {
        final ArrayList<ReverseDnsRecord> records = new ArrayList<ReverseDnsRecord>();
        this.m_template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus arg0) {
                for (OnmsIpInterface ipInterface : ((OnmsNode)DefaultReverseDnsProvisioningAdapterService.this.m_nodeDao.get((Serializable)nodeid)).getIpInterfaces()) {
                    records.add(new ReverseDnsRecord(ipInterface, DefaultReverseDnsProvisioningAdapterService.this.m_level));
                }
            }
        });
        return records;
    }

    @Override
    public void update(Integer nodeid, ReverseDnsRecord rdr) {
        OnmsIpInterface ipInterface = this.m_ipInterfaceDao.findByNodeIdAndIpAddress(nodeid, rdr.getIp().getHostAddress());
        if (ipInterface != null) {
            ipInterface.setIpHostName(rdr.getHostname());
            this.m_ipInterfaceDao.update((Object)ipInterface);
        }
    }

    public Integer getLevel() {
        return this.m_level;
    }

    public void setLevel(Integer level) {
        this.m_level = level;
    }
}

