/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import java.net.InetAddress;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.provision.ProvisioningAdapterException;
import org.opennms.netmgt.provision.ReverseDnsProvisioningAdapterService;
import org.opennms.netmgt.provision.ReverseDnsRecord;
import org.opennms.netmgt.provision.SimpleQueuedProvisioningAdapter;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ReverseMap;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.Update;

public class ReverseDnsProvisioningAdapter
extends SimpleQueuedProvisioningAdapter
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(ReverseDnsProvisioningAdapter.class);
    private EventForwarder m_eventForwarder;
    private Resolver m_resolver = null;
    private String m_signature;
    private ReverseDnsProvisioningAdapterService m_reverseDnsProvisioningAdapterService;
    private static final String MESSAGE_PREFIX = "Dynamic Reverse DNS provisioning failed: ";
    private static final String ADAPTER_NAME = "Reverse DNS Provisioning Adapter";

    public void afterPropertiesSet() throws Exception {
        String dnsServer = System.getProperty("importer.adapter.dns.server");
        if (!StringUtils.isBlank((String)dnsServer)) {
            LOG.info("DNS property found: {}", (Object)dnsServer);
            if (dnsServer.contains(":")) {
                String[] serverAddress = dnsServer.split(":");
                this.m_resolver = new SimpleResolver(serverAddress[0]);
                this.m_resolver.setPort(Integer.valueOf(serverAddress[1]).intValue());
            } else {
                this.m_resolver = new SimpleResolver(dnsServer);
            }
            String key = System.getProperty("importer.adapter.dns.privatekey");
            if (key != null && key.length() > 0) {
                this.m_signature = key;
                this.m_resolver.setTSIGKey(TSIG.fromString((String)this.m_signature));
            }
        } else {
            LOG.warn("no DNS server configured, ReverseDnsProvisioningAdapter will not do anything!");
        }
    }

    public ReverseDnsProvisioningAdapterService getReverseProvisioningAdapterService() {
        return this.m_reverseDnsProvisioningAdapterService;
    }

    public void setReverseDnsProvisioningAdapterService(ReverseDnsProvisioningAdapterService reverseProvisioningAdapterService) {
        this.m_reverseDnsProvisioningAdapterService = reverseProvisioningAdapterService;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public String getName() {
        return ADAPTER_NAME;
    }

    public boolean isNodeReady(SimpleQueuedProvisioningAdapter.AdapterOperation op) {
        return true;
    }

    public void processPendingOperationForNode(SimpleQueuedProvisioningAdapter.AdapterOperation op) throws ProvisioningAdapterException {
        if (this.m_resolver == null) {
            return;
        }
        LOG.info("processPendingOperationForNode: Handling Operation: {}", (Object)op);
        if (op.getType() == SimpleQueuedProvisioningAdapter.AdapterOperationType.ADD || op.getType() == SimpleQueuedProvisioningAdapter.AdapterOperationType.UPDATE) {
            this.doUpdate(op);
        } else if (op.getType() != SimpleQueuedProvisioningAdapter.AdapterOperationType.DELETE && op.getType() != SimpleQueuedProvisioningAdapter.AdapterOperationType.CONFIG_CHANGE) {
            LOG.warn("unknown operation: {}", (Object)op.getType());
        }
    }

    private void doUpdate(SimpleQueuedProvisioningAdapter.AdapterOperation op) {
        LOG.debug("doUpdate: operation: {}", (Object)op.getType().name());
        for (ReverseDnsRecord record : this.m_reverseDnsProvisioningAdapterService.get(op.getNodeId())) {
            LOG.debug("doUpdate: ReverseDnsRecord: hostname: {} zone: {} ip address: {}", new Object[]{record.getIp().getHostAddress(), record.getHostname(), record.getZone()});
            try {
                Update update = new Update(Name.fromString((String)record.getZone()));
                Name ptrRecord = ReverseMap.fromAddress((InetAddress)record.getIp());
                update.replace(ptrRecord, 12, 3600L, record.getHostname());
                this.m_resolver.send((Message)update);
                this.m_reverseDnsProvisioningAdapterService.update(op.getNodeId(), record);
            }
            catch (Exception e) {
                LOG.error("updateNode: Error handling updated event.", (Throwable)e);
                this.sendAndThrow(op.getNodeId(), e);
            }
        }
    }

    private void sendAndThrow(int nodeId, Exception e) {
        Event event = this.buildEvent("uei.opennms.org/provisioner/provisioningAdapterFailed", nodeId).addParam("reason", MESSAGE_PREFIX + e.getLocalizedMessage()).getEvent();
        this.m_eventForwarder.sendNow(event);
        throw new ProvisioningAdapterException(MESSAGE_PREFIX, (Throwable)e);
    }

    private EventBuilder buildEvent(String uei, int nodeId) {
        EventBuilder builder = new EventBuilder(uei, "Provisioner", new Date());
        builder.setNodeid((long)nodeId);
        return builder;
    }
}

