/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.requisition;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.url.GenericURLConnection;
import org.opennms.core.xml.XmlHandler;
import org.opennms.netmgt.provision.persist.LocationAwareRequisitionClient;
import org.opennms.netmgt.provision.persist.requisition.Requisition;

public class RequisitionUrlConnection
extends URLConnection {
    private final String type;
    private final Map<String, String> parameters;
    private static final XmlHandler<Requisition> s_xmlHandler = new XmlHandler(Requisition.class);
    private static LocationAwareRequisitionClient s_requisitionProviderClient;

    public RequisitionUrlConnection(URL url) {
        super(url);
        this.type = url.getHost();
        this.parameters = RequisitionUrlConnection.getParameters(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() throws IOException {
        try {
            String requisitionXml;
            Requisition requisition = (Requisition)this.getClient().requisition().withRequisitionProviderType(this.type).withParameters(this.parameters).execute().get();
            if (requisition == null) {
                throw new IOException(String.format("Invalid (null) requisition was returned by the provider for type '%s'", this.type));
            }
            XmlHandler<Requisition> xmlHandler = s_xmlHandler;
            synchronized (xmlHandler) {
                requisitionXml = s_xmlHandler.marshal((Object)requisition);
            }
            return new ByteArrayInputStream(requisitionXml.getBytes());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void connect() {
    }

    private LocationAwareRequisitionClient getClient() {
        if (s_requisitionProviderClient == null) {
            s_requisitionProviderClient = (LocationAwareRequisitionClient)BeanUtils.getBean((String)"daoContext", (String)"locationAwareRequisitionClient", LocationAwareRequisitionClient.class);
        }
        return s_requisitionProviderClient;
    }

    public static void setClient(LocationAwareRequisitionClient client) {
        s_requisitionProviderClient = client;
    }

    public static Map<String, String> getParameters(URL url) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", url.getHost());
        params.put("path", url.getPath());
        String userInfo = url.getUserInfo();
        if (userInfo != null && !userInfo.isEmpty()) {
            if (userInfo.contains(":")) {
                String[] tokens = userInfo.split(":");
                params.put("username", tokens[0]);
                params.put("password", tokens[1]);
            } else {
                params.put("username", userInfo);
            }
        }
        params.putAll(GenericURLConnection.getQueryStringParameters((String)url.getQuery()));
        return Collections.unmodifiableMap(params);
    }
}

