/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.requisition;

import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.provision.persist.RequisitionRequest;

@XmlRootElement(name="http-requisition-request")
@XmlAccessorType(value=XmlAccessType.NONE)
public class HttpRequisitionRequest
implements RequisitionRequest {
    @XmlAttribute(name="url")
    private String url;
    @XmlAttribute(name="username")
    private String username;
    @XmlAttribute(name="password")
    private String password;
    @XmlAttribute(name="strict-ssl")
    private Boolean strictSsl;

    public HttpRequisitionRequest() {
    }

    public HttpRequisitionRequest(Map<String, String> parameters) {
        this.url = parameters.get("url");
        if (this.url == null || this.url.isEmpty()) {
            throw new IllegalArgumentException("url is required.");
        }
        this.username = parameters.get("username");
        this.password = parameters.get("password");
        if (parameters.containsKey("strict-ssl")) {
            this.strictSsl = Boolean.parseBoolean(parameters.get("strict-ssl"));
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Boolean getStrictSsl() {
        return this.strictSsl;
    }

    public void setStrictSsl(Boolean strictSsl) {
        this.strictSsl = strictSsl;
    }

    public boolean equals(Object other) {
        if (!(other instanceof HttpRequisitionRequest)) {
            return false;
        }
        HttpRequisitionRequest castOther = (HttpRequisitionRequest)other;
        return Objects.equals(this.url, castOther.url) && Objects.equals(this.username, castOther.username) && Objects.equals(this.password, castOther.password) && Objects.equals(this.strictSsl, castOther.strictSsl);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.username, this.password, this.strictSsl);
    }
}

