/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.rpc;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.opennms.core.rpc.xml.AbstractXmlRpcModule;
import org.opennms.netmgt.provision.persist.RequisitionProvider;
import org.opennms.netmgt.provision.persist.RequisitionProviderRegistry;
import org.opennms.netmgt.provision.persist.RequisitionRequest;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.rpc.RequisitionRequestDTO;
import org.opennms.netmgt.provision.persist.rpc.RequisitionResponseDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class RequisitionRpcModule
extends AbstractXmlRpcModule<RequisitionRequestDTO, RequisitionResponseDTO> {
    public static final String RPC_MODULE_ID = "Requisition";
    @Autowired
    private RequisitionProviderRegistry registry;
    @Autowired
    @Qualifier(value="requisitionRequestExecutor")
    private Executor executor;

    public RequisitionRpcModule() {
        super(RequisitionRequestDTO.class, RequisitionResponseDTO.class);
    }

    public String getId() {
        return RPC_MODULE_ID;
    }

    public RequisitionResponseDTO createResponseWithException(Throwable ex) {
        return new RequisitionResponseDTO(ex);
    }

    public CompletableFuture<RequisitionResponseDTO> execute(final RequisitionRequestDTO request) {
        return CompletableFuture.supplyAsync(new Supplier<RequisitionResponseDTO>(){

            @Override
            public RequisitionResponseDTO get() {
                RequisitionProvider provider = RequisitionRpcModule.this.registry.getProviderByType(request.getType());
                if (provider == null) {
                    throw new IllegalArgumentException("No provider found for type: " + request.getType());
                }
                RequisitionRequest providerRequest = request.getProviderRequest(provider);
                Requisition requisition = provider.getRequisition(providerRequest);
                return new RequisitionResponseDTO(requisition);
            }
        }, this.executor);
    }

    public void setRegistry(RequisitionProviderRegistry registry) {
        this.registry = registry;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }
}

