/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.report;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.opennms.core.logging.Logging;
import org.opennms.javamail.JavaMailer;
import org.opennms.javamail.JavaMailerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportMailer {
    private static final Logger LOG = LoggerFactory.getLogger(ReportMailer.class);
    private static final String LOG4J_CATEGORY = "reports";
    private String m_filename;
    private String m_address;
    private String m_subject;

    public ReportMailer() {
        this(null, null, null);
    }

    public ReportMailer(String address, String filename, String subject) {
        this.m_address = address;
        this.m_filename = filename;
        this.m_subject = subject;
    }

    public void send() throws IOException {
        if (this.m_filename == null || this.m_address == null) {
            throw new IllegalArgumentException("Cannot take null paramters.");
        }
        try {
            Logging.withPrefix((String)LOG4J_CATEGORY, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        JavaMailer jm = new JavaMailer();
                        jm.setTo(ReportMailer.this.m_address);
                        jm.setSubject(ReportMailer.this.m_subject);
                        jm.setFileName(ReportMailer.this.m_filename);
                        jm.setMessageText(ReportMailer.this.m_subject + " Mailed from JavaMailer class.");
                        jm.mailSend();
                    }
                    catch (JavaMailerException e) {
                        LOG.error("Caught JavaMailer exception sending file: {}", (Object)ReportMailer.this.m_filename, (Object)e);
                        throw e;
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new IOException("Error sending file: " + this.m_filename, e);
        }
    }

    public String getAddress() {
        return this.m_address;
    }

    public void setAddress(String address) {
        this.m_address = address;
    }

    public String getFilename() {
        return this.m_filename;
    }

    public void setFilename(String filename) {
        this.m_filename = filename;
    }
}

