/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.report.configuration;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.opennms.core.utils.StringUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.RWSConfig;
import org.opennms.rancid.ConnectionProperties;
import org.opennms.rancid.InventoryNode;
import org.opennms.rancid.RWSClientApi;
import org.opennms.rancid.RancidApiException;
import org.opennms.rancid.RancidNode;
import org.opennms.report.configuration.ConfigurationCalculationException;
import org.opennms.report.configuration.GroupXSet;
import org.opennms.report.configuration.NodeSet;
import org.opennms.report.configuration.RwsRancidlistreport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class ConfigurationReportCalculator
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationReportCalculator.class);
    String m_baseDir;
    private String m_outputFileName;
    ConnectionProperties m_cp;
    RWSConfig m_rwsConfig;
    String theDate;
    String user;
    Date reportRequestDate;
    RwsRancidlistreport rlist;

    public String getOutputFileName() {
        return this.m_outputFileName;
    }

    public void setOutputFileName(String outputFileName) {
        this.m_outputFileName = outputFileName;
    }

    public String getTheDate() {
        return this.theDate;
    }

    public void setTheDate(String theDate) {
        this.theDate = theDate;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Date getReportRequestDate() {
        return this.reportRequestDate;
    }

    public void setReportRequestDate(Date reportRequestDate) {
        this.reportRequestDate = reportRequestDate;
    }

    public RWSConfig getRwsConfig() {
        return this.m_rwsConfig;
    }

    public void setRwsConfig(RWSConfig rwsConfig) {
        this.m_rwsConfig = rwsConfig;
    }

    public String getBaseDir() {
        return this.m_baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.m_baseDir = baseDir;
    }

    public void afterPropertiesSet() throws Exception {
        RWSClientApi.init();
        this.m_cp = this.m_rwsConfig.getBase();
    }

    private List<String> getGroups() {
        try {
            return RWSClientApi.getRWSResourceGroupsList((ConnectionProperties)this.m_cp).getResource();
        }
        catch (RancidApiException e) {
            LOG.error("getGroups: has given exception {}. Skipped", (Object)e.getMessage());
            return new ArrayList<String>();
        }
    }

    private List<String> getDeviceListOnGroup(String groupName) {
        try {
            return RWSClientApi.getRWSResourceDeviceList((ConnectionProperties)this.m_cp, (String)groupName).getResource();
        }
        catch (RancidApiException e) {
            LOG.error("getDeviceListOnGroup: group [{}]. Skipped", (Object)groupName);
            return new ArrayList<String>();
        }
    }

    private List<String> getVersionListOnDevice(String deviceName, String groupName) {
        try {
            return RWSClientApi.getRWSResourceConfigList((ConnectionProperties)this.m_cp, (String)groupName, (String)deviceName).getResource();
        }
        catch (RancidApiException e) {
            LOG.error("getVersionListOnDevice:  device has no inventory [{}]. {}", (Object)deviceName, (Object)e.getLocalizedMessage());
            return new ArrayList<String>();
        }
    }

    private RancidNode getFullNode(String groupName, String deviceName) {
        try {
            return RWSClientApi.getRWSRancidNodeInventory((ConnectionProperties)this.m_cp, (String)groupName, (String)deviceName);
        }
        catch (RancidApiException e) {
            LOG.error("getFullNode:  device has no inventory [{}]. {}", (Object)deviceName, (Object)e.getLocalizedMessage());
            return null;
        }
    }

    public void calculate() {
        this.rlist = new RwsRancidlistreport();
        this.rlist.setUser(this.user);
        this.rlist.setReportRequestDate(StringUtils.toStringEfficiently((Date)this.reportRequestDate));
        SimpleDateFormat format = new SimpleDateFormat("yyyy/M/d");
        Date tmp_date = new Date();
        try {
            tmp_date = format.parse(this.theDate);
        }
        catch (ParseException pe) {
            tmp_date = Calendar.getInstance().getTime();
        }
        LOG.debug("calculate:report date[{}]", (Object)tmp_date.toString());
        this.rlist.setReportDate(tmp_date.toString());
        int totalGroups = 0;
        int groupsMatching = 0;
        int groupWithoutNodes = 0;
        int groupsWithNodesWithoutconfigurationAtAll = 0;
        int groupsWithNodesWithoutconfigurationAtReportDate = 0;
        for (String groupName : this.getGroups()) {
            LOG.debug("calculate:report group [{}]", (Object)groupName);
            ++totalGroups;
            GroupXSet gs = new GroupXSet();
            gs.setGroupXSetName(groupName);
            int totalNodes = 0;
            int nodeMatching = 0;
            int nodesWithoutConfigurationAtAll = 0;
            int nodesWithoutConfigurationAtReportDate = 0;
            boolean groupHasDevices = false;
            boolean groupHasNodesWithoutconfigurationAtAll = false;
            boolean groupHasNodesWithoutconfigurationAtrequestDate = false;
            for (String deviceName : this.getDeviceListOnGroup(groupName)) {
                ++totalNodes;
                NodeSet ns = new NodeSet();
                ns.setDevicename(deviceName);
                ns.setGroupname(groupName);
                LOG.debug("calculate:report device [{}]", (Object)deviceName);
                RancidNode rancidNode = this.getFullNode(groupName, deviceName);
                if (rancidNode == null) {
                    ns.setVersion("No Configurations found");
                    groupHasNodesWithoutconfigurationAtAll = true;
                    ++nodesWithoutConfigurationAtAll;
                    gs.addNodeSet(ns);
                    continue;
                }
                InventoryNode invNode = new InventoryNode(rancidNode);
                boolean found = false;
                for (String versionMatch : this.getVersionListOnDevice(deviceName, groupName)) {
                    invNode = (InventoryNode)rancidNode.getNodeVersions().get(versionMatch);
                    LOG.debug("calculate:report parsing InventoryNode version[{}] date [{}]", (Object)invNode.getVersionId(), (Object)invNode.getCreationDate());
                    if (tmp_date.compareTo(invNode.getCreationDate()) <= 0) continue;
                    found = true;
                    LOG.debug("calculate:report Date found is [{}] version is [{}]", (Object)invNode.getCreationDate(), (Object)versionMatch);
                    break;
                }
                if (!found) {
                    LOG.debug("calculate:report device has no inventory at this date[{}]", (Object)deviceName);
                    groupHasNodesWithoutconfigurationAtrequestDate = true;
                    ++nodesWithoutConfigurationAtReportDate;
                    ns.setVersion("No configuration found at Report Date");
                } else {
                    ns.setVersion(invNode.getVersionId());
                    ns.setConfigurationurl(invNode.getConfigurationUrl());
                    ns.setSwconfigurationurl(invNode.getSoftwareImageUrl());
                    ns.setStatus(rancidNode.getState());
                    ns.setCreationdate(invNode.getCreationDate().toString());
                    groupHasDevices = true;
                    ++nodeMatching;
                }
                gs.addNodeSet(ns);
            }
            gs.setTotalNodes(totalNodes);
            gs.setNodesMatching(nodeMatching);
            gs.setNodesWithoutconfigurationAtReportDate(nodesWithoutConfigurationAtReportDate);
            gs.setNodesWithoutconfigurationAtAll(nodesWithoutConfigurationAtAll);
            this.rlist.addGroupXSet(gs);
            if (groupHasDevices) {
                ++groupsMatching;
            } else {
                ++groupWithoutNodes;
            }
            if (groupHasDevices && groupHasNodesWithoutconfigurationAtAll) {
                ++groupsWithNodesWithoutconfigurationAtAll;
            }
            if (!groupHasDevices || !groupHasNodesWithoutconfigurationAtrequestDate) continue;
            ++groupsWithNodesWithoutconfigurationAtReportDate;
        }
        this.rlist.setTotalGroups(totalGroups);
        this.rlist.setGroupWithoutNodes(groupWithoutNodes);
        this.rlist.setGroupsMatching(groupsMatching);
        this.rlist.setGroupsWithNodesWithoutconfigurationAtAll(groupsWithNodesWithoutconfigurationAtAll);
        this.rlist.setGroupsWithNodesWithoutconfigurationAtReportDate(groupsWithNodesWithoutconfigurationAtReportDate);
    }

    public void writeXML() throws ConfigurationCalculationException {
        try {
            LOG.debug("Writing the XML");
            SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMddHHmmss");
            String datestamp = fmt.format(this.reportRequestDate);
            this.m_outputFileName = "/RANCIDLISTREPORT" + datestamp + ".xml";
            LOG.debug("Report Store XML file: {}", (Object)this.m_outputFileName);
            File reportFile = new File(this.m_baseDir, this.m_outputFileName);
            this.marshal(reportFile);
        }
        catch (ConfigurationCalculationException e) {
            LOG.error("Unable to marshal report as XML");
            throw new ConfigurationCalculationException(e);
        }
    }

    public void marshal(File outputFile) throws ConfigurationCalculationException {
        try {
            JaxbUtils.marshal((Object)this.rlist, (File)outputFile);
        }
        catch (IOException ioe) {
            LOG.error("IO Exception ", (Throwable)ioe);
            throw new ConfigurationCalculationException(ioe);
        }
    }
}

