/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.report.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.report.configuration.NodeSet;

@XmlRootElement(name="groupXSet")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class GroupXSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="groupXSetName", required=true)
    private String groupXSetName;
    @XmlElement(name="totalNodes")
    private Integer totalNodes;
    @XmlElement(name="nodesMatching")
    private Integer nodesMatching;
    @XmlElement(name="nodesWithoutconfigurationAtAll")
    private Integer nodesWithoutconfigurationAtAll;
    @XmlElement(name="nodesWithoutconfigurationAtReportDate")
    private Integer nodesWithoutconfigurationAtReportDate;
    @XmlElement(name="nodeSet")
    private List<NodeSet> nodeSetList = new ArrayList<NodeSet>();

    public void addNodeSet(NodeSet vNodeSet) throws IndexOutOfBoundsException {
        this.nodeSetList.add(vNodeSet);
    }

    public void addNodeSet(int index, NodeSet vNodeSet) throws IndexOutOfBoundsException {
        this.nodeSetList.add(index, vNodeSet);
    }

    public void deleteNodesMatching() {
        this.nodesMatching = null;
    }

    public void deleteNodesWithoutconfigurationAtAll() {
        this.nodesWithoutconfigurationAtAll = null;
    }

    public void deleteNodesWithoutconfigurationAtReportDate() {
        this.nodesWithoutconfigurationAtReportDate = null;
    }

    public void deleteTotalNodes() {
        this.totalNodes = null;
    }

    public Enumeration<NodeSet> enumerateNodeSet() {
        return Collections.enumeration(this.nodeSetList);
    }

    public String getGroupXSetName() {
        return this.groupXSetName;
    }

    public NodeSet getNodeSet(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.nodeSetList.size()) {
            throw new IndexOutOfBoundsException("getNodeSet: Index value '" + index + "' not in range [0.." + (this.nodeSetList.size() - 1) + "]");
        }
        return this.nodeSetList.get(index);
    }

    public NodeSet[] getNodeSet() {
        NodeSet[] array = new NodeSet[]{};
        return this.nodeSetList.toArray(array);
    }

    public List<NodeSet> getNodeSetCollection() {
        return this.nodeSetList;
    }

    public int getNodeSetCount() {
        return this.nodeSetList.size();
    }

    public Integer getNodesMatching() {
        return this.nodesMatching;
    }

    public Integer getNodesWithoutconfigurationAtAll() {
        return this.nodesWithoutconfigurationAtAll;
    }

    public Integer getNodesWithoutconfigurationAtReportDate() {
        return this.nodesWithoutconfigurationAtReportDate;
    }

    public Integer getTotalNodes() {
        return this.totalNodes;
    }

    public boolean hasNodesMatching() {
        return this.nodesMatching != null;
    }

    public boolean hasNodesWithoutconfigurationAtAll() {
        return this.nodesWithoutconfigurationAtAll != null;
    }

    public boolean hasNodesWithoutconfigurationAtReportDate() {
        return this.nodesWithoutconfigurationAtReportDate != null;
    }

    public boolean hasTotalNodes() {
        return this.totalNodes != null;
    }

    public Iterator<NodeSet> iterateNodeSet() {
        return this.nodeSetList.iterator();
    }

    public void removeAllNodeSet() {
        this.nodeSetList.clear();
    }

    public boolean removeNodeSet(NodeSet vNodeSet) {
        boolean removed = this.nodeSetList.remove(vNodeSet);
        return removed;
    }

    public NodeSet removeNodeSetAt(int index) {
        NodeSet obj = this.nodeSetList.remove(index);
        return obj;
    }

    public void setGroupXSetName(String groupXSetName) {
        this.groupXSetName = groupXSetName;
    }

    public void setNodeSet(int index, NodeSet vNodeSet) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.nodeSetList.size()) {
            throw new IndexOutOfBoundsException("setNodeSet: Index value '" + index + "' not in range [0.." + (this.nodeSetList.size() - 1) + "]");
        }
        this.nodeSetList.set(index, vNodeSet);
    }

    public void setNodeSet(NodeSet[] vNodeSetArray) {
        this.nodeSetList.clear();
        for (int i = 0; i < vNodeSetArray.length; ++i) {
            this.nodeSetList.add(vNodeSetArray[i]);
        }
    }

    public void setNodeSet(List<NodeSet> vNodeSetList) {
        this.nodeSetList.clear();
        this.nodeSetList.addAll(vNodeSetList);
    }

    public void setNodeSetCollection(List<NodeSet> nodeSetList) {
        this.nodeSetList = nodeSetList;
    }

    public void setNodesMatching(Integer nodesMatching) {
        this.nodesMatching = nodesMatching;
    }

    public void setNodesWithoutconfigurationAtAll(Integer nodesWithoutconfigurationAtAll) {
        this.nodesWithoutconfigurationAtAll = nodesWithoutconfigurationAtAll;
    }

    public void setNodesWithoutconfigurationAtReportDate(Integer nodesWithoutconfigurationAtReportDate) {
        this.nodesWithoutconfigurationAtReportDate = nodesWithoutconfigurationAtReportDate;
    }

    public void setTotalNodes(Integer totalNodes) {
        this.totalNodes = totalNodes;
    }

    public boolean equals(Object other) {
        if (!(other instanceof GroupXSet)) {
            return false;
        }
        GroupXSet castOther = (GroupXSet)other;
        return Objects.equals(this.groupXSetName, castOther.groupXSetName) && Objects.equals(this.totalNodes, castOther.totalNodes) && Objects.equals(this.nodesMatching, castOther.nodesMatching) && Objects.equals(this.nodesWithoutconfigurationAtAll, castOther.nodesWithoutconfigurationAtAll) && Objects.equals(this.nodesWithoutconfigurationAtReportDate, castOther.nodesWithoutconfigurationAtReportDate) && Objects.equals(this.nodeSetList, castOther.nodeSetList);
    }

    public int hashCode() {
        return Objects.hash(this.groupXSetName, this.totalNodes, this.nodesMatching, this.nodesWithoutconfigurationAtAll, this.nodesWithoutconfigurationAtReportDate, this.nodeSetList);
    }
}

