/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.report.configuration;

import java.io.IOException;
import java.util.Date;
import org.opennms.report.ReportMailer;
import org.opennms.report.configuration.ConfigurationCalculationException;
import org.opennms.report.configuration.ConfigurationReportCalculator;
import org.opennms.reporting.availability.render.ReportRenderException;
import org.opennms.reporting.availability.render.ReportRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationReportRunner
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationReportRunner.class);
    String theDate;
    String reportFormat;
    String reportEmail;
    String user;
    Date reportRequestDate;
    ConfigurationReportCalculator calculator;
    ReportRenderer m_htmlReportRenderer;
    ReportRenderer m_nullReportRenderer;

    public ReportRenderer getNullReportRenderer() {
        return this.m_nullReportRenderer;
    }

    public void setNullReportRenderer(ReportRenderer nullReportRenderer) {
        this.m_nullReportRenderer = nullReportRenderer;
    }

    public ReportRenderer getHtmlReportRenderer() {
        return this.m_htmlReportRenderer;
    }

    public void setHtmlReportRenderer(ReportRenderer htmlReportRenderer) {
        this.m_htmlReportRenderer = htmlReportRenderer;
    }

    public String getTheDate() {
        return this.theDate;
    }

    public void setTheDate(String theDate) {
        this.theDate = theDate;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    public String getReportEmail() {
        return this.reportEmail;
    }

    public void setReportEmail(String reportEmail) {
        this.reportEmail = reportEmail;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Date getReportRequestDate() {
        return this.reportRequestDate;
    }

    public void setReportRequestDate(Date reportRequestDate) {
        this.reportRequestDate = reportRequestDate;
    }

    public ConfigurationReportCalculator getConfigurationReportCalculator() {
        return this.calculator;
    }

    public void setConfigurationReportCalculator(ConfigurationReportCalculator configurationReportCalculator) {
        this.calculator = configurationReportCalculator;
    }

    @Override
    public void run() {
        ReportRenderer renderer;
        LOG.debug("run: getting configuration report on Date [{}]. Requested by User: {}on Date {}", new Object[]{this.theDate, this.user, this.reportRequestDate.toString()});
        this.calculator.setReportRequestDate(this.reportRequestDate);
        this.calculator.setTheDate(this.theDate);
        this.calculator.setUser(this.user);
        if (this.reportFormat.compareTo("pdftype") == 0) {
            LOG.debug("run: generating pdf is still not supported :( sending xml");
            renderer = this.m_nullReportRenderer;
        } else {
            LOG.debug("runRancidListReport generating html");
            renderer = this.m_htmlReportRenderer;
        }
        try {
            this.calculator.calculate();
            this.calculator.writeXML();
            String outputFile = this.calculator.getOutputFileName();
            LOG.debug("Written Configuration Report as XML to {}", (Object)outputFile);
            renderer.setInputFileName(outputFile);
            LOG.debug("rendering XML {} as {}", (Object)outputFile, (Object)renderer.getOutputFileName());
            renderer.render();
            ReportMailer mailer = new ReportMailer(this.reportEmail, renderer.getBaseDir() + renderer.getOutputFileName(), "OpenNMS Configuration Report");
            mailer.send();
        }
        catch (ConfigurationCalculationException ce) {
            LOG.error("Unable to calculate report data ", (Throwable)ce);
        }
        catch (ReportRenderException re) {
            LOG.error("Unable to render report ", (Throwable)re);
        }
        catch (IOException ioe) {
            LOG.error("Unable to render report ", (Throwable)ioe);
        }
    }
}

