/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.report.inventory;

import java.io.IOException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.opennms.report.ReportMailer;
import org.opennms.report.inventory.InventoryCalculationException;
import org.opennms.report.inventory.InventoryReportCalculator;
import org.opennms.reporting.availability.render.ReportRenderException;
import org.opennms.reporting.availability.render.ReportRenderer;

public class InventoryReportRunner
implements Runnable {
    String theDate;
    String theField;
    String reportFormat;
    String reportEmail;
    String user;
    Date reportRequestDate;
    InventoryReportCalculator calculator;
    ReportRenderer m_htmlReportRenderer;
    ReportRenderer m_nullReportRenderer;

    public ReportRenderer getNullReportRenderer() {
        return this.m_nullReportRenderer;
    }

    public void setNullReportRenderer(ReportRenderer nullReportRenderer) {
        this.m_nullReportRenderer = nullReportRenderer;
    }

    public ReportRenderer getHtmlReportRenderer() {
        return this.m_htmlReportRenderer;
    }

    public void setHtmlReportRenderer(ReportRenderer htmlReportRenderer) {
        this.m_htmlReportRenderer = htmlReportRenderer;
    }

    public String getTheDate() {
        return this.theDate;
    }

    public void setTheDate(String theDate) {
        this.theDate = theDate;
    }

    public String getTheField() {
        return this.theField;
    }

    public void setTheField(String theField) {
        this.theField = theField;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    public String getReportEmail() {
        return this.reportEmail;
    }

    public void setReportEmail(String reportEmail) {
        this.reportEmail = reportEmail;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Date getReportRequestDate() {
        return this.reportRequestDate;
    }

    public void setReportRequestDate(Date reportRequestDate) {
        this.reportRequestDate = reportRequestDate;
    }

    public InventoryReportCalculator getInventoryReportCalculator() {
        return this.calculator;
    }

    public void setInventoryReportCalculator(InventoryReportCalculator inventoryReportCalculator) {
        this.calculator = inventoryReportCalculator;
    }

    @Override
    public void run() {
        ReportRenderer renderer;
        InventoryReportRunner.log().debug((Object)("run: getting inventory report on Date [" + this.theDate + "] for key [" + this.theField + "]" + ". Requested by User: " + this.user + "on Date " + this.reportRequestDate.toString()));
        this.calculator.setReportRequestDate(this.reportRequestDate);
        this.calculator.setTheDate(this.theDate);
        this.calculator.setUser(this.user);
        this.calculator.setTheField(this.theField);
        if (this.reportFormat.compareTo("pdftype") == 0) {
            InventoryReportRunner.log().debug((Object)"run: generating pdf is still not supported :( sending xml");
            renderer = this.m_nullReportRenderer;
        } else {
            InventoryReportRunner.log().debug((Object)"runRancidListReport generating html");
            renderer = this.m_htmlReportRenderer;
        }
        try {
            this.calculator.calculate();
            this.calculator.writeXML();
            String outputFile = this.calculator.getOutputFileName();
            InventoryReportRunner.log().debug((Object)("Written Configuration Report as XML to " + outputFile));
            renderer.setInputFileName(outputFile);
            InventoryReportRunner.log().debug((Object)("rendering XML " + outputFile + " as " + renderer.getOutputFileName()));
            renderer.render();
            ReportMailer mailer = new ReportMailer(this.reportEmail, renderer.getBaseDir() + renderer.getOutputFileName(), "OpenNMS Inventory Report");
            mailer.send();
        }
        catch (InventoryCalculationException ce) {
            InventoryReportRunner.log().fatal((Object)"Unable to calculate report data ", (Throwable)ce);
        }
        catch (ReportRenderException re) {
            InventoryReportRunner.log().fatal((Object)"Unable to render report ", (Throwable)re);
        }
        catch (IOException ioe) {
            InventoryReportRunner.log().fatal((Object)"Unable to render report ", (Throwable)ioe);
        }
    }

    private static Logger log() {
        return Logger.getLogger((String)"Rancid");
    }
}

