/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.report;

import java.io.IOException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.javamail.JavaMailer;
import org.opennms.javamail.JavaMailerException;

public class ReportMailer {
    private static final String LOG4J_CATEGORY = "OpenNMS.Report";
    private final ThreadCategory log;
    private String m_filename;
    private String m_address;
    private String m_subject;

    public ReportMailer() {
        this(null, null, null);
    }

    public ReportMailer(String address, String filename, String subject) {
        this.m_address = address;
        this.m_filename = filename;
        this.m_subject = subject;
        String oldPrefix = ThreadCategory.getPrefix();
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        this.log = ThreadCategory.getInstance(ReportMailer.class);
        ThreadCategory.setPrefix((String)oldPrefix);
    }

    public void send() throws IOException {
        if (this.m_filename == null || this.m_address == null) {
            throw new IllegalArgumentException("Cannot take null paramters.");
        }
        try {
            JavaMailer jm = new JavaMailer();
            jm.setTo(this.m_address);
            jm.setSubject(this.m_subject);
            jm.setFileName(this.m_filename);
            jm.setMessageText(this.m_subject + " Mailed from JavaMailer class.");
            jm.mailSend();
        }
        catch (JavaMailerException e) {
            this.log.error("Caught JavaMailer exception sending file: " + this.m_filename, (Throwable)e);
            throw new IOException("Error sending file: " + this.m_filename);
        }
    }

    public String getAddress() {
        return this.m_address;
    }

    public void setAddress(String address) {
        this.m_address = address;
    }

    public String getFilename() {
        return this.m_filename;
    }

    public void setFilename(String filename) {
        this.m_filename = filename;
    }
}

