/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.reporting.service;

import java.io.File;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.opennms.javamail.JavaMailerException;
import org.opennms.javamail.JavaSendMailer;
import org.opennms.netmgt.config.javamail.SendmailConfig;
import org.opennms.netmgt.config.javamail.SendmailMessage;
import org.opennms.netmgt.config.javamail.SendmailProtocol;
import org.opennms.netmgt.config.reportd.Report;
import org.opennms.netmgt.dao.api.JavaMailConfigurationDao;
import org.opennms.netmgt.reporting.service.ReportDeliveryException;
import org.opennms.netmgt.reporting.service.ReportDeliveryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.MimeMessageHelper;

public class JavaMailDeliveryService
implements ReportDeliveryService {
    private static final Logger LOG = LoggerFactory.getLogger(JavaMailDeliveryService.class);
    JavaMailConfigurationDao m_JavamailConfigDao;

    @Override
    public void deliverReport(Report report, String fileName) throws ReportDeliveryException {
        try {
            SendmailConfig config = null;
            if (report.getMailer().isPresent()) {
                String mailer = (String)report.getMailer().get();
                LOG.debug("deliverReport with mailer={}", (Object)mailer);
                config = this.m_JavamailConfigDao.getSendMailConfig(mailer);
            } else {
                LOG.debug("deliverReport with default sendmail config");
                config = this.m_JavamailConfigDao.getDefaultSendmailConfig();
            }
            JavaSendMailer sm = new JavaSendMailer(config);
            MimeMessage msg = new MimeMessage(sm.getSession());
            if (config.getSendmailMessage() != null && config.getSendmailProtocol() != null) {
                SendmailMessage sendmailMessage = config.getSendmailMessage();
                SendmailProtocol sendmailProtocol = config.getSendmailProtocol();
                MimeMessageHelper helper = new MimeMessageHelper(msg, true, sendmailProtocol.getCharSet());
                helper.setFrom(sendmailMessage.getFrom());
                helper.setTo(report.getRecipients().toArray(new String[0]));
                helper.setSubject("OpenNMS Report: " + report.getReportName());
                if ("text/html".equals(sendmailProtocol.getMessageContentType().toLowerCase())) {
                    helper.setText(sendmailMessage.getBody().replaceAll("\\<[^>]*>", ""), sendmailMessage.getBody());
                } else {
                    helper.setText(sendmailMessage.getBody());
                }
                helper.addAttachment(fileName, new File(fileName));
                sm.send(msg);
            } else {
                LOG.error("sendmail-message or sendmail-protocol is not configured!");
            }
        }
        catch (JavaMailerException e) {
            LOG.error("Problem with JavaMailer {}", (Object)e.getMessage(), (Object)e);
            throw new ReportDeliveryException("Caught JavaMailerException: " + e.getMessage());
        }
        catch (MessagingException e) {
            LOG.error("Problem with Messaging {}", (Object)e.getMessage(), (Object)e);
            throw new ReportDeliveryException("Caught MessagingException: " + e.getMessage());
        }
        catch (Throwable e) {
            LOG.error("Unexpected exception: {}", (Object)e.getMessage(), (Object)e);
            throw new ReportDeliveryException("Caught unexpected " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public JavaMailConfigurationDao getJavamailConfigDao() {
        return this.m_JavamailConfigDao;
    }

    public void setJavamailConfigDao(JavaMailConfigurationDao javamailConfigDao) {
        this.m_JavamailConfigDao = javamailConfigDao;
    }

    @Override
    public void reloadConfiguration() {
        this.m_JavamailConfigDao.reloadConfiguration();
    }
}

