/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.reporting.service;

import java.util.List;
import java.util.Map;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.config.reportd.Report;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.netmgt.dao.api.ReportdConfigurationDao;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.reporting.service.ReportDeliveryException;
import org.opennms.netmgt.reporting.service.ReportDeliveryService;
import org.opennms.netmgt.reporting.service.ReportRunException;
import org.opennms.netmgt.reporting.service.ReportScheduler;
import org.opennms.netmgt.reporting.service.ReportService;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

@EventListener(name="Reportd:EventListener", logPrefix="reportd")
public class Reportd
implements SpringServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(Reportd.class);
    public static final String NAME = "reportd";
    private volatile EventForwarder m_eventForwarder;
    private ReportScheduler m_reportScheduler;
    private ReportService m_reportService;
    private ReportDeliveryService m_reportDeliveryService;
    private ReportdConfigurationDao m_reportConfigurationDao;
    private String reportDirectory;

    public void start() throws Exception {
        this.reportDirectory = this.m_reportConfigurationDao.getStorageDirectory();
        this.m_reportScheduler.start();
    }

    public void destroy() throws Exception {
        this.m_reportScheduler.destroy();
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_eventForwarder, (String)"No Event Forwarder Set");
        Assert.notNull((Object)this.m_reportScheduler, (String)"No Report Scheduler Set");
        Assert.notNull((Object)this.m_reportService, (String)"No Report service set");
        Assert.notNull((Object)this.m_reportDeliveryService, (String)"No Delivery service set");
        Assert.notNull((Object)this.m_reportConfigurationDao, (String)"NoConfiguration DAO Defined");
    }

    public void runReport(String reportName) {
        LOG.info("Running report by name: ({}).", (Object)reportName);
        this.runReport(this.m_reportConfigurationDao.getReport(reportName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runReport(Report report) {
        Map mdc = Logging.getCopyOfContextMap();
        try {
            Logging.putPrefix((String)NAME);
            LOG.debug("reportd -- running job {}", (Object)report.getReportName());
            String fileName = this.m_reportService.runReport(report, this.reportDirectory);
            if (report.getRecipientCount() > 0) {
                LOG.debug("reportd -- delivering report {} to {} recipients", (Object)report.getReportName(), (Object)report.getRecipientCount());
                this.m_reportDeliveryService.deliverReport(report, fileName);
            } else {
                LOG.info("Skipped delivery of report {} because it has no recipients", (Object)report.getReportName());
            }
            LOG.debug("reportd -- done running job {}", (Object)report.getReportName());
        }
        catch (ReportRunException e) {
            this.createAndSendReportingEvent("uei.opennms.org/reportd/reportRunFailed", report.getReportName(), e.getMessage());
        }
        catch (ReportDeliveryException e) {
            this.createAndSendReportingEvent("uei.opennms.org/reportd/reportDeliveryFailed", report.getReportName(), e.getMessage());
        }
        finally {
            Logging.setContextMap((Map)mdc);
        }
    }

    private void createAndSendReportingEvent(String uei, String reportName, String reason) {
        LOG.debug("Crafting reporting event with UEI '{}' for report '{}' with reason '{}'", new Object[]{uei, reportName, reason});
        EventBuilder bldr = new EventBuilder(uei, NAME);
        bldr.addParam("reportName", reportName);
        bldr.addParam("reason", reason);
        this.m_eventForwarder.sendNow(bldr.getEvent());
    }

    @EventHandler(uei="uei.opennms.org/reportd/runReport")
    public void handleRunReportEvent(Event e) {
        String reportName = "";
        for (Parm parm : e.getParmCollection()) {
            if ("reportName".equals(parm.getParmName())) {
                reportName = parm.getValue().getContent();
                continue;
            }
            LOG.info("Unknown Event Constant: {}", (Object)parm.getParmName());
        }
        if (!"".equals(reportName)) {
            LOG.debug("running report {}", (Object)reportName);
            this.runReport(reportName);
        } else {
            LOG.error("Can not run report -- reportName not specified");
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadConfigEvent(Event e) {
        if (this.isReloadConfigEventTarget(e)) {
            LOG.info("handleReloadConfigEvent: reloading configuration...");
            EventBuilder ebldr = null;
            try {
                this.reportDirectory = this.m_reportConfigurationDao.getStorageDirectory();
                LOG.debug("handleReloadConfigEvent: lock acquired, unscheduling current reports...");
                this.m_reportScheduler.rebuildReportSchedule();
                LOG.debug("handleReloadConfigEvent: reports rescheduled.");
                this.m_reportDeliveryService.reloadConfiguration();
                LOG.debug("handleReloadConfigEvent: Configuration reloaded for report delivery service {}", (Object)this.m_reportDeliveryService.getClass().getName());
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", "Reportd");
                ebldr.addParam("daemonName", "Reportd");
            }
            catch (Throwable ex) {
                LOG.error("handleReloadConfigurationEvent: Error reloading configuration: {}", (Object)ex.getMessage(), (Object)ex);
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", "Reportd");
                ebldr.addParam("daemonName", "Reportd");
                ebldr.addParam("reason", ex.getLocalizedMessage().substring(1, 128));
            }
            if (ebldr != null) {
                this.getEventForwarder().sendNow(ebldr.getEvent());
            }
            LOG.info("handleReloadConfigEvent: configuration reloaded.");
        }
    }

    private boolean isReloadConfigEventTarget(Event event) {
        boolean isTarget = false;
        List parmCollection = event.getParmCollection();
        for (Parm parm : parmCollection) {
            if (!"daemonName".equals(parm.getParmName()) || !"Reportd".equalsIgnoreCase(parm.getValue().getContent())) continue;
            isTarget = true;
            break;
        }
        LOG.debug("isReloadConfigEventTarget: Reportd was target of reload event: {}", (Object)isTarget);
        return isTarget;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void setReportScheduler(ReportScheduler reportScheduler) {
        this.m_reportScheduler = reportScheduler;
    }

    public ReportScheduler getReportScheduler() {
        return this.m_reportScheduler;
    }

    public ReportService getReportService() {
        return this.m_reportService;
    }

    public void setReportService(ReportService reportService) {
        this.m_reportService = reportService;
    }

    public ReportDeliveryService getReportDeliveryService() {
        return this.m_reportDeliveryService;
    }

    public void setReportDeliveryService(ReportDeliveryService reportDeliveryService) {
        this.m_reportDeliveryService = reportDeliveryService;
    }

    public ReportdConfigurationDao getReportdConfigurationDao() {
        return this.m_reportConfigurationDao;
    }

    public void setReportdConfigurationDao(ReportdConfigurationDao reportConfigurationDao) {
        this.m_reportConfigurationDao = reportConfigurationDao;
    }
}

