/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.reporting.service;

import java.io.File;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.opennms.javamail.JavaMailerException;
import org.opennms.javamail.JavaSendMailer;
import org.opennms.netmgt.config.javamail.SendmailConfig;
import org.opennms.netmgt.config.reportd.Report;
import org.opennms.netmgt.dao.api.JavaMailConfigurationDao;
import org.opennms.netmgt.reporting.service.ReportDeliveryException;
import org.opennms.netmgt.reporting.service.ReportDeliveryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.MimeMessageHelper;

public class JavaMailDeliveryService
implements ReportDeliveryService {
    private static final Logger LOG = LoggerFactory.getLogger(JavaMailDeliveryService.class);
    JavaMailConfigurationDao m_JavamailConfigDao;

    @Override
    public void deliverReport(Report report, String fileName) throws ReportDeliveryException {
        try {
            String mailer = report.getMailer();
            LOG.debug("deliverReport with mailer={}", (Object)mailer);
            SendmailConfig config = null;
            config = mailer != null && mailer.length() > 0 ? this.m_JavamailConfigDao.getSendMailConfig(mailer) : this.m_JavamailConfigDao.getDefaultSendmailConfig();
            JavaSendMailer sm = new JavaSendMailer(config);
            MimeMessage msg = new MimeMessage(sm.getSession());
            MimeMessageHelper helper = new MimeMessageHelper(msg, true, config.getSendmailProtocol().getCharSet());
            helper.setFrom(config.getSendmailMessage().getFrom());
            helper.setTo(report.getRecipient());
            helper.setSubject("OpenNMS Report: " + report.getReportName());
            if ("text/html".equals(config.getSendmailProtocol().getMessageContentType().toLowerCase())) {
                helper.setText(config.getSendmailMessage().getBody().replaceAll("\\<[^>]*>", ""), config.getSendmailMessage().getBody());
            } else {
                helper.setText(config.getSendmailMessage().getBody());
            }
            helper.addAttachment(fileName, new File(fileName));
            sm.send(msg);
        }
        catch (JavaMailerException e) {
            LOG.error("Problem with JavaMailer {}", (Object)e.getMessage(), (Object)e);
            throw new ReportDeliveryException("Caught JavaMailerException: " + e.getMessage());
        }
        catch (MessagingException e) {
            LOG.error("Problem with Messaging {}", (Object)e.getMessage(), (Object)e);
            throw new ReportDeliveryException("Caught MessagingException: " + e.getMessage());
        }
        catch (Throwable e) {
            LOG.error("Unexpected exception: {}", (Object)e.getMessage(), (Object)e);
            throw new ReportDeliveryException("Caught unexpected " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public JavaMailConfigurationDao getJavamailConfigDao() {
        return this.m_JavamailConfigDao;
    }

    public void setJavamailConfigDao(JavaMailConfigurationDao javamailConfigDao) {
        this.m_JavamailConfigDao = javamailConfigDao;
    }

    @Override
    public void reloadConfiguration() {
        this.m_JavamailConfigDao.reloadConfiguration();
    }
}

