/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.reporting.service;

import java.text.ParseException;
import java.util.Arrays;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.config.reportd.Report;
import org.opennms.netmgt.dao.api.ReportdConfigurationDao;
import org.opennms.netmgt.reporting.service.ReportJob;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.spi.JobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.StringUtils;

public class ReportScheduler
implements InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(ReportScheduler.class);
    protected static final String JOB_GROUP = "Reportd";
    @Autowired
    private ReportdConfigurationDao m_configDao;
    @Autowired
    private Scheduler m_scheduler;
    private JobFactory m_reportJobFactory;
    private Object m_lock = new Object();

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
        try {
            this.getScheduler().setJobFactory(this.getReportJobFactory());
        }
        catch (SchedulerException e) {
            LOG.error("afterPropertiesSet: couldn't set proper JobFactory for scheduler: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    ReportScheduler(Scheduler sched) {
        this.m_scheduler = sched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildReportSchedule() {
        LOG.info("rebuildReportSchedule: obtaining lock...");
        Object object = this.m_lock;
        synchronized (object) {
            LOG.debug("rebuildReportSchedule: lock acquired. reloading configuration...");
            try {
                this.m_configDao.reloadConfiguration();
                LOG.debug("rebuildReportSchedule: removing current report jobs from schedule...");
                this.removeCurrentJobsFromSchedule();
                LOG.debug("rebuildReportSchedule: recreating report schedule based on configuration...");
                this.buildReportSchedule();
                this.printCurrentSchedule();
            }
            catch (DataAccessResourceFailureException e) {
                LOG.error("rebuildReportSchedule: {}", (Object)e.getMessage(), (Object)e);
                throw new IllegalStateException(e);
            }
        }
        LOG.info("rebuildReportSchedule: schedule rebuilt and lock released.");
    }

    private void printCurrentSchedule() {
        try {
            LOG.info("calendarNames: {}", (Object)StringUtils.arrayToCommaDelimitedString((Object[])this.getScheduler().getCalendarNames()));
            LOG.info("current executing jobs: {}", (Object)StringUtils.arrayToCommaDelimitedString((Object[])this.getScheduler().getCurrentlyExecutingJobs().toArray()));
            LOG.info("current job names: {}", (Object)StringUtils.arrayToCommaDelimitedString((Object[])this.getScheduler().getJobNames(JOB_GROUP)));
            LOG.info("scheduler metadata: {}", (Object)this.getScheduler().getMetaData());
            LOG.info("trigger names: {}", (Object)StringUtils.arrayToCommaDelimitedString((Object[])this.getScheduler().getTriggerNames(JOB_GROUP)));
            for (String triggerName : Arrays.asList(this.getScheduler().getTriggerNames(JOB_GROUP))) {
                CronTrigger t = (CronTrigger)this.getScheduler().getTrigger(triggerName, JOB_GROUP);
                StringBuilder sb = new StringBuilder("trigger: ");
                sb.append(triggerName);
                sb.append(", calendar name: ");
                sb.append(t.getCalendarName());
                sb.append(", cron expression: ");
                sb.append(t.getCronExpression());
                sb.append(", URL: ");
                sb.append(t.getJobDataMap().get((Object)"report"));
                sb.append(", next fire time: ");
                sb.append(t.getNextFireTime());
                sb.append(", previous fire time: ");
                sb.append(t.getPreviousFireTime());
                sb.append(", time zone: ");
                sb.append(t.getTimeZone());
                sb.append(", priority: ");
                sb.append(t.getPriority());
                LOG.info(sb.toString());
            }
        }
        catch (Throwable e) {
            LOG.error("printCurrentSchedule: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildReportSchedule() {
        Object object = this.m_lock;
        synchronized (object) {
            for (Report report : this.m_configDao.getReports()) {
                JobDetail detail = null;
                CronTrigger trigger = null;
                try {
                    detail = new JobDetail(report.getReportName(), JOB_GROUP, ReportJob.class, false, false, false);
                    detail.getJobDataMap().put((Object)"report", (Object)report);
                    trigger = new CronTrigger(report.getReportName(), JOB_GROUP, report.getCronSchedule());
                    trigger.setMisfireInstruction(2);
                    this.getScheduler().scheduleJob(detail, (Trigger)trigger);
                }
                catch (ParseException e) {
                    LOG.error("buildReportSchedule: {}", (Object)e.getMessage(), (Object)e);
                }
                catch (SchedulerException e) {
                    LOG.error("buildReportSchedule: {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCurrentJobsFromSchedule() {
        Object object = this.m_lock;
        synchronized (object) {
            try {
                for (String jobName : Arrays.asList(this.m_scheduler.getJobNames(JOB_GROUP))) {
                    this.getScheduler().deleteJob(jobName, JOB_GROUP);
                }
            }
            catch (SchedulerException e) {
                LOG.error("removeCurrentJobsFromSchedule: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public ReportdConfigurationDao getConfigDao() {
        return this.m_configDao;
    }

    public void setConfigDao(ReportdConfigurationDao configDao) {
        this.m_configDao = configDao;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public void setReportJobFactory(JobFactory reportJobFactory) {
        this.m_reportJobFactory = reportJobFactory;
    }

    public JobFactory getReportJobFactory() {
        return this.m_reportJobFactory;
    }

    public void start() throws SchedulerException {
        this.getScheduler().start();
        this.buildReportSchedule();
        this.printCurrentSchedule();
    }

    public void destroy() throws SchedulerException {
        this.getScheduler().shutdown();
    }
}

