/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.RWSConfig;
import org.opennms.netmgt.config.rws.BaseUrl;
import org.opennms.netmgt.config.rws.RwsConfiguration;
import org.opennms.netmgt.config.rws.StandbyUrl;
import org.opennms.rancid.ConnectionProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RWSConfigManager
implements RWSConfig {
    private static final Logger LOG = LoggerFactory.getLogger(RWSConfigManager.class);
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    private int m_cursor = 0;
    private RwsConfiguration m_config;

    public RWSConfigManager() {
    }

    public RWSConfigManager(InputStream stream) throws IOException {
        this.reloadXML(stream);
    }

    @Override
    public Lock getReadLock() {
        return this.m_readLock;
    }

    @Override
    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    @Override
    public ConnectionProperties getBase() {
        try {
            this.getReadLock().lock();
            LOG.debug("Connections used: {}{}", (Object)this.getBaseUrl().getServerUrl(), (Object)this.getBaseUrl().getDirectory());
            LOG.debug("RWS timeout(sec): {}", (Object)this.getBaseUrl().getTimeout());
            if (!this.getBaseUrl().getUsername().isPresent()) {
                ConnectionProperties connectionProperties = new ConnectionProperties(this.getBaseUrl().getServerUrl(), this.getBaseUrl().getDirectory(), this.getBaseUrl().getTimeout().intValue());
                return connectionProperties;
            }
            ConnectionProperties connectionProperties = new ConnectionProperties((String)this.getBaseUrl().getUsername().get(), this.getBaseUrl().getPassword().orElse(""), this.getBaseUrl().getServerUrl(), this.getBaseUrl().getDirectory(), this.getBaseUrl().getTimeout().intValue());
            return connectionProperties;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public ConnectionProperties getNextStandBy() {
        if (!this.hasStandbyUrl()) {
            return null;
        }
        try {
            this.getReadLock().lock();
            StandbyUrl standByUrl = this.getNextStandbyUrl();
            LOG.debug("Connections used: {}{}", (Object)standByUrl.getServerUrl(), (Object)standByUrl.getDirectory());
            LOG.debug("RWS timeout(sec): {}", (Object)standByUrl.getTimeout());
            if (!standByUrl.getUsername().isPresent()) {
                ConnectionProperties connectionProperties = new ConnectionProperties(standByUrl.getServerUrl(), standByUrl.getDirectory(), standByUrl.getTimeout().intValue());
                return connectionProperties;
            }
            ConnectionProperties connectionProperties = new ConnectionProperties((String)standByUrl.getUsername().get(), standByUrl.getPassword().orElse(""), standByUrl.getServerUrl(), standByUrl.getDirectory(), standByUrl.getTimeout().intValue());
            return connectionProperties;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public ConnectionProperties[] getStandBy() {
        return null;
    }

    @Override
    public BaseUrl getBaseUrl() {
        try {
            this.getReadLock().lock();
            BaseUrl baseUrl = this.m_config.getBaseUrl();
            return baseUrl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public List<StandbyUrl> getStandbyUrls() {
        try {
            this.getReadLock().lock();
            List list = this.m_config.getStandbyUrls();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public StandbyUrl getNextStandbyUrl() {
        try {
            this.getReadLock().lock();
            StandbyUrl standbyUrl = null;
            if (this.hasStandbyUrl()) {
                if (this.m_cursor == this.m_config.getStandbyUrls().size()) {
                    this.m_cursor = 0;
                }
                standbyUrl = (StandbyUrl)this.m_config.getStandbyUrls().get(this.m_cursor++);
            }
            StandbyUrl standbyUrl2 = standbyUrl;
            return standbyUrl2;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public boolean hasStandbyUrl() {
        try {
            this.getReadLock().lock();
            boolean bl = this.m_config.getStandbyUrls().size() > 0;
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reloadXML(InputStream stream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(stream);){
            this.getWriteLock().lock();
            this.m_config = (RwsConfiguration)JaxbUtils.unmarshal(RwsConfiguration.class, (Reader)reader);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    public RwsConfiguration getConfiguration() {
        try {
            this.getReadLock().lock();
            RwsConfiguration rwsConfiguration = this.m_config;
            return rwsConfiguration;
        }
        finally {
            this.getReadLock().unlock();
        }
    }
}

