/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.snmp.Definition;
import org.opennms.netmgt.config.snmp.Range;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.events.api.model.IParm;
import org.opennms.netmgt.events.api.model.IValue;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpEventInfo {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpEventInfo.class);
    private String m_firstIPAddress = null;
    private String m_lastIPAddress = null;
    private String m_readCommunityString = null;
    private String m_writeCommunityString = null;
    private int m_timeout = 0;
    private int m_retryCount = 0;
    private String m_version = null;
    private int m_port = 0;
    private int m_securityLevel = 0;
    private String m_securityName = null;
    private int m_maxVarsPerPdu = 0;
    private int m_maxRepetitions = 0;
    private int m_maxRequestSize = 0;
    private String m_authPassPhrase = null;
    private String m_authProtocol = null;
    private String m_privProtocol = null;
    private String m_privPassPhrase = null;
    private String m_engineId = null;
    private String m_contextEngineId = null;
    private String m_contextName = null;
    private String m_enterpriseId = null;
    private String m_proxyHost = null;
    private String m_location = null;
    private Long m_ttl = null;

    private static int computeIntValue(String parmContent) throws IllegalArgumentException {
        int val = 0;
        try {
            val = Integer.parseInt(parmContent);
        }
        catch (NumberFormatException e) {
            LOG.error("computeIntValue: parm value passed in the event isn't a valid number.", (Throwable)e);
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
        return val;
    }

    public SnmpEventInfo() {
    }

    public SnmpEventInfo(IEvent event) {
        String parmName = null;
        IValue parmValue = null;
        String parmContent = null;
        if (!event.getUei().equals("uei.opennms.org/internal/configureSNMP")) {
            throw new IllegalArgumentException("Event is not an a \"configure SNMP\" event: " + event.toString());
        }
        for (IParm parm : event.getParmCollection()) {
            parmName = parm.getParmName();
            parmValue = parm.getValue();
            if (parmValue == null) continue;
            parmContent = parmValue.getContent();
            try {
                if (parmName.equals("firstIPAddress")) {
                    this.setFirstIPAddress(parmContent);
                    continue;
                }
                if (parmName.equals("lastIPAddress")) {
                    this.setLastIPAddress(parmContent);
                    continue;
                }
                if (parmName.equals("location")) {
                    this.setLocation(parmContent);
                    continue;
                }
                if (parmName.equals("communityString") || parmName.equals("readCommunityString")) {
                    this.setReadCommunityString(parmContent);
                    continue;
                }
                if (parmName.equals("writeCommunityString")) {
                    this.setWriteCommunityString(parmContent);
                    continue;
                }
                if (parmName.equals("retryCount")) {
                    this.setRetryCount(SnmpEventInfo.computeIntValue(parmContent));
                    continue;
                }
                if (parmName.equals("timeout")) {
                    this.setTimeout(SnmpEventInfo.computeIntValue(parmContent));
                    continue;
                }
                if (parmName.equals("version")) {
                    this.setVersion(parmContent);
                    continue;
                }
                if (parmName.equals("maxRepetitions")) {
                    this.setMaxRepetitions(SnmpEventInfo.computeIntValue(parmContent));
                    continue;
                }
                if (parmName.equals("maxRequestSize")) {
                    this.setMaxRequestSize(SnmpEventInfo.computeIntValue(parmContent));
                    continue;
                }
                if (parmName.equals("maxVarsPerPdu")) {
                    this.setMaxVarsPerPdu(SnmpEventInfo.computeIntValue(parmContent));
                    continue;
                }
                if (parmName.equals("port")) {
                    this.setPort(SnmpEventInfo.computeIntValue(parmContent));
                    continue;
                }
                if (parmName.equals("authPassphrase")) {
                    this.setAuthPassPhrase(parmContent);
                    continue;
                }
                if (parmName.equals("authProtocol")) {
                    this.setAuthProtocol(parmContent);
                    continue;
                }
                if (parmName.equals("securityLevel")) {
                    this.setSecurityLevel(SnmpEventInfo.computeIntValue(parmContent));
                    continue;
                }
                if (parmName.equals("securityName")) {
                    this.setSecurityName(parmContent);
                    continue;
                }
                if (parmName.equals("engineId")) {
                    this.setEngineId(parmContent);
                    continue;
                }
                if (parmName.equals("enterpriseId")) {
                    this.setEnterpriseId(parmContent);
                    continue;
                }
                if (parmName.equals("contextEngineId")) {
                    this.setContextEngineId(parmContent);
                    continue;
                }
                if (parmName.equals("contextName")) {
                    this.setContextName(parmContent);
                    continue;
                }
                if (parmName.equals("privPassphrase")) {
                    this.setPrivPassPhrase(parmContent);
                    continue;
                }
                if (parmName.equals("privProtocol")) {
                    this.setPrivProtocol(parmContent);
                    continue;
                }
                if (parmName.equals("proxyHost")) {
                    this.setProxyHost(parmContent);
                    continue;
                }
                if (!parmName.equals("ttl")) continue;
                this.setTTL(SnmpEventInfo.computeLongValue(parmContent));
            }
            catch (UnknownHostException e) {
                LOG.error("SnmpEventInfo constructor", (Throwable)e);
                throw new IllegalArgumentException("SnmpEventInfo constructor. " + e.getLocalizedMessage());
            }
            catch (IllegalArgumentException e) {
                LOG.error("SnmpEventInfo constructor", (Throwable)e);
                throw e;
            }
        }
    }

    @Deprecated
    public String getCommunityString() {
        return this.getReadCommunityString();
    }

    @Deprecated
    public void setCommunityString(String communityString) {
        this.setReadCommunityString(communityString);
    }

    public void setReadCommunityString(String readCommunityString) {
        this.m_readCommunityString = readCommunityString;
    }

    public String getReadCommunityString() {
        return this.m_readCommunityString;
    }

    public void setWriteCommunityString(String writeCommunityString) {
        this.m_writeCommunityString = writeCommunityString;
    }

    public String getWriteCommunityString() {
        return this.m_writeCommunityString;
    }

    public String getFirstIPAddress() {
        return this.m_firstIPAddress;
    }

    public void setFirstIPAddress(String firstIPAddress) throws UnknownHostException {
        this.m_firstIPAddress = firstIPAddress;
    }

    public void setFirstIPAddress(InetAddress firstIPAddress) {
        this.m_firstIPAddress = firstIPAddress == null ? null : InetAddressUtils.str((InetAddress)firstIPAddress);
    }

    public String getLastIPAddress() {
        return this.m_lastIPAddress;
    }

    public void setLastIPAddress(String lastIPAddress) throws UnknownHostException {
        if (!StringUtils.isBlank((String)lastIPAddress)) {
            this.m_lastIPAddress = lastIPAddress;
        }
    }

    public void setLastIPAddress(InetAddress lastIPAddress) {
        this.m_lastIPAddress = lastIPAddress == null ? null : InetAddressUtils.str((InetAddress)lastIPAddress);
    }

    public int getMaxVarsPerPdu() {
        return this.m_maxVarsPerPdu;
    }

    public void setMaxVarsPerPdu(int maxVarsPerPdu) {
        this.m_maxVarsPerPdu = maxVarsPerPdu;
    }

    public int getMaxRepetitions() {
        return this.m_maxRepetitions;
    }

    public void setMaxRepetitions(int maxRepetitions) {
        this.m_maxRepetitions = maxRepetitions;
    }

    public String getAuthPassphrase() {
        return this.m_authPassPhrase;
    }

    public void setAuthPassPhrase(String authPassPhrase) {
        this.m_authPassPhrase = authPassPhrase;
    }

    public String getAuthProtocol() {
        return this.m_authProtocol;
    }

    public void setAuthProtocol(String authProtocol) {
        this.m_authProtocol = authProtocol;
    }

    public void setPrivProtocol(String privProtocol) {
        this.m_privProtocol = privProtocol;
    }

    public String getPrivProtocol() {
        return this.m_privProtocol;
    }

    public String getPrivPassPhrase() {
        return this.m_privPassPhrase;
    }

    public void setPrivPassPhrase(String privPassPhrase) {
        this.m_privPassPhrase = privPassPhrase;
    }

    public String getEngineId() {
        return this.m_engineId;
    }

    public void setEngineId(String engineId) {
        this.m_engineId = engineId;
    }

    public String getContextEngineId() {
        return this.m_contextEngineId;
    }

    public void setContextEngineId(String contextEngineId) {
        this.m_contextEngineId = contextEngineId;
    }

    public void setContextName(String contextName) {
        this.m_contextName = contextName;
    }

    public String getContextName() {
        return this.m_contextName;
    }

    public void setEnterpriseId(String enterpriseId) {
        this.m_enterpriseId = enterpriseId;
    }

    public String getEnterpriseId() {
        return this.m_enterpriseId;
    }

    public String getSecurityName() {
        return this.m_securityName;
    }

    public void setSecurityName(String securityName) {
        this.m_securityName = securityName;
    }

    public void setSecurityLevel(int securityLevel) {
        this.m_securityLevel = securityLevel;
    }

    public int getSecurityLevel() {
        return this.m_securityLevel;
    }

    public int getRetryCount() {
        return this.m_retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.m_retryCount = retryCount;
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    public void setTimeout(int timeout) {
        this.m_timeout = timeout;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String version) {
        this.m_version = version;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public int getMaxRequestSize() {
        return this.m_maxRequestSize;
    }

    public void setMaxRequestSize(int maxRequestSize) {
        this.m_maxRequestSize = maxRequestSize;
    }

    public String getProxyHost() {
        return this.m_proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.m_proxyHost = proxyHost;
    }

    public String getLocation() {
        return this.m_location;
    }

    public void setLocation(String location) {
        this.m_location = location;
    }

    public Long getTTL() {
        return this.m_ttl;
    }

    public void setTTL(Long ttl) {
        this.m_ttl = ttl;
    }

    public Range getRange() {
        if (this.isSpecific()) {
            throw new IllegalStateException("Attempted to create range with a specific." + this);
        }
        Range newRange = new Range();
        newRange.setBegin(this.getFirstIPAddress());
        newRange.setEnd(this.getLastIPAddress());
        return newRange;
    }

    public boolean isSpecific() {
        return this.getLastIPAddress() == null || this.getLastIPAddress().equals(this.getFirstIPAddress());
    }

    public Event createEvent(String source) {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/configureSNMP", source);
        bldr.setInterface(InetAddressUtils.addr((String)this.getFirstIPAddress()));
        bldr.setService("SNMP");
        bldr.addParam("firstIPAddress", this.getFirstIPAddress());
        bldr.addParam("lastIPAddress", this.getLastIPAddress());
        if (!StringUtils.isEmpty((String)this.getAuthPassphrase())) {
            bldr.addParam("authPassphrase", this.getAuthPassphrase());
        }
        if (!StringUtils.isEmpty((String)this.getAuthProtocol())) {
            bldr.addParam("authProtocol", this.getAuthProtocol());
        }
        if (!StringUtils.isEmpty((String)this.getContextEngineId())) {
            bldr.addParam("contextEngineId", this.getContextEngineId());
        }
        if (!StringUtils.isEmpty((String)this.getContextName())) {
            bldr.addParam("contextName", this.getContextName());
        }
        if (!StringUtils.isEmpty((String)this.getEngineId())) {
            bldr.addParam("engineId", this.getEngineId());
        }
        if (!StringUtils.isEmpty((String)this.getEnterpriseId())) {
            bldr.addParam("enterpriseId", this.getEnterpriseId());
        }
        if (this.getMaxRepetitions() != 0) {
            bldr.addParam("maxRepetitions", Integer.toString(this.getMaxRepetitions()));
        }
        if (this.getMaxRequestSize() != 0) {
            bldr.addParam("maxRequestSize", Integer.toString(this.getMaxRequestSize()));
        }
        if (this.getMaxVarsPerPdu() != 0) {
            bldr.addParam("maxVarsPerPdu", Integer.toString(this.getMaxVarsPerPdu()));
        }
        if (this.getPort() != 0) {
            bldr.addParam("port", Integer.toString(this.getPort()));
        }
        if (!StringUtils.isEmpty((String)this.getPrivPassPhrase())) {
            bldr.addParam("privPassphrase", this.getPrivPassPhrase());
        }
        if (!StringUtils.isEmpty((String)this.getPrivProtocol())) {
            bldr.addParam("privProtocol", this.getPrivProtocol());
        }
        if (!StringUtils.isEmpty((String)this.getProxyHost())) {
            bldr.addParam("proxyHost", this.getProxyHost());
        }
        if (!StringUtils.isEmpty((String)this.getReadCommunityString())) {
            bldr.addParam("readCommunityString", this.getReadCommunityString());
        }
        if (!StringUtils.isEmpty((String)this.getSecurityName())) {
            bldr.addParam("securityName", this.getSecurityName());
        }
        if (this.getRetryCount() != 0) {
            bldr.addParam("retryCount", Integer.toString(this.getRetryCount()));
        }
        if (this.getSecurityLevel() > 0) {
            bldr.addParam("securityLevel", Integer.toString(this.getSecurityLevel()));
        }
        if (this.getTimeout() != 0) {
            bldr.addParam("timeout", Integer.toString(this.getTimeout()));
        }
        if (!StringUtils.isEmpty((String)this.getVersion())) {
            bldr.addParam("version", this.getVersion());
        }
        if (!StringUtils.isEmpty((String)this.getWriteCommunityString())) {
            bldr.addParam("writeCommunityString", this.getWriteCommunityString());
        }
        if (!StringUtils.isEmpty((String)this.getLocation())) {
            bldr.addParam("location", this.getLocation());
        }
        if (this.getTTL() != null) {
            bldr.addParam("ttl", this.getTTL().longValue());
        }
        return bldr.getEvent();
    }

    public Definition createDef() {
        Definition definition = new Definition();
        if (StringUtils.isNotEmpty((String)this.getVersion())) {
            definition.setVersion(this.getVersion());
        }
        if (this.getRetryCount() != 0) {
            definition.setRetry(Integer.valueOf(this.getRetryCount()));
        }
        if (this.getTimeout() != 0) {
            definition.setTimeout(Integer.valueOf(this.getTimeout()));
        }
        if (this.getPort() != 0) {
            definition.setPort(Integer.valueOf(this.getPort()));
        }
        if (this.getMaxRepetitions() != 0) {
            definition.setMaxRepetitions(Integer.valueOf(this.getMaxRepetitions()));
        }
        if (this.getMaxVarsPerPdu() != 0) {
            definition.setMaxVarsPerPdu(Integer.valueOf(this.getMaxVarsPerPdu()));
        }
        if (this.getMaxRequestSize() != 0) {
            definition.setMaxRequestSize(Integer.valueOf(this.getMaxRequestSize()));
        }
        if (StringUtils.isNotEmpty((String)this.getProxyHost())) {
            definition.setProxyHost(this.getProxyHost());
        }
        if (StringUtils.isNotEmpty((String)this.getLocation())) {
            definition.setLocation(this.getLocation());
        }
        if (this.getTTL() != null) {
            definition.setTTL(this.getTTL());
        }
        if (this.getVersion() != null && this.getVersion().equals("v3")) {
            if (StringUtils.isNotEmpty((String)this.getAuthPassphrase())) {
                definition.setAuthPassphrase(this.getAuthPassphrase());
            }
            if (StringUtils.isNotEmpty((String)this.getAuthProtocol())) {
                definition.setAuthProtocol(this.getAuthProtocol());
            }
            if (StringUtils.isNotEmpty((String)this.getContextEngineId())) {
                definition.setContextEngineId(this.getContextEngineId());
            }
            if (StringUtils.isNotEmpty((String)this.getContextName())) {
                definition.setContextName(this.getContextName());
            }
            if (StringUtils.isNotEmpty((String)this.getEngineId())) {
                definition.setEngineId(this.getEngineId());
            }
            if (StringUtils.isNotEmpty((String)this.getEnterpriseId())) {
                definition.setEnterpriseId(this.getEnterpriseId());
            }
            if (StringUtils.isNotEmpty((String)this.getPrivPassPhrase())) {
                definition.setPrivacyPassphrase(this.getPrivPassPhrase());
            }
            if (StringUtils.isNotEmpty((String)this.getPrivProtocol())) {
                definition.setPrivacyProtocol(this.getPrivProtocol());
            }
            if (StringUtils.isNotEmpty((String)this.getSecurityName())) {
                definition.setSecurityName(this.getSecurityName());
            }
            if (this.getSecurityLevel() > 0) {
                definition.setSecurityLevel(Integer.valueOf(this.getSecurityLevel()));
            }
        } else {
            if (this.getReadCommunityString() != null) {
                definition.setReadCommunity(this.getReadCommunityString());
            }
            if (this.getWriteCommunityString() != null) {
                definition.setWriteCommunity(this.getWriteCommunityString());
            }
        }
        if (this.isSpecific()) {
            definition.addSpecific(this.getFirstIPAddress());
        } else {
            if (BigInteger.ZERO.compareTo(InetAddressUtils.difference((String)this.getFirstIPAddress(), (String)this.getLastIPAddress())) < 0) {
                LOG.error("createDef: Can not create Definition when specified last is < first IP address: {}", (Object)this);
                throw new IllegalArgumentException("First: " + this.getFirstIPAddress() + " is greater than: " + this.getLastIPAddress());
            }
            Range range = new Range();
            range.setBegin(this.getFirstIPAddress());
            range.setEnd(this.getLastIPAddress());
            definition.addRange(range);
        }
        LOG.debug("createDef: created new Definition from: {}", (Object)this);
        return definition;
    }

    private static Long computeLongValue(String parmContent) throws IllegalArgumentException {
        Long val = null;
        if (parmContent != null) {
            try {
                val = Long.parseLong(parmContent);
            }
            catch (NumberFormatException e) {
                LOG.error("computeIntValue: parm value passed in the event isn't a valid number.", (Throwable)e);
                throw new IllegalArgumentException(e.getLocalizedMessage());
            }
        }
        return val;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

