/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.commons.codec.binary.Base64;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.IPLike;
import org.opennms.core.utils.InetAddressComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.AbstractWritableJaxbConfigDao;
import org.opennms.netmgt.config.wmi.WmiAgentConfig;
import org.opennms.netmgt.config.wmi.agent.Definition;
import org.opennms.netmgt.config.wmi.agent.Range;
import org.opennms.netmgt.config.wmi.agent.WmiConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class WmiPeerFactory
extends AbstractWritableJaxbConfigDao<WmiConfig, WmiConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(WmiPeerFactory.class);
    private static WmiPeerFactory m_singleton = null;
    private static boolean m_loaded = false;

    public WmiPeerFactory() {
        super(WmiConfig.class, "WMI peer configuration");
    }

    WmiPeerFactory(String configFile) {
        super(WmiConfig.class, "WMI peer configuration");
        this.setConfigResource((Resource)new FileSystemResource(configFile));
    }

    public WmiPeerFactory(Resource resource) {
        super(WmiConfig.class, "WMI peer configuration");
        this.setConfigResource(resource);
    }

    public static synchronized void init() throws IOException {
        if (m_loaded) {
            return;
        }
        WmiPeerFactory factory = new WmiPeerFactory((Resource)new FileSystemResource(ConfigFileConstants.getFile((int)ConfigFileConstants.WMI_CONFIG_FILE_NAME)));
        factory.afterPropertiesSet();
        WmiPeerFactory.setInstance(factory);
    }

    public static void reload() throws IOException {
        WmiPeerFactory.init();
        WmiPeerFactory.getInstance().update();
    }

    public static WmiPeerFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static void setInstance(WmiPeerFactory instance) {
        m_loaded = true;
        m_singleton = instance;
    }

    public WmiConfig translateConfig(WmiConfig config) {
        return config;
    }

    public WmiConfig getConfig() {
        return (WmiConfig)super.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimize() throws UnknownHostException {
        Definition definition3;
        Iterator definitionsIterator = this.getConfig().getDefinitions().iterator();
        while (definitionsIterator.hasNext()) {
            definition3 = (Definition)definitionsIterator.next();
            if (definition3.getSpecifics().size() != 0 || definition3.getRanges().size() != 0) continue;
            LOG.debug("optimize: Removing empty definition element");
            definitionsIterator.remove();
        }
        definitionsIterator = this.getConfig().getDefinitions().iterator();
        while (definitionsIterator.hasNext()) {
            Definition definition2 = definition3 = (Definition)definitionsIterator.next();
            synchronized (definition2) {
                Iterator rangesIterator = definition3.getRanges().iterator();
                while (rangesIterator.hasNext()) {
                    Range range = (Range)rangesIterator.next();
                    if (!range.getBegin().equals(range.getEnd())) continue;
                    definition3.addSpecific(range.getBegin());
                    rangesIterator.remove();
                }
            }
        }
        for (Definition definition3 : this.getConfig().getDefinitions()) {
            Object specific2;
            TreeMap<InetAddress, String> specificsMap = new TreeMap<InetAddress, String>((Comparator<InetAddress>)new InetAddressComparator());
            for (Object specific2 : definition3.getSpecifics()) {
                specificsMap.put(InetAddressUtils.getInetAddress((String)specific2), ((String)specific2).trim());
            }
            TreeMap<InetAddress, Range> rangesMap = new TreeMap<InetAddress, Range>((Comparator<InetAddress>)new InetAddressComparator());
            specific2 = definition3.getRanges().iterator();
            while (specific2.hasNext()) {
                Range range = (Range)specific2.next();
                rangesMap.put(InetAddressUtils.getInetAddress((String)range.getBegin()), range);
            }
            InetAddress priorSpecific = null;
            Range addedRange = null;
            for (InetAddress specific3 : specificsMap.keySet()) {
                if (priorSpecific == null) {
                    priorSpecific = specific3;
                    continue;
                }
                if (BigInteger.ONE.equals(InetAddressUtils.difference((InetAddress)specific3, (InetAddress)priorSpecific)) && InetAddressUtils.inSameScope((InetAddress)specific3, (InetAddress)priorSpecific)) {
                    if (addedRange == null) {
                        addedRange = new Range();
                        addedRange.setBegin(InetAddressUtils.toIpAddrString((InetAddress)priorSpecific));
                        rangesMap.put(priorSpecific, addedRange);
                        specificsMap.remove(priorSpecific);
                    }
                    addedRange.setEnd(InetAddressUtils.toIpAddrString((InetAddress)specific3));
                    specificsMap.remove(specific3);
                } else {
                    addedRange = null;
                }
                priorSpecific = specific3;
            }
            block10: for (InetAddress specific3 : new ArrayList(specificsMap.keySet())) {
                for (InetAddress begin : new ArrayList(rangesMap.keySet())) {
                    Range range;
                    InetAddress end;
                    if (!InetAddressUtils.inSameScope((InetAddress)begin, (InetAddress)specific3) || InetAddressUtils.toInteger((InetAddress)begin).subtract(BigInteger.ONE).compareTo(InetAddressUtils.toInteger((InetAddress)specific3)) > 0 || InetAddressUtils.toInteger((InetAddress)(end = InetAddressUtils.getInetAddress((String)(range = (Range)rangesMap.get(begin)).getEnd()))).add(BigInteger.ONE).compareTo(InetAddressUtils.toInteger((InetAddress)specific3)) < 0) continue;
                    if (InetAddressUtils.toInteger((InetAddress)specific3).compareTo(InetAddressUtils.toInteger((InetAddress)begin)) >= 0 && InetAddressUtils.toInteger((InetAddress)specific3).compareTo(InetAddressUtils.toInteger((InetAddress)end)) <= 0) {
                        specificsMap.remove(specific3);
                        continue block10;
                    }
                    if (InetAddressUtils.toInteger((InetAddress)begin).subtract(BigInteger.ONE).equals(InetAddressUtils.toInteger((InetAddress)specific3))) {
                        rangesMap.remove(begin);
                        rangesMap.put(specific3, range);
                        range.setBegin(InetAddressUtils.toIpAddrString((InetAddress)specific3));
                        specificsMap.remove(specific3);
                        continue block10;
                    }
                    if (!InetAddressUtils.toInteger((InetAddress)end).add(BigInteger.ONE).equals(InetAddressUtils.toInteger((InetAddress)specific3))) continue;
                    range.setEnd(InetAddressUtils.toIpAddrString((InetAddress)specific3));
                    specificsMap.remove(specific3);
                    continue block10;
                }
            }
            Range priorRange = null;
            InetAddress priorBegin = null;
            InetAddress priorEnd = null;
            Iterator rangesIterator = rangesMap.keySet().iterator();
            while (rangesIterator.hasNext()) {
                InetAddress beginAddress = (InetAddress)rangesIterator.next();
                Range range = (Range)rangesMap.get(beginAddress);
                InetAddress endAddress = InetAddressUtils.getInetAddress((String)range.getEnd());
                if (priorRange != null && InetAddressUtils.inSameScope((InetAddress)beginAddress, priorEnd) && InetAddressUtils.difference((InetAddress)beginAddress, (InetAddress)priorEnd).compareTo(BigInteger.ONE) <= 0) {
                    priorBegin = new InetAddressComparator().compare(priorBegin, beginAddress) < 0 ? priorBegin : beginAddress;
                    priorRange.setBegin(InetAddressUtils.toIpAddrString((InetAddress)priorBegin));
                    priorEnd = new InetAddressComparator().compare(priorEnd, endAddress) > 0 ? priorEnd : endAddress;
                    priorRange.setEnd(InetAddressUtils.toIpAddrString((InetAddress)priorEnd));
                    rangesIterator.remove();
                    continue;
                }
                priorRange = range;
                priorBegin = beginAddress;
                priorEnd = endAddress;
            }
            definition3.setSpecifics(new ArrayList(specificsMap.values()));
            definition3.setRanges(new ArrayList(rangesMap.values()));
        }
    }

    public synchronized WmiAgentConfig getAgentConfig(InetAddress agentInetAddress) {
        if (this.getConfig() == null) {
            return new WmiAgentConfig(agentInetAddress);
        }
        WmiAgentConfig agentConfig = new WmiAgentConfig(agentInetAddress);
        this.setWmiAgentConfig(agentConfig, new Definition());
        block0: for (Definition def : this.getConfig().getDefinitions()) {
            for (String saddr : def.getSpecifics()) {
                InetAddress addr = InetAddressUtils.addr((String)saddr);
                if (!addr.equals(agentConfig.getAddress())) continue;
                this.setWmiAgentConfig(agentConfig, def);
                break block0;
            }
            for (Range rng : def.getRanges()) {
                if (!InetAddressUtils.isInetAddressInRange((String)InetAddressUtils.str((InetAddress)agentConfig.getAddress()), (String)rng.getBegin(), (String)rng.getEnd())) continue;
                this.setWmiAgentConfig(agentConfig, def);
                break block0;
            }
            for (String ipMatch : def.getIpMatches()) {
                if (!IPLike.matches((String)InetAddressUtils.str((InetAddress)agentInetAddress), (String)ipMatch)) continue;
                this.setWmiAgentConfig(agentConfig, def);
                break block0;
            }
        }
        if (agentConfig == null) {
            Definition def;
            def = new Definition();
            this.setWmiAgentConfig(agentConfig, def);
        }
        return agentConfig;
    }

    private void setWmiAgentConfig(WmiAgentConfig agentConfig, Definition def) {
        this.setCommonAttributes(agentConfig, def);
        agentConfig.setPassword(this.determinePassword(def));
    }

    private void setCommonAttributes(WmiAgentConfig agentConfig, Definition def) {
        agentConfig.setRetries(this.determineRetries(def));
        agentConfig.setTimeout((int)this.determineTimeout(def));
        agentConfig.setUsername(this.determineUsername(def));
        agentConfig.setPassword(this.determinePassword(def));
        agentConfig.setDomain(this.determineDomain(def));
    }

    private String determineUsername(Definition def) {
        return def.getUsername().orElse(this.getConfig().getUsername().orElse("Administrator"));
    }

    private String determineDomain(Definition def) {
        return def.getDomain().orElse(this.getConfig().getDomain().orElse("WORKGROUP"));
    }

    private String determinePassword(Definition def) {
        String literalPass = def.getPassword().orElse(this.getConfig().getPassword().orElse(""));
        if (literalPass.endsWith("===")) {
            return new String(Base64.decodeBase64((String)literalPass));
        }
        return literalPass;
    }

    private long determineTimeout(Definition def) {
        return (def.getTimeout() == 0 ? this.getConfig().getTimeout().orElse(3000) : def.getTimeout()).intValue();
    }

    private int determineRetries(Definition def) {
        return def.getRetry() == 0 ? this.getConfig().getRetry().orElse(1).intValue() : def.getRetry().intValue();
    }
}

