/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.config.ChartConfigManager;

public class ChartConfigFactory
extends ChartConfigManager {
    private static boolean m_initialized = false;
    private static ChartConfigFactory m_instance = null;
    private static File m_chartConfigFile;
    private static long m_lastModified;

    public static synchronized void init() throws FileNotFoundException, IOException {
        if (!m_initialized) {
            m_instance = new ChartConfigFactory();
            ChartConfigFactory.reload();
            m_initialized = true;
        }
    }

    public static synchronized void reload() throws IOException, FileNotFoundException {
        m_chartConfigFile = ConfigFileConstants.getFile((int)ConfigFileConstants.CHART_CONFIG_FILE_NAME);
        FileInputStream configIn = null;
        try {
            configIn = new FileInputStream(m_chartConfigFile);
            m_lastModified = m_chartConfigFile.lastModified();
            ChartConfigFactory.parseXml(configIn);
        }
        finally {
            if (configIn != null) {
                IOUtils.closeQuietly((InputStream)configIn);
            }
        }
    }

    @Override
    protected void saveXml(String xml) throws IOException {
        if (xml != null) {
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(m_chartConfigFile), "UTF-8");
            fileWriter.write(xml);
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
    }

    @Override
    public void update() throws IOException {
        if (m_lastModified != m_chartConfigFile.lastModified()) {
            ChartConfigFactory.reload();
        }
    }

    public static ChartConfigFactory getInstance() {
        if (!m_initialized) {
            throw new IllegalStateException("Factory not initialized");
        }
        return m_instance;
    }

    public static void setInstance(ChartConfigFactory instance) {
        m_instance = instance;
        m_initialized = true;
    }
}

