/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.config.syslogd.HideMatch;
import org.opennms.netmgt.config.syslogd.HideMessage;
import org.opennms.netmgt.config.syslogd.SyslogdConfiguration;
import org.opennms.netmgt.config.syslogd.SyslogdConfigurationGroup;
import org.opennms.netmgt.config.syslogd.UeiList;
import org.opennms.netmgt.config.syslogd.UeiMatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public final class SyslogdConfigFactory
implements SyslogdConfig {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogdConfigFactory.class);
    private SyslogdConfiguration m_config;

    public SyslogdConfigFactory() throws IOException, MarshalException, ValidationException {
        File configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SYSLOGD_CONFIG_FILE_NAME);
        this.m_config = (SyslogdConfiguration)CastorUtils.unmarshal(SyslogdConfiguration.class, (Resource)new FileSystemResource(configFile));
        this.parseIncludedFiles();
    }

    public SyslogdConfigFactory(InputStream stream) throws IOException, MarshalException, ValidationException {
        this.m_config = (SyslogdConfiguration)CastorUtils.unmarshal(SyslogdConfiguration.class, (InputStream)stream);
        this.parseIncludedFiles();
    }

    public synchronized void reload() throws IOException, MarshalException, ValidationException {
        File configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SYSLOGD_CONFIG_FILE_NAME);
        this.m_config = (SyslogdConfiguration)CastorUtils.unmarshal(SyslogdConfiguration.class, (Resource)new FileSystemResource(configFile));
        this.parseIncludedFiles();
    }

    @Override
    public synchronized int getSyslogPort() {
        return this.m_config.getConfiguration().getSyslogPort();
    }

    @Override
    public synchronized String getListenAddress() {
        return this.m_config.getConfiguration().getListenAddress();
    }

    @Override
    public synchronized boolean getNewSuspectOnMessage() {
        return this.m_config.getConfiguration().getNewSuspectOnMessage();
    }

    @Override
    public synchronized String getForwardingRegexp() {
        return this.m_config.getConfiguration().getForwardingRegexp();
    }

    @Override
    public synchronized int getMatchingGroupHost() {
        return this.m_config.getConfiguration().getMatchingGroupHost();
    }

    @Override
    public synchronized int getMatchingGroupMessage() {
        return this.m_config.getConfiguration().getMatchingGroupMessage();
    }

    @Override
    public synchronized String getParser() {
        return this.m_config.getConfiguration().getParser();
    }

    @Override
    public synchronized UeiList getUeiList() {
        return this.m_config.getUeiList();
    }

    @Override
    public synchronized HideMessage getHideMessages() {
        return this.m_config.getHideMessage();
    }

    @Override
    public synchronized String getDiscardUei() {
        return this.m_config.getConfiguration().getDiscardUei();
    }

    @Override
    public int getNumThreads() {
        if (this.m_config.getConfiguration().hasThreads()) {
            return this.m_config.getConfiguration().getThreads();
        }
        return Runtime.getRuntime().availableProcessors() * 2;
    }

    @Override
    public int getQueueSize() {
        return this.m_config.getConfiguration().getQueueSize();
    }

    @Override
    public int getBatchSize() {
        return this.m_config.getConfiguration().getBatchSize();
    }

    @Override
    public int getBatchIntervalMs() {
        return this.m_config.getConfiguration().getBatchInterval();
    }

    private void parseIncludedFiles() throws IOException, MarshalException, ValidationException {
        File configDir;
        try {
            configDir = ConfigFileConstants.getFile((int)ConfigFileConstants.SYSLOGD_CONFIG_FILE_NAME).getParentFile();
        }
        catch (Throwable t) {
            LOG.warn("Error getting default syslogd configuration location. <import-file> directives will be ignored.  This should really only happen in unit tests.");
            return;
        }
        for (String fileName : this.m_config.getImportFileCollection()) {
            File configFile = new File(configDir, fileName);
            SyslogdConfigurationGroup includeCfg = (SyslogdConfigurationGroup)CastorUtils.unmarshal(SyslogdConfigurationGroup.class, (Resource)new FileSystemResource(configFile));
            if (includeCfg.getUeiList() != null) {
                for (UeiMatch ueiMatch : includeCfg.getUeiList().getUeiMatchCollection()) {
                    if (this.m_config.getUeiList() == null) {
                        this.m_config.setUeiList(new UeiList());
                    }
                    this.m_config.getUeiList().addUeiMatch(ueiMatch);
                }
            }
            if (includeCfg.getHideMessage() == null) continue;
            for (HideMatch hideMatch : includeCfg.getHideMessage().getHideMatchCollection()) {
                if (this.m_config.getHideMessage() == null) {
                    this.m_config.setHideMessage(new HideMessage());
                }
                this.m_config.getHideMessage().addHideMatch(hideMatch);
            }
        }
    }
}

