/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.network.IpListFromUrl;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.threshd.ExcludeRange;
import org.opennms.netmgt.config.threshd.Package;
import org.opennms.netmgt.config.threshd.Service;
import org.opennms.netmgt.config.threshd.ThreshdConfiguration;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ThreshdConfigManager {
    private static final Logger LOG = LoggerFactory.getLogger(ThreshdConfigManager.class);
    protected ThreshdConfiguration m_config;
    private Map<String, List<String>> m_urlIPMap;
    private Map<Package, List<InetAddress>> m_pkgIpMap;
    protected boolean m_verifyServer;
    protected String m_localServer;

    public ThreshdConfigManager(InputStream stream, String localServer, boolean verifyServer) throws MarshalException, ValidationException {
        this.m_config = (ThreshdConfiguration)CastorUtils.unmarshal(ThreshdConfiguration.class, (InputStream)stream);
        this.createUrlIpMap();
        this.m_verifyServer = verifyServer;
        this.m_localServer = localServer;
        this.createPackageIpListMap();
    }

    protected void createUrlIpMap() {
        this.m_urlIPMap = new HashMap<String, List<String>>();
        for (Package pkg : this.m_config.getPackageCollection()) {
            for (String urlname : pkg.getIncludeUrlCollection()) {
                List iplist = IpListFromUrl.fetch((String)urlname);
                if (iplist.size() <= 0) continue;
                this.m_urlIPMap.put(urlname, iplist);
            }
        }
    }

    protected void createPackageIpListMap() {
        this.m_pkgIpMap = new HashMap<Package, List<InetAddress>>();
        Enumeration pkgEnum = this.m_config.enumeratePackage();
        while (pkgEnum.hasMoreElements()) {
            Package pkg = (Package)pkgEnum.nextElement();
            StringBuffer filterRules = new StringBuffer(pkg.getFilter().getContent());
            try {
                if (this.m_verifyServer) {
                    filterRules.append(" & (serverName == ");
                    filterRules.append('\"');
                    filterRules.append(this.m_localServer);
                    filterRules.append('\"');
                    filterRules.append(")");
                }
                LOG.debug("createPackageIpMap: package is {}. filer rules are {}", (Object)filterRules, (Object)pkg.getName());
                FilterDaoFactory.getInstance().flushActiveIpAddressListCache();
                List ipList = FilterDaoFactory.getInstance().getActiveIPAddressList(filterRules.toString());
                if (ipList.size() <= 0) continue;
                this.m_pkgIpMap.put(pkg, ipList);
            }
            catch (Throwable t) {
                LOG.error("createPackageIpMap: failed to map package: {} to an IP List with filter \"{}\"", new Object[]{pkg.getName(), pkg.getFilter().getContent(), t});
            }
        }
    }

    public synchronized void rebuildPackageIpListMap() {
        this.createPackageIpListMap();
    }

    public synchronized void saveCurrent() throws MarshalException, IOException, ValidationException {
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)this.m_config, (Writer)stringWriter);
        String xmlString = stringWriter.toString();
        if (xmlString != null) {
            this.saveXML(xmlString);
        }
        this.reloadXML();
    }

    public abstract void reloadXML() throws IOException, MarshalException, ValidationException;

    protected abstract void saveXML(String var1) throws IOException;

    public synchronized ThreshdConfiguration getConfiguration() {
        return this.m_config;
    }

    public synchronized Package getPackage(String name) {
        for (Package thisPackage : this.m_config.getPackageCollection()) {
            if (!thisPackage.getName().equals(name)) continue;
            return thisPackage;
        }
        return null;
    }

    private boolean interfaceInUrl(String addr, String url) {
        boolean bRet = false;
        List<String> iplist = this.m_urlIPMap.get(url);
        if (iplist != null && iplist.size() > 0) {
            bRet = iplist.contains(addr);
        }
        return bRet;
    }

    public synchronized boolean interfaceInPackage(String iface, Package pkg) {
        InetAddress ifaceAddr = InetAddressUtils.addr((String)iface);
        boolean filterPassed = false;
        List<InetAddress> ipList = this.m_pkgIpMap.get(pkg);
        if (ipList != null && ipList.size() > 0) {
            filterPassed = ipList.contains(ifaceAddr);
        }
        LOG.debug("interfaceInPackage: Interface {} passed filter for package {}?: {}", new Object[]{filterPassed, iface, pkg.getName()});
        if (!filterPassed) {
            return false;
        }
        boolean has_specific = false;
        boolean has_range_include = false;
        boolean has_range_exclude = false;
        has_range_include = pkg.getIncludeRangeCount() == 0 && pkg.getSpecificCount() == 0;
        for (Object rng : pkg.getIncludeRangeCollection()) {
            if (!InetAddressUtils.isInetAddressInRange((String)iface, (String)rng.getBegin(), (String)rng.getEnd())) continue;
            has_range_include = true;
            break;
        }
        byte[] addr = InetAddressUtils.toIpAddrBytes((String)iface);
        for (String spec : pkg.getSpecificCollection()) {
            byte[] speca = InetAddressUtils.toIpAddrBytes((String)spec);
            if (new ByteArrayComparator().compare(speca, addr) != 0) continue;
            has_specific = true;
            break;
        }
        Enumeration eurl = pkg.enumerateIncludeUrl();
        while (!has_specific && eurl.hasMoreElements()) {
            has_specific = this.interfaceInUrl(iface, (String)eurl.nextElement());
        }
        for (ExcludeRange rng : pkg.getExcludeRangeCollection()) {
            if (!InetAddressUtils.isInetAddressInRange((String)iface, (String)rng.getBegin(), (String)rng.getEnd())) continue;
            has_range_exclude = true;
            break;
        }
        return has_specific || has_range_include && !has_range_exclude;
    }

    public synchronized boolean serviceInPackageAndEnabled(String svcName, Package pkg) {
        boolean result = false;
        for (Service tsvc : pkg.getServiceCollection()) {
            String status;
            if (!tsvc.getName().equalsIgnoreCase(svcName) || !(status = tsvc.getStatus()).equals("on")) continue;
            result = true;
            break;
        }
        return result;
    }
}

