/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opennms.core.network.IpListFromUrl;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.BasicScheduleUtils;
import org.opennms.netmgt.config.RancidAdapterConfig;
import org.opennms.netmgt.config.rancid.adapter.ExcludeRange;
import org.opennms.netmgt.config.rancid.adapter.Mapping;
import org.opennms.netmgt.config.rancid.adapter.Package;
import org.opennms.netmgt.config.rancid.adapter.Policies;
import org.opennms.netmgt.config.rancid.adapter.PolicyManage;
import org.opennms.netmgt.config.rancid.adapter.RancidConfiguration;
import org.opennms.netmgt.config.rancid.adapter.Schedule;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RancidAdapterConfigManager
implements RancidAdapterConfig {
    private static final Logger LOG = LoggerFactory.getLogger(RancidAdapterConfigManager.class);
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    private RancidConfiguration m_config;
    private static boolean m_verifyServer;
    private static String m_localServer;
    private Map<String, List<String>> m_urlIPMap;
    private Map<Package, List<InetAddress>> m_pkgIpMap;
    private Map<Package, PolicyManage> m_pkgPolicyMap;

    public RancidAdapterConfigManager(InputStream reader, String serverName, boolean verifyServer) throws IOException {
        m_localServer = serverName;
        m_verifyServer = verifyServer;
        this.reloadXML(reader);
    }

    public RancidAdapterConfigManager() {
    }

    public Lock getReadLock() {
        return this.m_readLock;
    }

    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reloadXML(InputStream is) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(is);){
            this.getWriteLock().lock();
            this.m_config = (RancidConfiguration)JaxbUtils.unmarshal(RancidConfiguration.class, (Reader)reader);
            this.createPolicyNamePkgMap();
            this.createUrlIpMap();
            this.createPackageIpListMap();
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    private void createPolicyNamePkgMap() {
        this.m_pkgPolicyMap = new HashMap<Package, PolicyManage>();
        if (this.hasPolicies()) {
            for (PolicyManage pm : this.policies()) {
                this.m_pkgPolicyMap.put(pm.getPackage(), pm);
            }
        }
    }

    private void createUrlIpMap() {
        this.m_urlIPMap = new HashMap<String, List<String>>();
        if (this.hasPolicies()) {
            for (Package pkg : this.packages()) {
                for (String url : this.includeURLs(pkg)) {
                    List iplist = IpListFromUrl.fetch((String)url);
                    if (iplist.size() <= 0) continue;
                    this.m_urlIPMap.put(url, iplist);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPackageIpListMap() {
        try {
            this.getWriteLock().lock();
            this.m_pkgIpMap = new HashMap<Package, List<InetAddress>>();
            if (this.hasPolicies()) {
                for (Package pkg : this.packages()) {
                    try {
                        List<InetAddress> ipList = this.getIpList(pkg);
                        LOG.debug("createPackageIpMap: package {}: ipList size = {}", (Object)pkg.getName(), (Object)ipList.size());
                        if (ipList.size() <= 0) continue;
                        this.m_pkgIpMap.put(pkg, ipList);
                    }
                    catch (Throwable t) {
                        LOG.error("createPackageIpMap: failed to map package: {} to an IP List with filter \"{}\"", new Object[]{pkg.getName(), pkg.getFilter().getContent(), t});
                    }
                }
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    private List<InetAddress> getIpList(Package pkg) {
        StringBuffer filterRules = new StringBuffer(pkg.getFilter().getContent());
        if (m_verifyServer) {
            filterRules.append(" & (serverName == ");
            filterRules.append('\"');
            filterRules.append(m_localServer);
            filterRules.append('\"');
            filterRules.append(")");
        }
        LOG.debug("createPackageIpMap: package is {}. filter rules are {}", (Object)pkg.getName(), (Object)filterRules);
        FilterDaoFactory.getInstance().flushActiveIpAddressListCache();
        return FilterDaoFactory.getInstance().getActiveIPAddressList(filterRules.toString());
    }

    private boolean interfaceInPackage(String iface, Package pkg) {
        boolean filterPassed = false;
        InetAddress ifaceAddr = InetAddressUtils.addr((String)iface);
        List<InetAddress> ipList = this.m_pkgIpMap.get(pkg);
        if (ipList != null && ipList.size() > 0) {
            filterPassed = ipList.contains(ifaceAddr);
        }
        LOG.debug("interfaceInPackage: Interface {} passed filter for package {}?: {}", new Object[]{iface, pkg.getName(), filterPassed});
        if (!filterPassed) {
            return false;
        }
        boolean has_specific = false;
        boolean has_range_include = false;
        boolean has_range_exclude = false;
        has_range_include = pkg.getIncludeRanges().size() == 0 && pkg.getSpecifics().size() == 0;
        for (Object rng : pkg.getIncludeRanges()) {
            if (!InetAddressUtils.isInetAddressInRange((String)iface, (String)rng.getBegin(), (String)rng.getEnd())) continue;
            has_range_include = true;
            break;
        }
        byte[] addr = InetAddressUtils.toIpAddrBytes((String)iface);
        for (String spec : pkg.getSpecifics()) {
            byte[] speca = InetAddressUtils.toIpAddrBytes((String)spec);
            if (new ByteArrayComparator().compare(speca, addr) != 0) continue;
            has_specific = true;
            break;
        }
        Iterator eurl = pkg.getIncludeUrls().iterator();
        while (!has_specific && eurl.hasNext()) {
            has_specific = this.interfaceInUrl(iface, (String)eurl.next());
        }
        for (ExcludeRange rng : pkg.getExcludeRanges()) {
            if (!InetAddressUtils.isInetAddressInRange((String)iface, (String)rng.getBegin(), (String)rng.getEnd())) continue;
            has_range_exclude = true;
            break;
        }
        return has_specific || has_range_include && !has_range_exclude;
    }

    private boolean interfaceInUrl(String addr, String url) {
        boolean bRet = false;
        List<String> iplist = this.m_urlIPMap.get(url);
        if (iplist != null && iplist.size() > 0) {
            bRet = iplist.contains(addr);
        }
        return bRet;
    }

    private List<String> getAllPackageMatches(String ipaddr) {
        ArrayList<String> matchingPkgs = new ArrayList<String>();
        for (Package pkg : this.packages()) {
            if (!this.interfaceInPackage(ipaddr, pkg)) continue;
            matchingPkgs.add(pkg.getName());
        }
        return matchingPkgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDelay(String ipaddr) {
        try {
            this.getReadLock().lock();
            if (this.hasPolicyManage(ipaddr) && this.getPolicyManageWithoutTesting(ipaddr).getDelay().isPresent()) {
                long l = (Long)this.getPolicyManageWithoutTesting(ipaddr).getDelay().get();
                return l;
            }
            long l = this.getConfiguration().getDelay();
            return l;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public int getRetries(String ipaddr) {
        try {
            this.getReadLock().lock();
            if (this.hasPolicyManage(ipaddr) && this.getPolicyManage(ipaddr).getRetries().isPresent()) {
                int n = (Integer)this.getPolicyManageWithoutTesting(ipaddr).getRetries().get();
                return n;
            }
            int n = this.getConfiguration().getRetries();
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public boolean useCategories(String ipaddr) {
        try {
            this.getReadLock().lock();
            if (this.hasPolicyManage(ipaddr) && this.getPolicyManage(ipaddr).getUseCategories().isPresent()) {
                boolean bl = (Boolean)this.getPolicyManageWithoutTesting(ipaddr).getUseCategories().get();
                return bl;
            }
            boolean bl = this.getConfiguration().getUseCategories();
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getType(String sysoid, String sysdescr) {
        LOG.debug("getType: sysoid: {}", (Object)sysoid);
        LOG.debug("getType: sysdescription: {}", (Object)sysdescr);
        this.getReadLock().lock();
        try {
            String type = this.getConfiguration().getDefaultType();
            boolean notMatched = true;
            if (sysoid != null && sysdescr != null) {
                for (Mapping map : this.mappings()) {
                    LOG.debug("getType: parsing map with SysoidMaSk: {}, SysdescrMatch: {}", (Object)map.getSysoidMask(), map.getSysdescrMatch().orElse(null));
                    if (!sysoid.startsWith(map.getSysoidMask())) continue;
                    if (map.getSysdescrMatch().isPresent() && sysdescr.matches((String)map.getSysdescrMatch().get())) {
                        LOG.debug("getType: matched type: {}", (Object)map.getType());
                        String string = map.getType();
                        return string;
                    }
                    if (map.getSysdescrMatch().isPresent() || !notMatched) continue;
                    LOG.debug("getType: null sysdescrmatch: first match: type: {} ", (Object)map.getType());
                    type = map.getType();
                    notMatched = false;
                }
            } else if (sysoid != null) {
                for (Mapping map : this.mappings()) {
                    LOG.debug("getType: sysdescr is null: parsing map with SysoidMaSk: {} ", (Object)map.getSysoidMask());
                    if (!sysoid.startsWith(map.getSysoidMask())) continue;
                    LOG.debug("getType: matched type: {} ", (Object)map.getType());
                    String string = map.getType();
                    return string;
                }
            }
            LOG.debug("getType: matched type: {}", (Object)type);
            String string = type;
            return string;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCurTimeInSchedule(String ipaddr) {
        try {
            this.getReadLock().lock();
            if (this.hasSchedule(ipaddr)) {
                GregorianCalendar cal = new GregorianCalendar();
                for (Schedule schedule : this.getSchedules(ipaddr)) {
                    if (!this.isTimeInSchedule(cal, schedule)) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    private boolean isTimeInSchedule(Calendar cal, Schedule schedule) {
        return BasicScheduleUtils.isTimeInSchedule(cal, BasicScheduleUtils.getRancidSchedule(schedule));
    }

    private boolean hasPolicies() {
        return this.getConfiguration().getPolicies().isPresent();
    }

    private boolean hasPolicyManage(String ipaddress) {
        return this.getAllPackageMatches(ipaddress).size() > 0;
    }

    private PolicyManage getPolicyManage(String ipaddr) {
        if (this.hasPolicyManage(ipaddr)) {
            return this.getPolicyManageWithoutTesting(ipaddr);
        }
        return null;
    }

    private PolicyManage getPolicyManageWithoutTesting(String ipaddr) {
        String pkgname = this.getAllPackageMatches(ipaddr).get(0);
        for (Map.Entry<Package, PolicyManage> entry : this.m_pkgPolicyMap.entrySet()) {
            if (!entry.getKey().getName().equals(pkgname)) continue;
            return entry.getValue();
        }
        return null;
    }

    public boolean hasSchedule(String ipaddress) {
        try {
            this.getReadLock().lock();
            if (this.hasPolicyManage(ipaddress)) {
                boolean bl = this.getPolicyManageWithoutTesting(ipaddress).getSchedules().size() > 0;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public List<Schedule> getSchedules(String ipaddress) {
        try {
            this.getReadLock().lock();
            if (this.hasPolicyManage(ipaddress)) {
                List list = this.getPolicyManageWithoutTesting(ipaddress).getSchedules();
                return list;
            }
            ArrayList<Schedule> arrayList = new ArrayList<Schedule>();
            return arrayList;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Package> packages() {
        try {
            this.getReadLock().lock();
            ArrayList<Package> pkgs = new ArrayList<Package>();
            if (this.hasPolicies()) {
                for (PolicyManage pm : this.policies()) {
                    pkgs.add(pm.getPackage());
                }
            }
            ArrayList<Package> arrayList = pkgs;
            return arrayList;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public Iterable<Mapping> mappings() {
        try {
            this.getReadLock().lock();
            List list = this.getConfiguration().getMappings();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public Iterable<PolicyManage> policies() {
        try {
            this.getReadLock().lock();
            if (this.getConfiguration().getPolicies().isPresent()) {
                List list = ((Policies)this.getConfiguration().getPolicies().get()).getPolicyManages();
                return list;
            }
            List<PolicyManage> list = Collections.emptyList();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public Iterable<String> includeURLs(Package pkg) {
        try {
            this.getReadLock().lock();
            List list = pkg.getIncludeUrls();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public RancidConfiguration getConfiguration() {
        try {
            this.getReadLock().lock();
            RancidConfiguration rancidConfiguration = this.m_config;
            return rancidConfiguration;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public void rebuildPackageIpListMap() {
        this.createPackageIpListMap();
    }
}

