/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.RWSConfig;
import org.opennms.netmgt.config.RancidAdapterConfig;
import org.opennms.netmgt.config.RancidAdapterConfigFactory;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.provision.ProvisioningAdapterException;
import org.opennms.netmgt.provision.SimpleQueuedProvisioningAdapter;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.rancid.ConnectionProperties;
import org.opennms.rancid.RWSClientApi;
import org.opennms.rancid.RancidApiException;
import org.opennms.rancid.RancidNode;
import org.opennms.rancid.RancidNodeAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

@EventListener(name="RancidProvisioningAdapter")
public class RancidProvisioningAdapter
extends SimpleQueuedProvisioningAdapter
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(RancidProvisioningAdapter.class);
    private NodeDao m_nodeDao;
    private volatile EventForwarder m_eventForwarder;
    private RWSConfig m_rwsConfig;
    private RancidAdapterConfig m_rancidAdapterConfig;
    private ConnectionProperties m_cp;
    private List<String> m_rancid_categories;
    private TransactionTemplate m_template;
    private static final String MESSAGE_PREFIX = "Rancid provisioning failed: ";
    private static final String ADAPTER_NAME = "RancidProvisioningAdapter";
    private static final String RANCID_COMMENT = "node provisioned by opennms";
    public static final String NAME = "RancidProvisioningAdapter";
    private static volatile ConcurrentMap<Integer, RancidNode> m_onmsNodeRancidNodeMap;
    private static volatile ConcurrentMap<Integer, String> m_onmsNodeIpMap;

    public void setTemplate(TransactionTemplate template) {
        this.m_template = template;
    }

    SimpleQueuedProvisioningAdapter.AdapterOperationSchedule createScheduleForNode(int nodeId, SimpleQueuedProvisioningAdapter.AdapterOperationType adapterOperationType) {
        LOG.debug("Scheduling: {} for nodeid: {}", (Object)nodeId, (Object)adapterOperationType);
        if (adapterOperationType.equals((Object)SimpleQueuedProvisioningAdapter.AdapterOperationType.CONFIG_CHANGE)) {
            this.updateRancidNodeState(nodeId, true);
            String ipaddress = (String)m_onmsNodeIpMap.get(nodeId);
            LOG.debug("Found Suitable ip address: {}", (Object)ipaddress);
            long initialDelay = this.m_rancidAdapterConfig.getDelay(ipaddress);
            int retries = this.m_rancidAdapterConfig.getRetries(ipaddress);
            LOG.debug("Setting initialDelay(sec): {}", (Object)initialDelay);
            LOG.debug("Setting retries(sec): {}", (Object)retries);
            return new SimpleQueuedProvisioningAdapter.AdapterOperationSchedule(initialDelay, 60L, retries, TimeUnit.SECONDS);
        }
        return new SimpleQueuedProvisioningAdapter.AdapterOperationSchedule();
    }

    public void afterPropertiesSet() throws Exception {
        RWSClientApi.init();
        Assert.notNull((Object)this.m_rwsConfig, (String)"Rancid Provisioning Adapter requires RWSConfig property to be set.");
        this.m_cp = this.getRWSConnection();
        Assert.notNull((Object)this.m_nodeDao, (String)"Rancid Provisioning Adapter requires nodeDao property to be set.");
        this.getRancidCategories();
        this.m_template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus arg0) {
                RancidProvisioningAdapter.this.buildRancidNodeMap();
            }
        });
    }

    private void getRancidCategories() {
        block4: {
            try {
                this.m_rancid_categories = RWSClientApi.getRWSResourceDeviceTypesPatternList((ConnectionProperties)this.m_cp).getResource();
            }
            catch (RancidApiException e) {
                ConnectionProperties cp = this.getStandByRWSConnection();
                if (cp == null) break block4;
                try {
                    this.m_rancid_categories = RWSClientApi.getRWSResourceDeviceTypesPatternList((ConnectionProperties)this.m_cp).getResource();
                }
                catch (RancidApiException e1) {
                    LOG.warn("getRancidCategories: not able to retrieve rancid categories from RWS server");
                    this.m_rancid_categories = new ArrayList<String>();
                    this.m_rancid_categories.add("cisco");
                    LOG.warn("getRancidCategories: setting categories list to 'cisco'");
                }
            }
        }
    }

    private void buildRancidNodeMap() {
        List nodes = this.m_nodeDao.findAllProvisionedNodes();
        m_onmsNodeRancidNodeMap = new ConcurrentHashMap<Integer, RancidNode>(nodes.size());
        m_onmsNodeIpMap = new ConcurrentHashMap<Integer, String>(nodes.size());
        for (OnmsNode onmsNode : nodes) {
            RancidNode rNode;
            String ipaddr = this.getSuitableIpForRancid(onmsNode);
            if (ipaddr != null) {
                m_onmsNodeIpMap.putIfAbsent(onmsNode.getId(), ipaddr);
            }
            if ((rNode = this.getSuitableRancidNode(onmsNode)) == null) continue;
            m_onmsNodeRancidNodeMap.putIfAbsent(onmsNode.getId(), rNode);
        }
    }

    private ConnectionProperties getRWSConnection() {
        return this.m_rwsConfig.getBase();
    }

    private ConnectionProperties getStandByRWSConnection() {
        return this.m_rwsConfig.getNextStandBy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAdd(int nodeId, ConnectionProperties cp, boolean retry) throws ProvisioningAdapterException {
        if (!this.isAdapterConfigured()) {
            return;
        }
        LOG.debug("doAdd: adding nodeid: {}", (Object)nodeId);
        final OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        Assert.notNull((Object)node, (String)("doAdd: failed to return node for given nodeId:" + nodeId));
        String ipaddress = (String)this.m_template.execute((TransactionCallback)new TransactionCallback<String>(){

            public String doInTransaction(TransactionStatus arg0) {
                return RancidProvisioningAdapter.this.getSuitableIpForRancid(node);
            }
        });
        RancidNode rNode = this.getSuitableRancidNode(node);
        rNode.setStateUp(true);
        try {
            this.m_rwsConfig.getWriteLock().lock();
            try {
                if (m_onmsNodeRancidNodeMap.containsValue(rNode)) {
                    LOG.error("doAdd: Error Duplicate node: {}", (Object)node);
                    ProvisioningAdapterException e = new ProvisioningAdapterException("Duplicate node has been added: " + node);
                    this.sendAndThrow(nodeId, e);
                    return;
                }
                LOG.debug("doAdd: adding to router.db node: {}", (Object)node.getLabel());
                RWSClientApi.createRWSRancidNode((ConnectionProperties)cp, (RancidNode)rNode);
                m_onmsNodeIpMap.putIfAbsent(nodeId, ipaddress);
                m_onmsNodeRancidNodeMap.put(nodeId, rNode);
                RWSClientApi.createOrUpdateRWSAuthNode((ConnectionProperties)cp, (RancidNodeAuthentication)rNode.getAuth());
            }
            finally {
                this.m_rwsConfig.getWriteLock().unlock();
            }
        }
        catch (ProvisioningAdapterException ae) {
            this.sendAndThrow(nodeId, ae);
        }
        catch (Throwable e) {
            cp = this.getStandByRWSConnection();
            if (retry && cp != null) {
                LOG.info("doAdd: retry Add on standByConn: {}", (Object)cp.getUrl());
                this.doAdd(nodeId, cp, false);
            }
            this.sendAndThrow(nodeId, e);
        }
    }

    public void doUpdate(int nodeId, ConnectionProperties cp, boolean retry) throws ProvisioningAdapterException {
        block19: {
            if (!this.isAdapterConfigured()) {
                return;
            }
            LOG.debug("doUpdate: updating nodeid: {}", (Object)nodeId);
            RancidNode rLocalNode = (RancidNode)m_onmsNodeRancidNodeMap.get(nodeId);
            LOG.debug("doUpdate: found local map Node: {}", (Object)rLocalNode);
            final OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
            Assert.notNull((Object)node, (String)("doUpdate: failed to return node for given nodeId:" + nodeId));
            String ipaddress = (String)this.m_template.execute((TransactionCallback)new TransactionCallback<String>(){

                public String doInTransaction(TransactionStatus arg0) {
                    return RancidProvisioningAdapter.this.getSuitableIpForRancid(node);
                }
            });
            m_onmsNodeIpMap.put(nodeId, ipaddress);
            RancidNode rUpdatedNode = this.getSuitableRancidNode(node);
            LOG.debug("doUpdate: found updated Node : {}", (Object)rUpdatedNode);
            if (rLocalNode.getDeviceName() == null) {
                LOG.warn("Current Rancid Node device name is null, aborting.");
                return;
            }
            if (rUpdatedNode.getDeviceName() == null) {
                LOG.warn("Updated Rancid Node device name is null, aborting.");
                return;
            }
            if (rLocalNode.getDeviceName().equalsIgnoreCase(rUpdatedNode.getDeviceName())) {
                try {
                    RancidNode rRemoteNode = RWSClientApi.getRWSRancidNodeTLO((ConnectionProperties)cp, (String)rLocalNode.getGroup(), (String)rLocalNode.getDeviceName());
                    RancidNodeAuthentication rRemoteNodeAuth = RWSClientApi.getRWSAuthNode((ConnectionProperties)cp, (String)rLocalNode.getDeviceName());
                    LOG.debug("doUpdate: found Node in router.db : {}", (Object)rRemoteNode);
                    if (!rUpdatedNode.getDeviceType().equalsIgnoreCase(rRemoteNode.getDeviceType())) {
                        try {
                            rUpdatedNode.setStateUp(rRemoteNode.isStateUp());
                            LOG.debug("doUpdate: updating router.db");
                            RWSClientApi.updateRWSRancidNode((ConnectionProperties)cp, (RancidNode)rLocalNode);
                        }
                        catch (Throwable e) {
                            LOG.error("doUpdate: failed to update node: {} Exception: {}", (Object)e.getMessage(), (Object)nodeId);
                        }
                    }
                    if (this.updateAuth(rUpdatedNode.getAuth(), rRemoteNodeAuth)) {
                        LOG.debug("doUpdate: updating authentication data");
                        try {
                            RWSClientApi.updateRWSAuthNode((ConnectionProperties)cp, (RancidNodeAuthentication)rUpdatedNode.getAuth());
                        }
                        catch (Throwable e) {
                            LOG.error("doUpdate: Failed to update node authentication data: {} Exception: {}", (Object)e.getMessage(), (Object)nodeId);
                        }
                    }
                    rUpdatedNode.setStateUp(rLocalNode.isStateUp());
                    m_onmsNodeRancidNodeMap.put(nodeId, rUpdatedNode);
                }
                catch (RancidApiException re) {
                    if (re.getRancidCode() == RancidApiException.RWS_RESOURCE_NOT_FOUND) {
                        LOG.warn("doUpdate: node not found in router.db: {}", (Object)rUpdatedNode);
                        try {
                            LOG.debug("doUpdate: adding Node to router.db for nodeid: {}", (Object)nodeId);
                            rUpdatedNode.setStateUp(true);
                            RWSClientApi.createRWSRancidNode((ConnectionProperties)cp, (RancidNode)rUpdatedNode);
                            RWSClientApi.createOrUpdateRWSAuthNode((ConnectionProperties)cp, (RancidNodeAuthentication)rUpdatedNode.getAuth());
                            m_onmsNodeRancidNodeMap.put(nodeId, rUpdatedNode);
                        }
                        catch (RancidApiException e) {
                            LOG.error("doUpdate: Failed to create node: {} Exception: {}", (Object)e.getMessage(), (Object)nodeId);
                            this.sendAndThrow(nodeId, e);
                        }
                        break block19;
                    }
                    cp = this.getStandByRWSConnection();
                    if (retry && cp != null) {
                        LOG.info("doUpdate: retry Update on standByConn: {}", (Object)cp.getUrl());
                        this.doUpdate(nodeId, cp, false);
                        break block19;
                    }
                    this.sendAndThrow(nodeId, re);
                }
            } else {
                LOG.debug("doUpdate: the device name is changed for Nodeid: {}", (Object)nodeId);
                LOG.debug("doUpdate: calling doDelete for NodeId: {}", (Object)nodeId);
                this.doDelete(nodeId, cp, retry);
                try {
                    LOG.debug("doUpdate: adding Node to router.db for nodeid: {}", (Object)nodeId);
                    rUpdatedNode.setStateUp(true);
                    RWSClientApi.createRWSRancidNode((ConnectionProperties)cp, (RancidNode)rUpdatedNode);
                    RWSClientApi.createOrUpdateRWSAuthNode((ConnectionProperties)cp, (RancidNodeAuthentication)rUpdatedNode.getAuth());
                    m_onmsNodeRancidNodeMap.put(nodeId, rUpdatedNode);
                    m_onmsNodeIpMap.put(nodeId, ipaddress);
                }
                catch (RancidApiException e) {
                    LOG.error("doUpdate: Failed to create node: {} Exception: {}", (Object)e.getMessage(), (Object)nodeId);
                    this.sendAndThrow(nodeId, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDelete(int nodeId, ConnectionProperties cp, boolean retry) throws ProvisioningAdapterException {
        if (!this.isAdapterConfigured()) {
            return;
        }
        LOG.debug("doDelete: deleting nodeid: {}", (Object)nodeId);
        try {
            this.m_rwsConfig.getWriteLock().lock();
            try {
                if (m_onmsNodeRancidNodeMap.containsKey(nodeId)) {
                    RancidNode rNode = (RancidNode)m_onmsNodeRancidNodeMap.get(nodeId);
                    RWSClientApi.deleteRWSRancidNode((ConnectionProperties)cp, (RancidNode)rNode);
                    RWSClientApi.deleteRWSAuthNode((ConnectionProperties)cp, (RancidNodeAuthentication)rNode.getAuth());
                    m_onmsNodeRancidNodeMap.remove(nodeId);
                    m_onmsNodeIpMap.remove(nodeId);
                } else {
                    LOG.warn("doDelete: no device found in node Rancid Map for nodeid: {}", (Object)nodeId);
                }
            }
            finally {
                this.m_rwsConfig.getWriteLock().unlock();
            }
        }
        catch (Throwable e) {
            cp = this.getStandByRWSConnection();
            if (retry && cp != null) {
                LOG.info("doDelete: retry Delete on standByConn: {}", (Object)cp.getUrl());
                this.doDelete(nodeId, cp, false);
            }
            this.sendAndThrow(nodeId, e);
        }
    }

    public void doNodeConfigChanged(int nodeId, ConnectionProperties cp, boolean retry) throws ProvisioningAdapterException {
        if (!this.isAdapterConfigured()) {
            return;
        }
        LOG.debug("doNodeConfigChanged: nodeid: {}", (Object)nodeId);
        if (m_onmsNodeRancidNodeMap.containsKey(nodeId)) {
            this.updateConfiguration(nodeId, (RancidNode)m_onmsNodeRancidNodeMap.get(nodeId), cp, retry);
        } else {
            LOG.warn("doNodeConfigChanged: No node found in nodeRancid Map for nodeid: {}", (Object)nodeId);
        }
    }

    private void updateConfiguration(int nodeid, RancidNode rNode, ConnectionProperties cp, boolean retry) throws ProvisioningAdapterException {
        LOG.debug("updateConfiguration: Updating Rancid Router.db configuration for node: {} type: {} group: {}", new Object[]{rNode.getGroup(), rNode.getDeviceName(), rNode.getDeviceType()});
        try {
            RWSClientApi.updateRWSRancidNode((ConnectionProperties)cp, (RancidNode)rNode);
        }
        catch (Throwable e) {
            cp = this.getStandByRWSConnection();
            if (retry && cp != null) {
                LOG.info("updateConfiguration: retry update on standByConn: {}", (Object)cp.getUrl());
                this.updateConfiguration(nodeid, rNode, cp, false);
            }
            this.sendAndThrow(nodeid, e);
        }
    }

    private void sendAndThrow(int nodeId, Throwable e) {
        LOG.debug("sendAndThrow: error working on nodeid: {}", (Object)nodeId);
        LOG.debug("sendAndThrow: Exception: {}", (Object)e.getMessage());
        Event event = this.buildEvent("uei.opennms.org/provisioner/provisioningAdapterFailed", nodeId).addParam("reason", MESSAGE_PREFIX + e.getLocalizedMessage()).getEvent();
        this.m_eventForwarder.sendNow(event);
        throw new ProvisioningAdapterException(MESSAGE_PREFIX, e);
    }

    private EventBuilder buildEvent(String uei, int nodeId) {
        EventBuilder builder = new EventBuilder(uei, "Provisioner", new Date());
        builder.setNodeid((long)nodeId);
        return builder;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao dao) {
        this.m_nodeDao = dao;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public RWSConfig getRwsConfig() {
        return this.m_rwsConfig;
    }

    public void setRwsConfig(RWSConfig rwsConfig) {
        this.m_rwsConfig = rwsConfig;
    }

    public RancidAdapterConfig getRancidAdapterConfig() {
        return this.m_rancidAdapterConfig;
    }

    public void setRancidAdapterConfig(RancidAdapterConfig rancidAdapterConfig) {
        this.m_rancidAdapterConfig = rancidAdapterConfig;
    }

    public String getName() {
        return "RancidProvisioningAdapter";
    }

    private String getSuitableIpForRancid(OnmsNode node) {
        LOG.debug("getSuitableIpForRancid: node: {} Foreign Source: {}", (Object)node.getForeignSource(), (Object)node.getNodeId());
        OnmsIpInterface primaryInterface = node.getPrimaryInterface();
        String ipaddr = "127.0.0.1";
        if (primaryInterface == null) {
            LOG.debug("getSuitableIpForRancid: found null SNMP Primary Interface, getting interfaces");
            Set ipInterfaces = node.getIpInterfaces();
            for (OnmsIpInterface onmsIpInterface : ipInterfaces) {
                LOG.debug("getSuitableIpForRancid: trying Interface with id: {}", (Object)onmsIpInterface.getId());
                if (onmsIpInterface.getIpAddress() != null) {
                    ipaddr = InetAddressUtils.str((InetAddress)onmsIpInterface.getIpAddress());
                    continue;
                }
                LOG.debug("getSuitableIpForRancid: found null ip address on Interface with id: {}", (Object)onmsIpInterface.getId());
            }
        } else {
            LOG.debug("getSuitableIpForRancid: found SNMP Primary Interface");
            if (primaryInterface.getIpAddress() != null) {
                ipaddr = InetAddressUtils.str((InetAddress)primaryInterface.getIpAddress());
            } else {
                LOG.debug("getSuitableIpForRancid: found null ip address on Primary Interface");
            }
        }
        return ipaddr;
    }

    private RancidNode getSuitableRancidNode(OnmsNode node) {
        String group = node.getForeignSource();
        if (group == null) {
            return null;
        }
        RancidNode r_node = new RancidNode(group, node.getLabel());
        String ipaddress = (String)m_onmsNodeIpMap.get(node.getId());
        if (this.m_rancidAdapterConfig.useCategories(ipaddress)) {
            LOG.debug("getSuitableRancidNode: Using Categories to get Rancid devicetype for node: {}", (Object)node.getLabel());
            r_node.setDeviceType(this.getTypeFromCategories(node));
        } else {
            LOG.debug("getSuitableRancidNode: Using Sysoid to get Rancid devicetype for node: {}", (Object)node.getLabel());
            r_node.setDeviceType(this.getTypeFromSysObjectId(node.getSysObjectId(), node.getSysDescription()));
        }
        r_node.setStateUp(false);
        r_node.setComment("node provisioned by opennms nodeid:" + node.getNodeId());
        r_node.setAuth(this.getSuitableRancidNodeAuthentication(node));
        return r_node;
    }

    private String getTypeFromSysObjectId(String sysoid, String sysdescr) {
        String rancidType = this.m_rancidAdapterConfig.getType(sysoid, sysdescr);
        LOG.debug("getTypeFromSysObjectId: sysOid {}, sysDescr {}, Rancid devicetype found: {} ", new Object[]{sysoid, sysdescr, rancidType});
        return rancidType;
    }

    private String getTypeFromCategories(OnmsNode node) {
        for (String rancidType : this.m_rancid_categories) {
            for (OnmsCategory nodecategory : node.getCategories()) {
                if (!nodecategory.getName().equalsIgnoreCase(rancidType)) continue;
                LOG.debug("getTypeFromCategories: Found Matching Category: Rancid devicetype found: {}", (Object)rancidType);
                return rancidType;
            }
        }
        LOG.warn("getTypeFromCategories: No Matching Category found: trying to get devicetype using config file");
        return this.getTypeFromCategories(node);
    }

    private RancidNodeAuthentication getSuitableRancidNodeAuthentication(OnmsNode node) {
        RancidNodeAuthentication r_auth_node = new RancidNodeAuthentication();
        r_auth_node.setDeviceName(node.getLabel());
        OnmsAssetRecord asset_node = node.getAssetRecord();
        if (asset_node == null) {
            return r_auth_node;
        }
        if (asset_node.getUsername() != null) {
            r_auth_node.setUser(asset_node.getUsername());
        }
        if (asset_node.getPassword() != null) {
            r_auth_node.setPassword(asset_node.getPassword());
        }
        if (asset_node.getEnable() != null) {
            r_auth_node.setEnablePass(asset_node.getEnable());
        }
        if (asset_node.getAutoenable() != null) {
            r_auth_node.setAutoEnable(asset_node.getAutoenable().equals("A"));
        }
        if (asset_node.getConnection() != null) {
            r_auth_node.setConnectionMethod(asset_node.getConnection());
        } else {
            r_auth_node.setConnectionMethod("telnet");
        }
        return r_auth_node;
    }

    public boolean isNodeReady(SimpleQueuedProvisioningAdapter.AdapterOperation op) {
        boolean ready = true;
        if (op.getType() == SimpleQueuedProvisioningAdapter.AdapterOperationType.CONFIG_CHANGE) {
            ready = this.m_rancidAdapterConfig.isCurTimeInSchedule((String)m_onmsNodeIpMap.get(op.getNodeId()));
        }
        LOG.debug("isNodeReady: {} For Operation {} for node: {}", new Object[]{op.getNodeId(), ready, op.getType()});
        return ready;
    }

    public void processPendingOperationForNode(final SimpleQueuedProvisioningAdapter.AdapterOperation op) throws ProvisioningAdapterException {
        LOG.debug("processPendingOperationForNode: {} for node: {}", (Object)op.getNodeId(), (Object)op.getType());
        if (op.getType() == SimpleQueuedProvisioningAdapter.AdapterOperationType.ADD) {
            this.m_template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                public void doInTransactionWithoutResult(TransactionStatus arg0) {
                    RancidProvisioningAdapter.this.doAdd(op.getNodeId(), RancidProvisioningAdapter.this.m_cp, true);
                }
            });
        } else if (op.getType() == SimpleQueuedProvisioningAdapter.AdapterOperationType.UPDATE) {
            this.m_template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                public void doInTransactionWithoutResult(TransactionStatus arg0) {
                    RancidProvisioningAdapter.this.doUpdate(op.getNodeId(), RancidProvisioningAdapter.this.m_cp, true);
                }
            });
        } else if (op.getType() == SimpleQueuedProvisioningAdapter.AdapterOperationType.DELETE) {
            this.m_template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                public void doInTransactionWithoutResult(TransactionStatus arg0) {
                    RancidProvisioningAdapter.this.doDelete(op.getNodeId(), RancidProvisioningAdapter.this.m_cp, true);
                }
            });
        } else if (op.getType() == SimpleQueuedProvisioningAdapter.AdapterOperationType.CONFIG_CHANGE) {
            this.m_template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                public void doInTransactionWithoutResult(TransactionStatus arg0) {
                    RancidProvisioningAdapter.this.doNodeConfigChanged(op.getNodeId(), RancidProvisioningAdapter.this.m_cp, true);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadConfigEvent(Event event) {
        if (this.isReloadConfigEventTarget(event)) {
            EventBuilder ebldr = null;
            LOG.debug("reloading the rancid adapter configuration");
            try {
                RancidAdapterConfigFactory.init();
                RancidAdapterConfigFactory factory = RancidAdapterConfigFactory.getInstance();
                factory.getWriteLock().lock();
                try {
                    factory.update();
                    this.m_template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                        public void doInTransactionWithoutResult(TransactionStatus arg0) {
                            RancidProvisioningAdapter.this.buildRancidNodeMap();
                        }
                    });
                }
                finally {
                    factory.getWriteLock().unlock();
                }
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", "Provisiond.RancidProvisioningAdapter");
                ebldr.addParam("daemonName", "Provisiond.RancidProvisioningAdapter");
            }
            catch (Throwable e) {
                LOG.info("unable to reload rancid adapter configuration", e);
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", "Provisiond.RancidProvisioningAdapter");
                ebldr.addParam("daemonName", "Provisiond.RancidProvisioningAdapter");
                ebldr.addParam("reason", e.getLocalizedMessage().substring(1, 128));
            }
            if (ebldr != null) {
                this.getEventForwarder().sendNow(ebldr.getEvent());
            }
        }
    }

    private boolean isReloadConfigEventTarget(Event event) {
        boolean isTarget = false;
        List parmCollection = event.getParmCollection();
        for (Parm parm : parmCollection) {
            if (!"daemonName".equals(parm.getParmName()) || !"Provisiond.RancidProvisioningAdapter".equalsIgnoreCase(parm.getValue().getContent())) continue;
            isTarget = true;
            break;
        }
        LOG.debug("isReloadConfigEventTarget: Provisiond.RancidProvisioningAdapter was target of reload event: {}", (Object)isTarget);
        return isTarget;
    }

    @EventHandler(uei="uei.opennms.org/standard/rancid/traps/rancidTrapDownloadFailure")
    public void handleRancidDownLoadFailure(Event e) {
        LOG.debug("handleRancidDownLoadFailure: get Event uei/id: {} / {}", (Object)e.getDbid(), (Object)e.getUei());
        if (e.hasNodeid()) {
            int nodeId = Long.valueOf(e.getNodeid()).intValue();
            if (m_onmsNodeRancidNodeMap.containsKey(nodeId)) {
                this.updateRancidNodeState(nodeId, false);
            } else {
                LOG.warn("node does not exist with nodeid: {}", (Object)e.getNodeid());
            }
        }
    }

    @EventHandler(uei="uei.opennms.org/standard/rancid/traps/rancidTrapDownloadSuccess")
    public void handleRancidDownLoadSuccess(Event e) {
        LOG.debug("handleRancidDownLoadSuccess: get Event uei/id: {} / {}", (Object)e.getDbid(), (Object)e.getUei());
        if (e.hasNodeid()) {
            int nodeId = Long.valueOf(e.getNodeid()).intValue();
            if (m_onmsNodeRancidNodeMap.containsKey(nodeId)) {
                this.updateRancidNodeState(nodeId, false);
            } else {
                LOG.warn("node does not exist with nodeid: {}", (Object)e.getNodeid());
            }
        }
    }

    @EventHandler(uei="uei.opennms.org/standard/rancid/traps/rancidTrapGroupProcessingCompleted")
    public void handleRancidGroupProcessingCompleted(Event e) {
        LOG.debug("handleRancidGroupProcessingCompleted: get Event uei/id: {} / {}", (Object)e.getDbid(), (Object)e.getUei());
        for (Parm parm : e.getParmCollection()) {
            LOG.debug("handleRancidGroupProcessingCompleted: parm name: {}", (Object)parm.getParmName());
            if (!parm.getParmName().equals(".1.3.6.1.4.1.31543.1.1.2.1.1.3")) continue;
            this.updateGroupConfiguration(parm.getValue().getContent());
            break;
        }
    }

    private void updateGroupConfiguration(String group) {
        for (Integer nodeId : m_onmsNodeRancidNodeMap.keySet()) {
            RancidNode rnode = (RancidNode)m_onmsNodeRancidNodeMap.get(nodeId);
            if (!group.equals(rnode.getGroup())) continue;
            boolean stateUp = rnode.isStateUp();
            rnode.setStateUp(false);
            try {
                this.updateConfiguration(nodeId, rnode, this.m_cp, true);
            }
            catch (ProvisioningAdapterException pae) {
                LOG.error("updateGroupConfiguration: group: " + group + "failed set down for rancid node: " + rnode.getDeviceName() + "Reason: " + pae.getMessage());
            }
            rnode.setStateUp(stateUp);
        }
    }

    private void updateRancidNodeState(int nodeid, boolean up) {
        RancidNode rnode = (RancidNode)m_onmsNodeRancidNodeMap.get(nodeid);
        rnode.setStateUp(up);
        m_onmsNodeRancidNodeMap.put(nodeid, rnode);
    }

    private boolean updateAuth(RancidNodeAuthentication localNode, RancidNodeAuthentication remoteNode) {
        if (!localNode.getUser().equals(remoteNode.getUser())) {
            return true;
        }
        if (!localNode.getPassword().equals(remoteNode.getPassword())) {
            return true;
        }
        if (!localNode.getEnablePass().equals(remoteNode.getEnablePass())) {
            return true;
        }
        if (!localNode.getConnectionMethodString().equalsIgnoreCase(remoteNode.getConnectionMethodString())) {
            return true;
        }
        if (localNode.isAutoEnable()) {
            return !remoteNode.isAutoEnable();
        }
        if (!localNode.isAutoEnable()) {
            return remoteNode.isAutoEnable();
        }
        return false;
    }

    private boolean isAdapterConfigured() {
        if ("http://rws-not-configured".equals(this.m_rwsConfig.getBaseUrl().getServer_url())) {
            LOG.debug("Not taking any action because server_url is set to http://rws-not-configured");
            return false;
        }
        return true;
    }
}

